/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.common.http;

import com.github.kevinsawicki.http.HttpRequest;
import java.io.IOException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import me.hao0.common.exception.HttpsException;
import me.hao0.common.util.Strings;

public final class Https {
    private HttpsURLConnection connection;
    private int connectTimeout = 5000;
    private int readTimeout = 5000;
    private String contentType = "";
    private String acceptCharset = "UTF-8";
    private String acceptType = "text/plain";
    private String connectType = "close";
    private String body = "";
    private String bodyCharset = "UTF-8";
    private boolean encode = true;
    private boolean gzip = false;

    private Https() {
    }

    public Https connectTimeout(int secs) {
        this.connection.setConnectTimeout(secs * 1000);
        return this;
    }

    public Https readTimeout(int secs) {
        this.readTimeout = secs * 1000;
        return this;
    }

    public Https contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public Https acceptType(String acceptType) {
        this.acceptType = acceptType;
        return this;
    }

    public Https acceptCharset(String acceptCharset) {
        this.acceptCharset = acceptCharset;
        return this;
    }

    public Https connectType(String connectType) {
        this.connectType = connectType;
        return this;
    }

    public Https useCache(boolean useCache) {
        this.connection.setUseCaches(useCache);
        return this;
    }

    public Https body(String body) {
        this.body = body;
        return this;
    }

    public Https bodyCharset(String charset) {
        this.bodyCharset = charset;
        return this;
    }

    public Https ssLSocketFactory(SSLSocketFactory factory) {
        this.connection.setSSLSocketFactory(factory);
        return this;
    }

    public Https header(String name, String value) {
        this.connection.setRequestProperty(name, value);
        return this;
    }

    public String request() {
        this.prepareRequest();
        return this.doRequest();
    }

    private void prepareRequest() {
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setConnectTimeout(this.connectTimeout);
        this.connection.setReadTimeout(this.readTimeout);
        this.header("Accept-Charset", this.acceptCharset);
        this.header("Connection", this.connectType);
        if (this.gzip) {
            this.header("Accept-Encoding", "gzip, deflate");
        }
        if (!Strings.isNullOrEmpty(this.contentType).booleanValue()) {
            this.header("Content-Type", this.connectType);
        }
        if (!Strings.isNullOrEmpty(this.acceptType).booleanValue()) {
            this.header("Accept", this.acceptType);
        }
        if (!Strings.isNullOrEmpty(this.body).booleanValue()) {
            this.header("Content-Length", String.valueOf(this.body.length()));
        }
    }

    /*
     * Exception decompiling
     */
    private String doRequest() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Https get(String url) {
        return Https.get(url, true);
    }

    public static Https get(String url, Boolean encode) {
        Https https = new Https();
        https.connection = Https.createConnection(url, "GET", encode);
        return https;
    }

    public static Https post(String url) {
        return Https.post(url, true);
    }

    public static Https post(String url, Boolean encode) {
        Https https = new Https();
        https.connection = Https.createConnection(url, "POST", encode);
        return https;
    }

    private static HttpsURLConnection createConnection(String url, String method, Boolean encode) {
        try {
            URL u = new URL(encode != false ? HttpRequest.encode((CharSequence)url) : url);
            HttpsURLConnection conn = (HttpsURLConnection)u.openConnection();
            conn.setRequestMethod(method);
            return conn;
        }
        catch (IOException e) {
            throw new HttpsException(e);
        }
    }
}

