/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.common.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import me.hao0.common.exception.JsonException;
import me.hao0.common.util.Strings;

public class Jsons {
    public static final Jsons EXCLUDE_EMPTY = new Jsons(JsonInclude.Include.NON_EMPTY);
    public static final Jsons EXCLUDE_DEFAULT = new Jsons(JsonInclude.Include.NON_DEFAULT);
    public static final Jsons DEFAULT = new Jsons();
    private ObjectMapper mapper = new ObjectMapper();

    private Jsons() {
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private Jsons(JsonInclude.Include include) {
        this.mapper.setSerializationInclusion(include);
        this.mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public String toJson(Object target) {
        try {
            return this.mapper.writeValueAsString(target);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public <T> T fromJson(String json, Class<T> target) {
        if (Strings.isNullOrEmpty(json).booleanValue()) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, target);
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public <T> T fromJson(String jsonString, JavaType javaType) {
        if (Strings.isNullOrEmpty(jsonString).booleanValue()) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(jsonString, javaType);
        }
        catch (Exception e) {
            throw new JsonException(e);
        }
    }

    public JavaType createCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return this.mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }
}

