/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.common.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import me.hao0.common.exception.XmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlReaders {
    private static DocumentBuilder builder;
    private Document document;

    private XmlReaders() {
    }

    public static XmlReaders create(String xml) {
        return XmlReaders.create(xml, "UTF-8");
    }

    public static XmlReaders create(String xml, String encode) {
        try {
            return XmlReaders.create(new ByteArrayInputStream(xml.getBytes(encode)));
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlException(e);
        }
    }

    public static XmlReaders create(InputStream inputStream) {
        XmlReaders readers = new XmlReaders();
        try {
            readers.document = builder.parse(inputStream);
        }
        catch (Exception e) {
            throw new XmlException("Xmls create fail", e);
        }
        return readers;
    }

    public Node getNode(String tagName) {
        NodeList nodes = this.document.getElementsByTagName(tagName);
        if (nodes.getLength() <= 0) {
            return null;
        }
        return nodes.item(0);
    }

    public NodeList getNodes(String tagName) {
        NodeList nodes = this.document.getElementsByTagName(tagName);
        if (nodes.getLength() <= 0) {
            return null;
        }
        return nodes;
    }

    public String getNodeStr(String tagName) {
        Node node = this.getNode(tagName);
        return node == null ? null : node.getTextContent();
    }

    public Integer getNodeInt(String tagName) {
        String nodeContent = this.getNodeStr(tagName);
        return nodeContent == null ? null : Integer.valueOf(nodeContent);
    }

    public Long getNodeLong(String tagName) {
        String nodeContent = this.getNodeStr(tagName);
        return nodeContent == null ? null : Long.valueOf(nodeContent);
    }

    public Float getNodeFloat(String tagName) {
        String nodeContent = this.getNodeStr(tagName);
        return nodeContent == null ? null : Float.valueOf(nodeContent);
    }

    static {
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("init xml failed");
        }
    }
}

