/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.client;

import com.google.common.base.Converter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hao0.common.util.Fields;
import me.hao0.diablo.client.AbstractDiabloClient;
import me.hao0.diablo.client.DiabloConfig;
import me.hao0.diablo.common.convert.Converters;
import me.hao0.diablo.common.model.ConfigItem;
import me.hao0.diablo.common.util.CollectionUtil;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class SpringDiabloClient
extends AbstractDiabloClient
implements InitializingBean,
DisposableBean {
    private Map<String, Set<ConfigItemBean>> configItemBeans = Maps.newHashMap();
    @Autowired
    private ApplicationContext springContext;

    protected Set<String> initConfigNames() {
        Map configBeans = this.springContext.getBeansOfType(DiabloConfig.class);
        if (configBeans.isEmpty()) {
            return Collections.emptySet();
        }
        for (DiabloConfig configBean : configBeans.values()) {
            this.resolveConfigBeanItem(configBean);
        }
        return this.configItemBeans.keySet();
    }

    private void resolveConfigBeanItem(DiabloConfig configBean) {
        Class<?> beanClazz = configBean.getClass();
        Field[] configItemFields = beanClazz.getDeclaredFields();
        if (configItemFields.length == 0) {
            return;
        }
        for (Field configItemField : configItemFields) {
            String configName = configItemField.getName();
            ConfigItemBean configItemBean = new ConfigItemBean(configBean, configItemField, Converters.determine((Field)configItemField));
            HashSet configItemBeanSet = this.configItemBeans.get(configName);
            if (configItemBeanSet == null) {
                configItemBeanSet = Sets.newHashSet();
                this.configItemBeans.put(configName, configItemBeanSet);
            }
            configItemBeanSet.add(configItemBean);
        }
    }

    protected void onConfigsUpdated(List<ConfigItem> updates) {
        if (!CollectionUtil.isEmpty(updates)) {
            for (ConfigItem update : updates) {
                Set<ConfigItemBean> configItemBeanSet = this.configItemBeans.get(update.getName());
                if (configItemBeanSet == null) continue;
                for (ConfigItemBean c : configItemBeanSet) {
                    Fields.put((Object)c.bean, (Field)c.configItem, (Object)c.converter.convert((Object)update.getValue()));
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.shutdown();
    }

    private class ConfigItemBean {
        DiabloConfig bean;
        Field configItem;
        Converter<String, ?> converter;

        ConfigItemBean(DiabloConfig bean, Field configItem, Converter<String, ?> converter) {
            this.bean = bean;
            this.configItem = configItem;
            this.converter = converter;
        }
    }
}

