/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.client;

import com.google.common.base.Converter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hao0.common.util.Preconditions;
import me.hao0.diablo.client.DiabloAgent;
import me.hao0.diablo.client.DiabloWorker;
import me.hao0.diablo.client.listener.ConfigListener;
import me.hao0.diablo.common.convert.Converters;
import me.hao0.diablo.common.model.ConfigItem;
import me.hao0.diablo.common.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDiabloClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractDiabloClient.class);
    private String appName;
    private String appKey;
    private String servers;
    private int pullingTimeout = 30;
    private final Map<String, String> configMd5s = Maps.newHashMap();
    private Map<String, ConfigListenerWrapper> listeners = Maps.newHashMap();
    private volatile boolean inited;
    private volatile boolean destoryed;
    DiabloAgent agent;
    DiabloWorker worker;

    AbstractDiabloClient() {
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getServers() {
        return this.servers;
    }

    public int getPullingTimeout() {
        return this.pullingTimeout;
    }

    public void setAppName(String appName) {
        Preconditions.checkNotNullAndEmpty((String)appName, (String)"appName");
        this.appName = appName;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setServers(String servers) {
        Preconditions.checkNotNullAndEmpty((String)servers, (String)"servers");
        this.servers = servers;
    }

    public void setListeners(List<ConfigListener> listeners) {
        if (!CollectionUtil.isEmpty(listeners)) {
            for (ConfigListener listener : listeners) {
                this.addListener(listener);
            }
        }
    }

    public void addListener(ConfigListener listener) {
        ConfigListenerWrapper listenerWrapper = this.wrapListener(listener);
        this.listeners.put(listener.name(), listenerWrapper);
    }

    private ConfigListenerWrapper wrapListener(ConfigListener listener) {
        Converter converter = Converters.determine((Object)listener);
        return new ConfigListenerWrapper(converter, listener);
    }

    public void start() {
        if (this.inited) {
            return;
        }
        this.agent = new DiabloAgent(this);
        this.agent.start();
        Set<String> needPullingConfigs = this.initConfigNames();
        List<ConfigItem> pullingConfigItems = CollectionUtil.isEmpty(needPullingConfigs) ? this.agent.fetchAllConfig() : this.agent.fetchConfigs(needPullingConfigs);
        if (CollectionUtil.isEmpty(pullingConfigItems)) {
            log.warn("there are no configs discovered, please check your config or remove diablo component.");
            return;
        }
        this.refreshConfigs(pullingConfigItems, false);
        this.worker = new DiabloWorker(this);
        this.worker.start();
        this.inited = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                AbstractDiabloClient.this.shutdown();
            }
        });
    }

    public void shutdown() {
        if (this.destoryed) {
            return;
        }
        this.agent.unRegister();
        this.destoryed = true;
    }

    void pullingConfigs() {
        Set<String> updatedConfigs = this.pullingUpdatedConfigs(this.configMd5s);
        if (updatedConfigs != null && !updatedConfigs.isEmpty()) {
            List<ConfigItem> configItems = this.fetchConfigs(Sets.newHashSet(updatedConfigs));
            for (ConfigItem item : configItems) {
                this.configMd5s.put(item.getName(), item.getMd5());
            }
            this.refreshConfigs(configItems, true);
        }
    }

    private Set<String> pullingUpdatedConfigs(Map<String, String> configItemMaps) {
        return this.agent.pullingUpdatedConfigs(configItemMaps, this.pullingTimeout);
    }

    private List<ConfigItem> fetchConfigs(Set<String> names) {
        return this.agent.fetchConfigs(names);
    }

    private void refreshConfigs(List<ConfigItem> configItems, boolean notify) {
        for (ConfigItem configItem : configItems) {
            this.configMd5s.put(configItem.getName(), configItem.getMd5());
        }
        this.onConfigsUpdated(configItems);
        if (notify) {
            this.notifyListeners(configItems);
        }
    }

    private void notifyListeners(List<ConfigItem> configItems) {
        if (!this.listeners.isEmpty()) {
            for (ConfigItem item : configItems) {
                ConfigListenerWrapper wrapper = this.listeners.get(item.getName());
                if (wrapper == null) continue;
                wrapper.listener.onUpdate(wrapper.converter.convert((Object)item.getValue()));
            }
        }
    }

    abstract Set<String> initConfigNames();

    protected abstract void onConfigsUpdated(List<ConfigItem> var1);

    private class ConfigListenerWrapper {
        Converter converter;
        ConfigListener listener;

        ConfigListenerWrapper(Converter converter, ConfigListener listener) {
            this.converter = converter;
            this.listener = listener;
        }
    }
}

