/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.client;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hao0.common.util.Strings;
import me.hao0.diablo.client.AbstractDiabloClient;
import me.hao0.diablo.common.model.ConfigItem;
import me.hao0.diablo.common.util.JsonUtil;

public class SimpleDiabloClient
extends AbstractDiabloClient {
    private Map<String, String> configValues = Maps.newHashMap();
    private final Set<String> configNames;

    public SimpleDiabloClient() {
        this(null);
    }

    public SimpleDiabloClient(Set<String> configNames) {
        this.configNames = configNames;
    }

    @Override
    public Set<String> initConfigNames() {
        return this.configNames;
    }

    @Override
    public void onConfigsUpdated(List<ConfigItem> configItems) {
        if (configItems != null && !configItems.isEmpty()) {
            for (ConfigItem configItem : configItems) {
                this.configValues.put(configItem.getName(), configItem.getValue());
            }
        }
    }

    public String get(String configName) {
        return this.configValues.get(configName);
    }

    public <T> T get(String configName, Class<T> classType) {
        String configJson = this.configValues.get(configName);
        if (Strings.isNullOrEmpty((String)configJson).booleanValue()) {
            return null;
        }
        return (T)JsonUtil.INSTANCE.fromJson(configJson, classType);
    }
}

