/*
 * Decompiled with CFR 0.152.
 */
package me.hao0.diablo.common.convert;

import com.fasterxml.jackson.databind.JavaType;
import com.google.common.base.Converter;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.primitives.Shorts;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hao0.diablo.common.convert.BooleanConverter;
import me.hao0.diablo.common.convert.JavaTypeConverter;
import me.hao0.diablo.common.convert.JsonConverter;
import me.hao0.diablo.common.convert.StringConverter;
import me.hao0.diablo.common.util.JsonUtil;

public class Converters {
    public static Converter<String, ?> determine(Field field) {
        Class<?> clazz = field.getType();
        Converter<String, ?> converter = Converters.determinePrimitiveConverter(clazz);
        if (converter != null) {
            return converter;
        }
        if (List.class.equals(clazz) || Map.class.equals(clazz) || Set.class.equals(clazz)) {
            return Converters.determineCollectionConverter((ParameterizedType)field.getGenericType());
        }
        return new JsonConverter(clazz);
    }

    public static Converter<String, ?> determine(Object genericObj) {
        Type type = ((ParameterizedType)genericObj.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        Converter<String, ?> converter = Converters.determinePrimitiveConverter(type);
        if (converter != null) {
            return converter;
        }
        if (type instanceof ParameterizedType) {
            return Converters.determineCollectionConverter((ParameterizedType)type);
        }
        return new JsonConverter((Class)type);
    }

    public static Converter<String, ?> determinePrimitiveConverter(Type type) {
        if (String.class.equals((Object)type)) {
            return StringConverter.INSTANCE;
        }
        if (Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) {
            return BooleanConverter.INSTANCE;
        }
        if (Integer.class.equals((Object)type) || Integer.TYPE.equals(type)) {
            return Ints.stringConverter();
        }
        if (Long.class.equals((Object)type) || Long.TYPE.equals(type)) {
            return Longs.stringConverter();
        }
        if (Short.class.equals((Object)type) || Short.TYPE.equals(type)) {
            return Shorts.stringConverter();
        }
        if (Float.class.equals((Object)type) || Float.TYPE.equals(type)) {
            return Floats.stringConverter();
        }
        if (Double.class.equals((Object)type) || Double.TYPE.equals(type)) {
            return Doubles.stringConverter();
        }
        return null;
    }

    public static JavaTypeConverter determineCollectionConverter(ParameterizedType ptype) {
        JavaType javaType;
        Type rawType = ptype.getRawType();
        if (List.class.equals((Object)rawType)) {
            Class listGenericType = (Class)ptype.getActualTypeArguments()[0];
            javaType = JsonUtil.INSTANCE.createCollectionType(List.class, new Class[]{listGenericType});
        } else if (Set.class.equals((Object)rawType)) {
            Class setGenericType = (Class)ptype.getActualTypeArguments()[0];
            javaType = JsonUtil.INSTANCE.createCollectionType(Set.class, new Class[]{setGenericType});
        } else {
            Class mapKeyType = (Class)ptype.getActualTypeArguments()[0];
            Class mapValueType = (Class)ptype.getActualTypeArguments()[1];
            javaType = JsonUtil.INSTANCE.createCollectionType(Map.class, new Class[]{mapKeyType, mapValueType});
        }
        return new JavaTypeConverter(javaType);
    }
}

