/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.LoadBalancedConnectionProxy;
import com.mysql.jdbc.RandomBalanceStrategy;
import com.mysql.jdbc.StringUtils;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerAffinityStrategy
extends RandomBalanceStrategy {
    public static final String AFFINITY_ORDER = "serverAffinityOrder";
    public String[] affinityOrderedServers = null;

    @Override
    public void init(Connection conn, Properties props) throws SQLException {
        super.init(conn, props);
        String hosts = props.getProperty(AFFINITY_ORDER);
        if (!StringUtils.isNullOrEmpty(hosts)) {
            this.affinityOrderedServers = hosts.split(",");
        }
    }

    @Override
    public ConnectionImpl pickConnection(LoadBalancedConnectionProxy proxy, List<String> configuredHosts, Map<String, ConnectionImpl> liveConnections, long[] responseTimes, int numRetries) throws SQLException {
        if (this.affinityOrderedServers == null) {
            return super.pickConnection(proxy, configuredHosts, liveConnections, responseTimes, numRetries);
        }
        Map<String, Long> blackList = proxy.getGlobalBlacklist();
        for (String host : this.affinityOrderedServers) {
            if (!configuredHosts.contains(host) || blackList.containsKey(host)) continue;
            ConnectionImpl conn = liveConnections.get(host);
            if (conn != null) {
                return conn;
            }
            try {
                conn = proxy.createConnectionForHost(host);
                return conn;
            }
            catch (SQLException sqlEx) {
                if (!proxy.shouldExceptionTriggerConnectionSwitch(sqlEx)) continue;
                proxy.addToGlobalBlacklist(host);
            }
        }
        return super.pickConnection(proxy, configuredHosts, liveConnections, responseTimes, numRetries);
    }
}

