/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.PackageDefinitionStrategy;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.utility.JavaModule;
import net.bytebuddy.utility.JavaType;
import net.bytebuddy.utility.RandomString;

public interface ClassInjector {
    public static final boolean ALLOW_EXISTING_TYPES = false;

    public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> var1);

    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingInstrumentation
    implements ClassInjector {
        private static final String JAR = "jar";
        private static final String CLASS_FILE_EXTENSION = ".class";
        private final Instrumentation instrumentation;
        private final Target target;
        private final File folder;
        private final RandomString randomString;

        public static ClassInjector of(File folder, Target target, Instrumentation instrumentation) {
            return new UsingInstrumentation(folder, target, instrumentation, new RandomString());
        }

        protected UsingInstrumentation(File folder, Target target, Instrumentation instrumentation, RandomString randomString) {
            this.folder = folder;
            this.target = target;
            this.instrumentation = instrumentation;
            this.randomString = randomString;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            File jarFile = new File(this.folder, JAR + this.randomString.nextString() + "." + JAR);
            try {
                if (!jarFile.createNewFile()) {
                    throw new IllegalStateException("Cannot create file " + jarFile);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(jarFile));
                try {
                    for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                        jarOutputStream.write(entry.getValue());
                    }
                }
                finally {
                    jarOutputStream.close();
                }
                this.target.inject(this.instrumentation, new JarFile(jarFile));
                HashMap loaded = new HashMap();
                for (TypeDescription typeDescription : types.keySet()) {
                    loaded.put(typeDescription, Class.forName(typeDescription.getName(), false, ClassLoader.getSystemClassLoader()));
                }
                return loaded;
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot write jar file to disk", exception);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Cannot load injected class", exception);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            if (!this.instrumentation.equals(((UsingInstrumentation)object).instrumentation)) {
                return false;
            }
            if (!this.target.equals((Object)((UsingInstrumentation)object).target)) {
                return false;
            }
            if (!this.folder.equals(((UsingInstrumentation)object).folder)) {
                return false;
            }
            return this.randomString.equals(((UsingInstrumentation)object).randomString);
        }

        public int hashCode() {
            return (((17 * 31 + this.instrumentation.hashCode()) * 31 + this.target.hashCode()) * 31 + this.folder.hashCode()) * 31 + this.randomString.hashCode();
        }

        public static enum Target {
            BOOTSTRAP{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
                }
            }
            ,
            SYSTEM{

                @Override
                protected void inject(Instrumentation instrumentation, JarFile jarFile) {
                    instrumentation.appendToSystemClassLoaderSearch(jarFile);
                }
            };


            protected abstract void inject(Instrumentation var1, JarFile var2);
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingUnsafe
    implements ClassInjector {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private static final Object BOOTSTRAP_LOADER_LOCK = new Object();
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ClassLoader classLoader;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ProtectionDomain protectionDomain;

        public UsingUnsafe(ClassLoader classLoader) {
            this(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
        }

        public UsingUnsafe(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAvailable();
        }

        public static ClassInjector ofBootstrapLoader() {
            return new UsingUnsafe(ClassLoadingStrategy.BOOTSTRAP_LOADER);
        }

        public static ClassInjector ofClassPath() {
            return new UsingUnsafe(ClassLoader.getSystemClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            Dispatcher dispatcher = DISPATCHER.initialize();
            HashMap loaded = new HashMap();
            Object object = this.classLoader == null ? BOOTSTRAP_LOADER_LOCK : this.classLoader;
            synchronized (object) {
                for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                    try {
                        loaded.put(entry.getKey(), Class.forName(entry.getKey().getName(), false, this.classLoader));
                    }
                    catch (ClassNotFoundException ignored) {
                        loaded.put(entry.getKey(), dispatcher.defineClass(this.classLoader, entry.getKey().getName(), entry.getValue(), this.protectionDomain));
                    }
                }
            }
            return loaded;
        }

        public boolean equals(Object object) {
            block18: {
                block17: {
                    Object object2;
                    block16: {
                        Object object3;
                        Object object4;
                        block15: {
                            block14: {
                                ClassLoader classLoader;
                                block13: {
                                    if (this == object) {
                                        return true;
                                    }
                                    if (object == null) {
                                        return false;
                                    }
                                    if (this.getClass() != object.getClass()) {
                                        return false;
                                    }
                                    object4 = ((UsingUnsafe)object).classLoader;
                                    object3 = this.classLoader;
                                    classLoader = object3;
                                    if (object4 == null) break block13;
                                    if (classLoader == null) break block14;
                                    if (!object3.equals(object4)) {
                                        return false;
                                    }
                                    break block15;
                                }
                                if (classLoader == null) break block15;
                            }
                            return false;
                        }
                        object4 = ((UsingUnsafe)object).protectionDomain;
                        object2 = object3 = this.protectionDomain;
                        if (object4 == null) break block16;
                        if (object2 == null) break block17;
                        if (!object3.equals(object4)) {
                            return false;
                        }
                        break block18;
                    }
                    if (object2 == null) break block18;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n = 17 * 31;
            Object object = this.classLoader;
            if (object != null) {
                n = n + object.hashCode();
            }
            int n2 = n * 31;
            object = this.protectionDomain;
            if (object != null) {
                n2 = n2 + object.hashCode();
            }
            return n2;
        }

        protected static interface Dispatcher {
            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            @HashCodeAndEqualsPlugin.Enhance
            public static class Disabled
            implements Initializable {
                private final String message;

                protected Disabled(String message) {
                    this.message = message;
                }

                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Dispatcher initialize() {
                    throw new IllegalStateException("Could not find sun.misc.Unsafe");
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.message.equals(((Disabled)object).message);
                }

                public int hashCode() {
                    return 17 * 31 + this.message.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class Enabled
            implements Dispatcher,
            Initializable {
                private final Field theUnsafe;
                private final Method defineClass;

                protected Enabled(Field theUnsafe, Method defineClass) {
                    this.theUnsafe = theUnsafe;
                    this.defineClass = defineClass;
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                public Dispatcher initialize() {
                    this.theUnsafe.setAccessible(true);
                    return this;
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke(this.theUnsafe.get(null), name, binaryRepresentation, 0, binaryRepresentation.length, classLoader, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access Unsafe::defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking Unsafe::defineClass", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.theUnsafe.equals(((Enabled)object).theUnsafe)) {
                        return false;
                    }
                    return this.defineClass.equals(((Enabled)object).defineClass);
                }

                public int hashCode() {
                    return (17 * 31 + this.theUnsafe.hashCode()) * 31 + this.defineClass.hashCode();
                }
            }

            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                        return new Enabled(unsafe.getDeclaredField("theUnsafe"), unsafe.getMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class));
                    }
                    catch (Exception exception) {
                        return new Disabled(exception.getMessage());
                    }
                }
            }

            public static interface Initializable {
                public boolean isAvailable();

                public Dispatcher initialize();
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingLookup
    implements ClassInjector {
        private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.Creator.INSTANCE);
        private static final int PACKAGE_LOOKUP = 8;
        private final Object lookup;

        protected UsingLookup(Object lookup) {
            this.lookup = lookup;
        }

        public static UsingLookup of(Object lookup) {
            if (!DISPATCHER.isAlive()) {
                throw new IllegalStateException("The current VM does not support class definition via method handle lookups");
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isInstance(lookup)) {
                throw new IllegalArgumentException("Not a method handle lookup: " + lookup);
            }
            if ((DISPATCHER.lookupModes(lookup) & 8) == 0) {
                throw new IllegalArgumentException("Lookup does not imply package-access: " + lookup);
            }
            return new UsingLookup(DISPATCHER.dropLookupMode(lookup, 2));
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAlive();
        }

        public Class<?> lookupType() {
            return DISPATCHER.lookupType(this.lookup);
        }

        public UsingLookup in(Class<?> type) {
            return new UsingLookup(DISPATCHER.resolve(this.lookup, type));
        }

        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            HashMap loaded = new HashMap();
            for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                if (!entry.getKey().isSamePackage(TypeDescription.ForLoadedType.of(this.lookupType()))) {
                    throw new IllegalArgumentException(entry.getKey() + " must be defined in the same package as " + this.lookup);
                }
                loaded.put(entry.getKey(), DISPATCHER.defineClass(this.lookup, entry.getValue()));
            }
            return loaded;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.lookup.equals(((UsingLookup)object).lookup);
        }

        public int hashCode() {
            return 17 * 31 + this.lookup.hashCode();
        }

        protected static interface Dispatcher {
            public boolean isAlive();

            public Class<?> lookupType(Object var1);

            public int lookupModes(Object var1);

            public Object dropLookupMode(Object var1, int var2);

            public Object resolve(Object var1, Class<?> var2);

            public Class<?> defineClass(Object var1, byte[] var2);

            @HashCodeAndEqualsPlugin.Enhance
            public static class ForJava9CapableVm
            implements Dispatcher {
                private static final Object[] NO_ARGUMENTS = new Object[0];
                private final Method privateLookupIn;
                private final Method lookupClass;
                private final Method lookupModes;
                private final Method dropLookupMode;
                private final Method defineClass;

                protected ForJava9CapableVm(Method privateLookupIn, Method lookupClass, Method lookupModes, Method dropLookupMode, Method defineClass) {
                    this.privateLookupIn = privateLookupIn;
                    this.lookupClass = lookupClass;
                    this.lookupModes = lookupModes;
                    this.defineClass = defineClass;
                    this.dropLookupMode = dropLookupMode;
                }

                @Override
                public boolean isAlive() {
                    return true;
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    try {
                        return (Class)this.lookupClass.invoke(lookup, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupClass", exception.getCause());
                    }
                }

                @Override
                public int lookupModes(Object lookup) {
                    try {
                        return (Integer)this.lookupModes.invoke(lookup, NO_ARGUMENTS);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupModes", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupModes", exception.getCause());
                    }
                }

                @Override
                public Object dropLookupMode(Object lookup, int mode) {
                    try {
                        return this.dropLookupMode.invoke(lookup, mode);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#lookupModes", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#lookupModes", exception.getCause());
                    }
                }

                @Override
                public Object resolve(Object lookup, Class<?> type) {
                    try {
                        return this.privateLookupIn.invoke(null, type, lookup);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles#privateLookupIn", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles#privateLookupIn", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(Object lookup, byte[] binaryRepresentation) {
                    try {
                        return (Class)this.defineClass.invoke(lookup, new Object[]{binaryRepresentation});
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access java.lang.invoke.MethodHandles$Lookup#defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.invoke.MethodHandles$Lookup#defineClass", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.privateLookupIn.equals(((ForJava9CapableVm)object).privateLookupIn)) {
                        return false;
                    }
                    if (!this.lookupClass.equals(((ForJava9CapableVm)object).lookupClass)) {
                        return false;
                    }
                    if (!this.lookupModes.equals(((ForJava9CapableVm)object).lookupModes)) {
                        return false;
                    }
                    if (!this.dropLookupMode.equals(((ForJava9CapableVm)object).dropLookupMode)) {
                        return false;
                    }
                    return this.defineClass.equals(((ForJava9CapableVm)object).defineClass);
                }

                public int hashCode() {
                    return ((((17 * 31 + this.privateLookupIn.hashCode()) * 31 + this.lookupClass.hashCode()) * 31 + this.lookupModes.hashCode()) * 31 + this.dropLookupMode.hashCode()) * 31 + this.defineClass.hashCode();
                }
            }

            public static enum ForLegacyVm implements Dispatcher
            {
                INSTANCE;


                @Override
                public boolean isAlive() {
                    return false;
                }

                @Override
                public Class<?> lookupType(Object lookup) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public int lookupModes(Object lookup) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public Object dropLookupMode(Object lookup, int mode) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }

                @Override
                public Object resolve(Object lookup, Class<?> type) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles");
                }

                @Override
                public Class<?> defineClass(Object lookup, byte[] binaryRepresentation) {
                    throw new IllegalStateException("Cannot dispatch method for java.lang.invoke.MethodHandles$Lookup");
                }
            }

            public static enum Creator implements PrivilegedAction<Dispatcher>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Dispatcher run() {
                    try {
                        Class<?> lookup = JavaType.METHOD_HANDLES_LOOKUP.load();
                        return new ForJava9CapableVm(JavaType.METHOD_HANDLES.load().getMethod("privateLookupIn", Class.class, lookup), lookup.getMethod("lookupClass", new Class[0]), lookup.getMethod("lookupModes", new Class[0]), lookup.getMethod("dropLookupMode", Integer.TYPE), lookup.getMethod("defineClass", byte[].class));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class UsingReflection
    implements ClassInjector {
        private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
        private final ClassLoader classLoader;
        @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
        private final ProtectionDomain protectionDomain;
        private final PackageDefinitionStrategy packageDefinitionStrategy;
        private final boolean forbidExisting;

        public UsingReflection(ClassLoader classLoader) {
            this(classLoader, ClassLoadingStrategy.NO_PROTECTION_DOMAIN);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain) {
            this(classLoader, protectionDomain, PackageDefinitionStrategy.Trivial.INSTANCE, false);
        }

        public UsingReflection(ClassLoader classLoader, ProtectionDomain protectionDomain, PackageDefinitionStrategy packageDefinitionStrategy, boolean forbidExisting) {
            if (classLoader == null) {
                throw new IllegalArgumentException("Cannot inject classes into the bootstrap class loader");
            }
            this.classLoader = classLoader;
            this.protectionDomain = protectionDomain;
            this.packageDefinitionStrategy = packageDefinitionStrategy;
            this.forbidExisting = forbidExisting;
        }

        public static boolean isAvailable() {
            return DISPATCHER.isAvailable();
        }

        public static ClassInjector ofSystemClassLoader() {
            return new UsingReflection(ClassLoader.getSystemClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> inject(Map<? extends TypeDescription, byte[]> types) {
            Dispatcher dispatcher = DISPATCHER.initialize();
            HashMap loadedTypes = new HashMap();
            for (Map.Entry<? extends TypeDescription, byte[]> entry : types.entrySet()) {
                String typeName = entry.getKey().getName();
                Object object = dispatcher.getClassLoadingLock(this.classLoader, typeName);
                synchronized (object) {
                    Class<?> type = dispatcher.findClass(this.classLoader, typeName);
                    if (type == null) {
                        String packageName;
                        PackageDefinitionStrategy.Definition definition;
                        int packageIndex = typeName.lastIndexOf(46);
                        if (packageIndex != -1 && (definition = this.packageDefinitionStrategy.define(this.classLoader, packageName = typeName.substring(0, packageIndex), typeName)).isDefined()) {
                            Package definedPackage = dispatcher.getPackage(this.classLoader, packageName);
                            if (definedPackage == null) {
                                dispatcher.definePackage(this.classLoader, packageName, definition.getSpecificationTitle(), definition.getSpecificationVersion(), definition.getSpecificationVendor(), definition.getImplementationTitle(), definition.getImplementationVersion(), definition.getImplementationVendor(), definition.getSealBase());
                            } else if (!definition.isCompatibleTo(definedPackage)) {
                                throw new SecurityException("Sealing violation for package " + packageName);
                            }
                        }
                        type = dispatcher.defineClass(this.classLoader, typeName, entry.getValue(), this.protectionDomain);
                    } else if (this.forbidExisting) {
                        throw new IllegalStateException("Cannot inject already loaded type: " + type);
                    }
                    loadedTypes.put(entry.getKey(), type);
                }
            }
            return loadedTypes;
        }

        public boolean equals(Object object) {
            block12: {
                block11: {
                    ProtectionDomain protectionDomain;
                    block10: {
                        ProtectionDomain protectionDomain2;
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        if (!this.classLoader.equals(((UsingReflection)object).classLoader)) {
                            return false;
                        }
                        ProtectionDomain protectionDomain3 = ((UsingReflection)object).protectionDomain;
                        protectionDomain = protectionDomain2 = this.protectionDomain;
                        if (protectionDomain3 == null) break block10;
                        if (protectionDomain == null) break block11;
                        if (!protectionDomain2.equals(protectionDomain3)) {
                            return false;
                        }
                        break block12;
                    }
                    if (protectionDomain == null) break block12;
                }
                return false;
            }
            if (!this.packageDefinitionStrategy.equals(((UsingReflection)object).packageDefinitionStrategy)) {
                return false;
            }
            return this.forbidExisting == ((UsingReflection)object).forbidExisting;
        }

        public int hashCode() {
            int n = (17 * 31 + this.classLoader.hashCode()) * 31;
            ProtectionDomain protectionDomain = this.protectionDomain;
            if (protectionDomain != null) {
                n = n + protectionDomain.hashCode();
            }
            return (n * 31 + this.packageDefinitionStrategy.hashCode()) * 31 + this.forbidExisting;
        }

        protected static interface Dispatcher {
            public static final Class<?> UNDEFINED = null;

            public Object getClassLoadingLock(ClassLoader var1, String var2);

            public Class<?> findClass(ClassLoader var1, String var2);

            public Class<?> defineClass(ClassLoader var1, String var2, byte[] var3, ProtectionDomain var4);

            public Package getPackage(ClassLoader var1, String var2);

            public Package definePackage(ClassLoader var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, URL var9);

            @HashCodeAndEqualsPlugin.Enhance
            public static class Unavailable
            implements Dispatcher {
                private final Exception exception;

                protected Unavailable(Exception exception) {
                    this.exception = exception;
                }

                @Override
                public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                    return classLoader;
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return classLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException ignored) {
                        return UNDEFINED;
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    throw new UnsupportedOperationException("Cannot define class using reflection", this.exception);
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    throw new UnsupportedOperationException("Cannot get package using reflection", this.exception);
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    throw new UnsupportedOperationException("Cannot define package using injection", this.exception);
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    return this.exception.equals(((Unavailable)object).exception);
                }

                public int hashCode() {
                    return 17 * 31 + this.exception.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static class Indirect
            implements Dispatcher,
            Initializable {
                private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
                private final Object accessor;
                private final Method findLoadedClass;
                private final Method defineClass;
                private final Method getPackage;
                private final Method definePackage;
                private final Method getClassLoadingLock;

                protected Indirect(Object accessor, Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                    this.accessor = accessor;
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                    this.getClassLoadingLock = getClassLoadingLock;
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit caller responsibility")
                public static Initializable make() throws Exception {
                    Method getPackage;
                    Class<?> unsafe = Class.forName("sun.misc.Unsafe");
                    Field theUnsafe = unsafe.getDeclaredField("theUnsafe");
                    theUnsafe.setAccessible(true);
                    Object unsafeInstance = theUnsafe.get(null);
                    try {
                        getPackage = ClassLoader.class.getDeclaredMethod("getDeclaredPackage", String.class);
                    }
                    catch (NoSuchMethodException ignored) {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    }
                    DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition builder = new ByteBuddy().subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(ClassLoader.class.getName() + "$ByteBuddyAccessor$" + RandomString.make()).defineMethod("findLoadedClass", (Type)((Object)Class.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class)).onArgument(0).withArgument(1)).defineMethod("defineClass", (Type)((Object)Class.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class)).onArgument(0).withArgument(1, 2, 3, 4, 5)).defineMethod("getPackage", (Type)((Object)Package.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(getPackage).onArgument(0).withArgument(1)).defineMethod("definePackage", (Type)((Object)Package.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class)).onArgument(0).withArgument(1, 2, 3, 4, 5, 6, 7, 8));
                    try {
                        builder = builder.defineMethod("getClassLoadingLock", (Type)((Object)Object.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(MethodCall.invoke(ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class)).onArgument(0).withArgument(1));
                    }
                    catch (NoSuchMethodException ignored) {
                        builder = builder.defineMethod("getClassLoadingLock", (Type)((Object)Object.class), Visibility.PUBLIC).withParameters(new Type[]{ClassLoader.class, String.class}).intercept(FixedValue.argument(0));
                    }
                    Class type = builder.make().load(ClassLoadingStrategy.BOOTSTRAP_LOADER, new ClassLoadingStrategy.ForUnsafeInjection()).getLoaded();
                    return new Indirect(unsafe.getDeclaredMethod("allocateInstance", Class.class).invoke(unsafeInstance, type), type.getMethod("findLoadedClass", ClassLoader.class, String.class), type.getMethod("defineClass", ClassLoader.class, String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class), type.getMethod("getPackage", ClassLoader.class, String.class), type.getMethod("definePackage", ClassLoader.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class), type.getMethod("getClassLoadingLock", ClassLoader.class, String.class));
                }

                @Override
                public Dispatcher initialize() {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkPermission(ACCESS_PERMISSION);
                    }
                    return this;
                }

                @Override
                public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                    try {
                        return this.getClassLoadingLock.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::getClassLoadingLock", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::getClassLoadingLock", exception.getCause());
                    }
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::findLoadedClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::findLoadedClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke(this.accessor, classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::defineClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke(this.accessor, classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::getPackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::getPackage", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke(this.accessor, classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access (accessor)::definePackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking (accessor)::definePackage", exception.getCause());
                    }
                }

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.accessor.equals(((Indirect)object).accessor)) {
                        return false;
                    }
                    if (!this.findLoadedClass.equals(((Indirect)object).findLoadedClass)) {
                        return false;
                    }
                    if (!this.defineClass.equals(((Indirect)object).defineClass)) {
                        return false;
                    }
                    if (!this.getPackage.equals(((Indirect)object).getPackage)) {
                        return false;
                    }
                    if (!this.definePackage.equals(((Indirect)object).definePackage)) {
                        return false;
                    }
                    return this.getClassLoadingLock.equals(((Indirect)object).getClassLoadingLock);
                }

                public int hashCode() {
                    return (((((17 * 31 + this.accessor.hashCode()) * 31 + this.findLoadedClass.hashCode()) * 31 + this.defineClass.hashCode()) * 31 + this.getPackage.hashCode()) * 31 + this.definePackage.hashCode()) * 31 + this.getClassLoadingLock.hashCode();
                }
            }

            @HashCodeAndEqualsPlugin.Enhance
            public static abstract class Direct
            implements Dispatcher,
            Initializable {
                protected final Method findLoadedClass;
                protected final Method defineClass;
                protected final Method getPackage;
                protected final Method definePackage;

                protected Direct(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                    this.findLoadedClass = findLoadedClass;
                    this.defineClass = defineClass;
                    this.getPackage = getPackage;
                    this.definePackage = definePackage;
                }

                protected static Initializable make() throws Exception {
                    Method getPackage;
                    try {
                        getPackage = ClassLoader.class.getMethod("getDefinedPackage", String.class);
                    }
                    catch (NoSuchMethodException ignored) {
                        getPackage = ClassLoader.class.getDeclaredMethod("getPackage", String.class);
                    }
                    Method findLoadedClass = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
                    Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                    Method definePackage = ClassLoader.class.getDeclaredMethod("definePackage", String.class, String.class, String.class, String.class, String.class, String.class, String.class, URL.class);
                    try {
                        return new ForJava7CapableVm(findLoadedClass, defineClass, getPackage, definePackage, ClassLoader.class.getDeclaredMethod("getClassLoadingLock", String.class));
                    }
                    catch (NoSuchMethodException ignored) {
                        return new ForLegacyVm(findLoadedClass, defineClass, getPackage, definePackage);
                    }
                }

                @Override
                public Class<?> findClass(ClassLoader classLoader, String name) {
                    try {
                        return (Class)this.findLoadedClass.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#findClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#findClass", exception.getCause());
                    }
                }

                @Override
                public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                    try {
                        return (Class)this.defineClass.invoke((Object)classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, protectionDomain);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#defineClass", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#defineClass", exception.getCause());
                    }
                }

                @Override
                public Package getPackage(ClassLoader classLoader, String name) {
                    try {
                        return (Package)this.getPackage.invoke((Object)classLoader, name);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#getPackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#getPackage", exception.getCause());
                    }
                }

                @Override
                public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                    try {
                        return (Package)this.definePackage.invoke((Object)classLoader, name, specificationTitle, specificationVersion, specificationVendor, implementationTitle, implementationVersion, implementationVendor, sealBase);
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Could not access java.lang.ClassLoader#definePackage", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error invoking java.lang.ClassLoader#definePackage", exception.getCause());
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED", "REC_CATCH_EXCEPTION"}, justification="Privilege is explicit user responsibility")
                public Dispatcher initialize() {
                    try {
                        this.findLoadedClass.setAccessible(true);
                        this.defineClass.setAccessible(true);
                        this.getPackage.setAccessible(true);
                        this.definePackage.setAccessible(true);
                        this.onInitialization();
                        return this;
                    }
                    catch (Exception exception) {
                        return new Unavailable(exception);
                    }
                }

                protected abstract void onInitialization();

                public boolean equals(Object object) {
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    if (!this.findLoadedClass.equals(((Direct)object).findLoadedClass)) {
                        return false;
                    }
                    if (!this.defineClass.equals(((Direct)object).defineClass)) {
                        return false;
                    }
                    if (!this.getPackage.equals(((Direct)object).getPackage)) {
                        return false;
                    }
                    return this.definePackage.equals(((Direct)object).definePackage);
                }

                public int hashCode() {
                    return (((17 * 31 + this.findLoadedClass.hashCode()) * 31 + this.defineClass.hashCode()) * 31 + this.getPackage.hashCode()) * 31 + this.definePackage.hashCode();
                }

                protected static class ForLegacyVm
                extends Direct {
                    protected ForLegacyVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                    }

                    @Override
                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        return classLoader;
                    }

                    @Override
                    protected void onInitialization() {
                    }
                }

                @HashCodeAndEqualsPlugin.Enhance
                protected static class ForJava7CapableVm
                extends Direct {
                    private final Method getClassLoadingLock;

                    protected ForJava7CapableVm(Method findLoadedClass, Method defineClass, Method getPackage, Method definePackage, Method getClassLoadingLock) {
                        super(findLoadedClass, defineClass, getPackage, definePackage);
                        this.getClassLoadingLock = getClassLoadingLock;
                    }

                    @Override
                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        try {
                            return this.getClassLoadingLock.invoke((Object)classLoader, name);
                        }
                        catch (IllegalAccessException exception) {
                            throw new IllegalStateException("Could not access java.lang.ClassLoader#getClassLoadingLock", exception);
                        }
                        catch (InvocationTargetException exception) {
                            throw new IllegalStateException("Error invoking java.lang.ClassLoader#getClassLoadingLock", exception.getCause());
                        }
                    }

                    @Override
                    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
                    protected void onInitialization() {
                        this.getClassLoadingLock.setAccessible(true);
                    }

                    @Override
                    public boolean equals(Object object) {
                        if (!super.equals(object)) {
                            return false;
                        }
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.getClassLoadingLock.equals(((ForJava7CapableVm)object).getClassLoadingLock);
                    }

                    @Override
                    public int hashCode() {
                        return super.hashCode() * 31 + this.getClassLoadingLock.hashCode();
                    }
                }
            }

            public static enum CreationAction implements PrivilegedAction<Initializable>
            {
                INSTANCE;


                @Override
                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public Initializable run() {
                    try {
                        return JavaModule.isSupported() ? Indirect.make() : Direct.make();
                    }
                    catch (InvocationTargetException exception) {
                        return new Initializable.Unavailable(exception.getCause().getMessage());
                    }
                    catch (Exception exception) {
                        return new Initializable.Unavailable(exception.getMessage());
                    }
                }
            }

            public static interface Initializable {
                public boolean isAvailable();

                public Dispatcher initialize();

                @HashCodeAndEqualsPlugin.Enhance
                public static class Unavailable
                implements Dispatcher,
                Initializable {
                    private final String message;

                    protected Unavailable(String message) {
                        this.message = message;
                    }

                    @Override
                    public boolean isAvailable() {
                        return false;
                    }

                    @Override
                    public Dispatcher initialize() {
                        return this;
                    }

                    @Override
                    public Object getClassLoadingLock(ClassLoader classLoader, String name) {
                        return classLoader;
                    }

                    @Override
                    public Class<?> findClass(ClassLoader classLoader, String name) {
                        try {
                            return classLoader.loadClass(name);
                        }
                        catch (ClassNotFoundException ignored) {
                            return UNDEFINED;
                        }
                    }

                    @Override
                    public Class<?> defineClass(ClassLoader classLoader, String name, byte[] binaryRepresentation, ProtectionDomain protectionDomain) {
                        throw new UnsupportedOperationException("Cannot define class using reflection: " + this.message);
                    }

                    @Override
                    public Package getPackage(ClassLoader classLoader, String name) {
                        throw new UnsupportedOperationException("Cannot get package using reflection: " + this.message);
                    }

                    @Override
                    public Package definePackage(ClassLoader classLoader, String name, String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, URL sealBase) {
                        throw new UnsupportedOperationException("Cannot define package using injection: " + this.message);
                    }

                    public boolean equals(Object object) {
                        if (this == object) {
                            return true;
                        }
                        if (object == null) {
                            return false;
                        }
                        if (this.getClass() != object.getClass()) {
                            return false;
                        }
                        return this.message.equals(((Unavailable)object).message);
                    }

                    public int hashCode() {
                        return 17 * 31 + this.message.hashCode();
                    }
                }
            }
        }
    }
}

