/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.neoitertools.generators;

import java.security.InvalidParameterException;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeGenerator
implements Generator<Integer> {
    private final int step;
    private final int end;
    int i;

    public RangeGenerator(int start, int end) {
        this(start, end, 1);
    }

    public RangeGenerator(int end) {
        this(0, end, 1);
    }

    public RangeGenerator(int start, int end, int step) {
        if (step == 0) {
            throw new InvalidParameterException("step must be != 0");
        }
        this.step = step;
        this.end = end;
        this.i = start;
    }

    @Override
    public Integer next() {
        if (this.step > 0 ? this.i >= this.end : this.i <= this.end) {
            throw new NoSuchElementException();
        }
        int j = this.i;
        this.i += this.step;
        return j;
    }
}

