/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.BuiltInRuleSet;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.NamespaceIterator;

public class ShallowCopyRuleSet
implements BuiltInRuleSet {
    private static ShallowCopyRuleSet THE_INSTANCE = new ShallowCopyRuleSet();

    public static ShallowCopyRuleSet getInstance() {
        return THE_INSTANCE;
    }

    private ShallowCopyRuleSet() {
    }

    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, XPathContext context, Location locationId) throws XPathException {
        if (item instanceof NodeInfo) {
            NodeInfo node = (NodeInfo)item;
            switch (node.getNodeKind()) {
                case 9: {
                    SequenceReceiver out = context.getReceiver();
                    out.startDocument(0);
                    FocusTrackingIterator iter = new FocusTrackingIterator(node.iterateAxis((byte)3));
                    XPathContextMajor c2 = context.newContext();
                    c2.setOrigin(this);
                    c2.setCurrentIterator(iter);
                    for (TailCall tc = context.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                    }
                    out.endDocument();
                    return;
                }
                case 1: {
                    TailCall tc;
                    FocusTrackingIterator iter;
                    SequenceReceiver out = context.getReceiver();
                    NodeName fqn = NameOfNode.makeName(node);
                    out.startElement(fqn, node.getSchemaType(), locationId, 0);
                    NamespaceIterator.sendNamespaces(node, out);
                    XPathContextMajor c2 = context.newContext();
                    AxisIterator attributes = node.iterateAxis((byte)2);
                    if (attributes != EmptyIterator.OfNodes.THE_INSTANCE) {
                        iter = new FocusTrackingIterator(attributes);
                        c2.setOrigin(this);
                        c2.setCurrentIterator(iter);
                        for (tc = c2.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                        }
                    }
                    if (node.hasChildNodes()) {
                        iter = new FocusTrackingIterator(node.iterateAxis((byte)3));
                        c2.setCurrentIterator(iter);
                        for (tc = c2.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
                        }
                    }
                    out.endElement();
                    return;
                }
                case 3: {
                    context.getReceiver().characters(item.getStringValueCS(), locationId, 0);
                    return;
                }
                case 2: 
                case 7: 
                case 8: 
                case 13: {
                    node.copy(context.getReceiver(), 0, locationId);
                    return;
                }
            }
        } else {
            context.getReceiver().append(item, locationId, 0);
        }
    }

    public int[] getActionForParentNodes(int nodeKind) {
        return new int[]{5, 6, 7};
    }
}

