/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.rule.basic;

import java.util.HashSet;
import java.util.List;
import net.sourceforge.pmd.lang.vm.ast.ASTDirective;
import net.sourceforge.pmd.lang.vm.ast.ASTReference;
import net.sourceforge.pmd.lang.vm.ast.ASTSetDirective;
import net.sourceforge.pmd.lang.vm.rule.AbstractVmRule;

public class AvoidReassigningParametersRule
extends AbstractVmRule {
    @Override
    public Object visit(ASTDirective node, Object data) {
        if ("macro".equals(node.getDirectiveName())) {
            HashSet<String> paramNames = new HashSet<String>();
            List params = node.findChildrenOfType(ASTReference.class);
            for (ASTReference param : params) {
                paramNames.add(param.getFirstToken().toString());
            }
            List assignments = node.findDescendantsOfType(ASTSetDirective.class);
            for (ASTSetDirective assignment : assignments) {
                ASTReference ref = (ASTReference)assignment.getFirstChildOfType(ASTReference.class);
                if (ref == null || !paramNames.contains(ref.getFirstToken().toString())) continue;
                this.addViolation(data, node, ref.getFirstToken().toString());
            }
        }
        return super.visit(node, data);
    }
}

