/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class HttpFirstLineDissector
extends Dissector {
    public static final String FIRSTLINE_REGEX = ".*";
    private final Pattern firstlineSplitter = Pattern.compile("^([a-zA-Z-_]+) (.*) (HTTP/[0-9]+\\.[0-9]+)$");
    private final Pattern tooLongFirstlineSplitter = Pattern.compile("^([a-zA-Z-_]+) (.*)$");
    private static final String HTTP_FIRSTLINE = "HTTP.FIRSTLINE";
    private final Set<String> requestedParameters = new HashSet<String>(16);

    public String getInputType() {
        return HTTP_FIRSTLINE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.METHOD:method");
        result.add("HTTP.URI:uri");
        result.add("HTTP.PROTOCOL_VERSION:protocol");
        return result;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(HTTP_FIRSTLINE, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty() || "-".equals(fieldValue)) {
            return;
        }
        Matcher matcher = this.firstlineSplitter.matcher(fieldValue);
        boolean matches = matcher.find();
        if (matches && matcher.groupCount() == 3) {
            this.outputDissection(parsable, inputname, "HTTP.METHOD", "method", matcher, 1);
            this.outputDissection(parsable, inputname, "HTTP.URI", "uri", matcher, 2);
            this.outputDissection(parsable, inputname, "HTTP.PROTOCOL_VERSION", "protocol", matcher, 3);
            return;
        }
        matcher = this.tooLongFirstlineSplitter.matcher(fieldValue);
        matches = matcher.find();
        if (matches && matcher.groupCount() == 2) {
            this.outputDissection(parsable, inputname, "HTTP.METHOD", "method", matcher, 1);
            this.outputDissection(parsable, inputname, "HTTP.URI", "uri", matcher, 2);
            parsable.addDissection(inputname, "HTTP.PROTOCOL_VERSION", "protocol", (String)null);
        }
    }

    private void outputDissection(Parsable<?> parsable, String inputname, String type, String name, Matcher matcher, int offset) throws DissectionFailure {
        if (this.requestedParameters.contains(name)) {
            parsable.addDissection(inputname, type, name, matcher.group(offset));
        }
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        this.requestedParameters.add(this.extractFieldName(inputname, outputname));
        return Casts.STRING_ONLY;
    }
}

