/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;

public class HttpFirstLineProtocolDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.PROTOCOL_VERSION";
    private final Set<String> requestedParameters = new HashSet<String>(16);

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("HTTP.PROTOCOL:");
        result.add("HTTP.PROTOCOL.VERSION:version");
        return result;
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty() || "-".equals(fieldValue)) {
            return;
        }
        String[] protocol = fieldValue.split("/", 2);
        if (protocol.length == 2) {
            this.outputDissection(parsable, inputname, "HTTP.PROTOCOL", "", protocol[0]);
            this.outputDissection(parsable, inputname, "HTTP.PROTOCOL.VERSION", "version", protocol[1]);
            return;
        }
        parsable.addDissection(inputname, "HTTP.PROTOCOL", "", (String)null);
        parsable.addDissection(inputname, "HTTP.PROTOCOL.VERSION", "version", (String)null);
    }

    private void outputDissection(Parsable<?> parsable, String inputname, String type, String name, String value) throws DissectionFailure {
        if (this.requestedParameters.contains(name)) {
            parsable.addDissection(inputname, type, name, value);
        }
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        this.requestedParameters.add(this.extractFieldName(inputname, outputname));
        return Casts.STRING_ONLY;
    }
}

