/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.custom;

import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Upload;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.ui.custom.ImportComponent;
import org.activiti.explorer.ui.custom.PopupWindow;

public class ImportPopupWindow
extends PopupWindow {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager = ExplorerApp.get().getI18nManager();
    protected ImportComponent importComponent;

    public ImportPopupWindow(String caption, String description, Upload.Receiver receiver) {
        this.init(caption, description, receiver);
        this.importComponent.addFinishedListener(new Upload.FinishedListener(){
            private static final long serialVersionUID = 1L;

            public void uploadFinished(Upload.FinishedEvent event) {
                ImportPopupWindow.this.close();
            }
        });
    }

    protected void init(String caption, String description, Upload.Receiver receiver) {
        this.importComponent = new ImportComponent(description, receiver);
        this.importComponent.setSizeFull();
        this.initWindow(caption);
    }

    protected void initWindow(String caption) {
        this.setWidth("300px");
        this.setHeight("200px");
        this.addStyleName("light");
        this.setModal(true);
        this.center();
        this.setCaption(caption);
        this.setContent((ComponentContainer)this.importComponent);
    }

    public void addFinishedListener(Upload.FinishedListener finishedListener) {
        this.importComponent.addFinishedListener(finishedListener);
    }

    public void addStartedListener(Upload.StartedListener startedListener) {
        this.importComponent.addStartedListener(startedListener);
    }

    public void addFailedListener(Upload.FailedListener failedListener) {
        this.importComponent.addFailedListener(failedListener);
    }

    public void addProgressListener(Upload.ProgressListener progressListener) {
        this.importComponent.addProgressListener(progressListener);
    }
}

