/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lib.CompositeProcessor;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ForwardWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagate;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ConvertJoinMapJoin;
import org.apache.hadoop.hive.ql.optimizer.DynamicPartitionPruningOptimization;
import org.apache.hadoop.hive.ql.optimizer.MergeJoinProc;
import org.apache.hadoop.hive.ql.optimizer.ReduceSinkMapJoinProc;
import org.apache.hadoop.hive.ql.optimizer.RemoveDynamicPruningBySize;
import org.apache.hadoop.hive.ql.optimizer.SetReducerParallelism;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateWithOpTraits;
import org.apache.hadoop.hive.ql.optimizer.physical.CrossProductCheck;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.StageIDsRearranger;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateWithStatistics;
import org.apache.hadoop.hive.ql.parse.AppMasterEventProcessor;
import org.apache.hadoop.hive.ql.parse.FileSinkProcessor;
import org.apache.hadoop.hive.ql.parse.GenTezProcContext;
import org.apache.hadoop.hive.ql.parse.GenTezUtils;
import org.apache.hadoop.hive.ql.parse.GenTezWork;
import org.apache.hadoop.hive.ql.parse.GenTezWorkWalker;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ProcessAnalyzeTable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.parse.UnionProcessor;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.session.SessionState;

public class TezCompiler
extends TaskCompiler {
    protected final Log LOG = LogFactory.getLog(TezCompiler.class);

    @Override
    public void init(HiveConf conf, SessionState.LogHelper console, Hive db) {
        super.init(conf, console, db);
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_RPC_QUERY_PLAN, true);
        conf.setBoolean("mapred.input.dir.recursive", true);
        HiveConf.setBoolVar(conf, HiveConf.ConfVars.HIVE_HADOOP_SUPPORTS_SUBDIRECTORIES, true);
    }

    @Override
    protected void optimizeOperatorPlan(ParseContext pCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        OptimizeTezProcContext procCtx = new OptimizeTezProcContext(this.conf, pCtx, inputs, outputs);
        this.runDynamicPartitionPruning(procCtx, inputs, outputs);
        this.runStatsAnnotation(procCtx);
        this.runStatsDependentOptimizations(procCtx, inputs, outputs);
        this.runCycleAnalysisForPartitionPruning(procCtx, inputs, outputs);
    }

    private void runCycleAnalysisForPartitionPruning(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        if (!procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING)) {
            return;
        }
        boolean cycleFree = false;
        while (!cycleFree) {
            cycleFree = true;
            Set<Set<Operator<?>>> components = this.getComponents(procCtx);
            for (Set<Operator<?>> component : components) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)"Component: ");
                    for (Operator<?> co : component) {
                        this.LOG.debug((Object)("Operator: " + co.getName() + ", " + co.getIdentifier()));
                    }
                }
                if (component.size() == 1) continue;
                this.LOG.info((Object)"Found cycle in operator plan...");
                cycleFree = false;
                this.removeEventOperator(component, procCtx);
                break;
            }
            this.LOG.info((Object)("Cycle free: " + cycleFree));
        }
    }

    private void removeEventOperator(Set<Operator<?>> component, OptimizeTezProcContext context) {
        AppMasterEventOperator victim = null;
        for (Operator<?> o : component) {
            if (!(o instanceof AppMasterEventOperator) || victim != null && o.getConf().getStatistics().getDataSize() >= ((AppMasterEventDesc)victim.getConf()).getStatistics().getDataSize()) continue;
            victim = (AppMasterEventOperator)o;
        }
        if (victim == null || !context.pruningOpsRemovedByPriorOpt.isEmpty() && context.pruningOpsRemovedByPriorOpt.contains(victim)) {
            return;
        }
        GenTezUtils.getUtils().removeBranch(victim);
        this.LOG.info((Object)("Disabling dynamic pruning for: " + ((DynamicPruningEventDesc)victim.getConf()).getTableScan().toString() + ". Needed to break cyclic dependency"));
    }

    private Set<Set<Operator<?>>> getComponents(OptimizeTezProcContext procCtx) {
        LinkedList<Operator<? extends OperatorDesc>> deque = new LinkedList<Operator<? extends OperatorDesc>>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        AtomicInteger index = new AtomicInteger();
        HashMap indexes = new HashMap();
        HashMap lowLinks = new HashMap();
        Stack nodes = new Stack();
        HashSet components = new HashSet();
        for (Operator operator : deque) {
            if (indexes.containsKey(operator)) continue;
            this.connect(operator, index, nodes, indexes, lowLinks, components);
        }
        return components;
    }

    private void connect(Operator<?> o, AtomicInteger index, Stack<Operator<?>> nodes, Map<Operator<?>, Integer> indexes, Map<Operator<?>, Integer> lowLinks, Set<Set<Operator<?>>> components) {
        List<Operator<OperatorDesc>> children;
        indexes.put(o, index.get());
        lowLinks.put(o, index.get());
        index.incrementAndGet();
        nodes.push(o);
        if (o instanceof AppMasterEventOperator) {
            children = new ArrayList<Operator<OperatorDesc>>();
            children.addAll(o.getChildOperators());
            TableScanOperator ts = ((DynamicPruningEventDesc)o.getConf()).getTableScan();
            this.LOG.debug((Object)("Adding special edge: " + o.getName() + " --> " + ts.toString()));
            children.add(ts);
        } else {
            children = o.getChildOperators();
        }
        for (Operator<OperatorDesc> child : children) {
            if (!indexes.containsKey(child)) {
                this.connect(child, index, nodes, indexes, lowLinks, components);
                lowLinks.put(o, Math.min(lowLinks.get(o), lowLinks.get(child)));
                continue;
            }
            if (!nodes.contains(child)) continue;
            lowLinks.put(o, Math.min(lowLinks.get(o), indexes.get(child)));
        }
        if (lowLinks.get(o).equals(indexes.get(o))) {
            Operator<?> current;
            HashSet component = new HashSet();
            components.add(component);
            do {
                current = nodes.pop();
                component.add(current);
            } while (current != o);
        }
    }

    private void runStatsAnnotation(OptimizeTezProcContext procCtx) throws SemanticException {
        new AnnotateWithStatistics().transform(procCtx.parseContext);
        new AnnotateWithOpTraits().transform(procCtx.parseContext);
    }

    private void runStatsDependentOptimizations(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        LinkedList<Operator<? extends OperatorDesc>> deque = new LinkedList<Operator<? extends OperatorDesc>>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Set parallelism - ReduceSink", ReduceSinkOperator.getOperatorName() + "%"), new SetReducerParallelism());
        opRules.put(new RuleRegExp("Convert Join to Map-join", JoinOperator.getOperatorName() + "%"), new ConvertJoinMapJoin());
        opRules.put(new RuleRegExp("Remove dynamic pruning by size", AppMasterEventOperator.getOperatorName() + "%"), new RemoveDynamicPruningBySize());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        ForwardWalker ogw = new ForwardWalker(disp);
        ogw.startWalking(topNodes, null);
    }

    private void runDynamicPartitionPruning(OptimizeTezProcContext procCtx, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        if (!procCtx.conf.getBoolVar(HiveConf.ConfVars.TEZ_DYNAMIC_PARTITION_PRUNING)) {
            return;
        }
        LinkedList<Operator<? extends OperatorDesc>> deque = new LinkedList<Operator<? extends OperatorDesc>>();
        deque.addAll(procCtx.parseContext.getTopOps().values());
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp(new String("Dynamic Partition Pruning"), FilterOperator.getOperatorName() + "%"), new DynamicPartitionPruningOptimization());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(procCtx.parseContext.getTopOps().values());
        ForwardWalker ogw = new ForwardWalker(disp);
        ogw.startWalking(topNodes, null);
        if (procCtx.conf.getBoolVar(HiveConf.ConfVars.HIVEOPTCONSTANTPROPAGATION)) {
            new ConstantPropagate(ConstantPropagateProcCtx.ConstantPropagateOption.SHORTCUT).transform(procCtx.parseContext);
        }
    }

    @Override
    protected void generateTaskTree(List<Task<? extends Serializable>> rootTasks, ParseContext pCtx, List<Task<MoveWork>> mvTask, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        GenTezUtils.getUtils().resetSequenceNumber();
        ParseContext tempParseContext = this.getParseContext(pCtx, rootTasks);
        GenTezWork genTezWork = new GenTezWork(GenTezUtils.getUtils());
        GenTezProcContext procCtx = new GenTezProcContext(this.conf, tempParseContext, mvTask, rootTasks, inputs, outputs);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("Split Work - ReduceSink", ReduceSinkOperator.getOperatorName() + "%"), genTezWork);
        opRules.put(new RuleRegExp("No more walking on ReduceSink-MapJoin", MapJoinOperator.getOperatorName() + "%"), new ReduceSinkMapJoinProc());
        opRules.put(new RuleRegExp("Recoginze a Sorted Merge Join operator to setup the right edge and stop traversing the DummyStore-MapJoin", CommonMergeJoinOperator.getOperatorName() + "%"), new MergeJoinProc());
        opRules.put(new RuleRegExp("Split Work + Move/Merge - FileSink", FileSinkOperator.getOperatorName() + "%"), new CompositeProcessor(new FileSinkProcessor(), genTezWork));
        opRules.put(new RuleRegExp("Split work - DummyStore", DummyStoreOperator.getOperatorName() + "%"), genTezWork);
        opRules.put(new RuleRegExp("Handle Potential Analyze Command", TableScanOperator.getOperatorName() + "%"), new ProcessAnalyzeTable(GenTezUtils.getUtils()));
        opRules.put(new RuleRegExp("Remember union", UnionOperator.getOperatorName() + "%"), new UnionProcessor());
        opRules.put(new RuleRegExp("AppMasterEventOperator", AppMasterEventOperator.getOperatorName() + "%"), new AppMasterEventProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, procCtx);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        GenTezWorkWalker ogw = new GenTezWorkWalker(disp, procCtx);
        ogw.startWalking(topNodes, null);
        for (BaseWork w : procCtx.workWithUnionOperators) {
            GenTezUtils.getUtils().removeUnionOperators(this.conf, procCtx, w);
        }
        for (FileSinkOperator fileSink : procCtx.fileSinkSet) {
            GenTezUtils.getUtils().processFileSink(procCtx, fileSink);
        }
        this.LOG.debug((Object)("There are " + procCtx.eventOperatorSet.size() + " app master events."));
        for (AppMasterEventOperator event : procCtx.eventOperatorSet) {
            this.LOG.debug((Object)("Handling AppMasterEventOperator: " + event));
            GenTezUtils.getUtils().processAppMasterEvent(procCtx, event);
        }
    }

    @Override
    protected void setInputFormat(Task<? extends Serializable> task) {
        if (task instanceof TezTask) {
            TezWork work = (TezWork)((TezTask)task).getWork();
            List<BaseWork> all = work.getAllWork();
            Iterator<BaseWork> iterator = all.iterator();
            while (iterator.hasNext()) {
                MapWork mapWork;
                LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap;
                BaseWork w = iterator.next();
                if (!(w instanceof MapWork) || (opMap = (mapWork = (MapWork)w).getAliasToWork()).isEmpty()) continue;
                for (Operator op : ((HashMap)opMap).values()) {
                    this.setInputFormat(mapWork, op);
                }
            }
        } else if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task task2 : listTasks) {
                this.setInputFormat(task2);
            }
        }
        if (task.getChildTasks() != null) {
            for (Task<Serializable> childTask : task.getChildTasks()) {
                this.setInputFormat(childTask);
            }
        }
    }

    private void setInputFormat(MapWork work, Operator<? extends OperatorDesc> op) {
        if (op == null) {
            return;
        }
        if (op.isUseBucketizedHiveInputFormat()) {
            work.setUseBucketizedHiveInputFormat(true);
            return;
        }
        if (op.getChildOperators() != null) {
            for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
                this.setInputFormat(work, childOp);
            }
        }
    }

    @Override
    protected void decideExecMode(List<Task<? extends Serializable>> rootTasks, Context ctx, GlobalLimitCtx globalLimitCtx) throws SemanticException {
    }

    @Override
    protected void optimizeTaskPlan(List<Task<? extends Serializable>> rootTasks, ParseContext pCtx, Context ctx) throws SemanticException {
        PhysicalContext physicalCtx = new PhysicalContext(this.conf, pCtx, pCtx.getContext(), rootTasks, pCtx.getFetchTask());
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVENULLSCANOPTIMIZE)) {
            physicalCtx = new NullScanOptimizer().resolve(physicalCtx);
        } else {
            this.LOG.debug((Object)"Skipping null scan query optimization");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES)) {
            physicalCtx = new MetadataOnlyOptimizer().resolve(physicalCtx);
        } else {
            this.LOG.debug((Object)"Skipping metadata only query optimization");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CHECK_CROSS_PRODUCT)) {
            physicalCtx = new CrossProductCheck().resolve(physicalCtx);
        } else {
            this.LOG.debug((Object)"Skipping cross product analysis");
        }
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED)) {
            physicalCtx = new Vectorizer().resolve(physicalCtx);
        } else {
            this.LOG.debug((Object)"Skipping vectorization");
        }
        if (!"none".equalsIgnoreCase(this.conf.getVar(HiveConf.ConfVars.HIVESTAGEIDREARRANGE))) {
            physicalCtx = new StageIDsRearranger().resolve(physicalCtx);
        } else {
            this.LOG.debug((Object)"Skipping stage id rearranger");
        }
    }
}

