/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;

public class ColumnVectorBatch {
    public ColumnVector[] cols;
    public int size;

    public ColumnVectorBatch(int columnCount) {
        this(columnCount, 1024);
    }

    public ColumnVectorBatch(int columnCount, int batchSize) {
        this.cols = new ColumnVector[columnCount];
        this.size = batchSize;
    }

    public void swapColumnVector(int ix, ColumnVector[] other, int otherIx) {
        ColumnVector old = other[otherIx];
        other[otherIx] = this.cols[ix];
        this.cols[ix] = old;
    }

    public String toString() {
        if (this.size == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append("Column vector types: ");
        for (int k = 0; k < this.cols.length; ++k) {
            ColumnVector cv = this.cols[k];
            b.append(k);
            b.append(":");
            b.append(cv == null ? "null" : cv.getClass().getSimpleName().replace("ColumnVector", ""));
        }
        b.append('\n');
        for (int i = 0; i < this.size; ++i) {
            b.append('[');
            for (int k = 0; k < this.cols.length; ++k) {
                ColumnVector cv = this.cols[k];
                if (k > 0) {
                    b.append(", ");
                }
                if (cv == null || cv == null) continue;
                try {
                    cv.stringifyValue(b, i);
                    continue;
                }
                catch (Exception ex) {
                    b.append("invalid");
                }
            }
            b.append(']');
            if (i >= this.size - 1) continue;
            b.append('\n');
        }
        return b.toString();
    }
}

