/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hadoop.hive.metastore.IExtrapolatePartStatus;
import org.apache.hadoop.hive.metastore.api.Decimal;

public class LinearExtrapolatePartStatus
implements IExtrapolatePartStatus {
    @Override
    public Object extrapolate(Object[] min, Object[] max, int colStatIndex, Map<String, Integer> indexMap) {
        int maxInd;
        int rightBorderInd = indexMap.size() - 1;
        int minInd = indexMap.get((String)min[1]);
        if (minInd == (maxInd = indexMap.get((String)max[1]).intValue())) {
            return min[0];
        }
        if (aggrTypes[colStatIndex] == IExtrapolatePartStatus.AggrType.Max) {
            if (minInd < maxInd) {
                if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Long) {
                    return (Long)min[0] + ((Long)max[0] - (Long)min[0]) * (long)(rightBorderInd - minInd) / (long)(maxInd - minInd);
                }
                if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Double) {
                    return (Double)min[0] + ((Double)max[0] - (Double)min[0]) * (double)(rightBorderInd - minInd) / (double)(maxInd - minInd);
                }
                Decimal dmax = (Decimal)max[0];
                BigDecimal bdmax = new BigDecimal(dmax.toString());
                double doublemax = bdmax.doubleValue();
                Decimal dmin = (Decimal)min[0];
                BigDecimal bdmin = new BigDecimal(dmin.toString());
                double doublemin = bdmin.doubleValue();
                double ret = doublemin + (doublemax - doublemin) * (double)(rightBorderInd - minInd) / (double)(maxInd - minInd);
                return LinearExtrapolatePartStatus.createThriftDecimal(String.valueOf(ret));
            }
            if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Long) {
                return (Long)min[0] + ((Long)max[0] - (Long)min[0]) * (long)minInd / (long)(minInd - maxInd);
            }
            if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Double) {
                return (Double)min[0] + ((Double)max[0] - (Double)min[0]) * (double)minInd / (double)(maxInd - minInd);
            }
            Decimal dmax = (Decimal)max[0];
            BigDecimal bdmax = new BigDecimal(dmax.toString());
            double doublemax = bdmax.doubleValue();
            Decimal dmin = (Decimal)min[0];
            BigDecimal bdmin = new BigDecimal(dmin.toString());
            double doublemin = bdmin.doubleValue();
            double ret = doublemin + (doublemax - doublemin) * (double)minInd / (double)(maxInd - minInd);
            return LinearExtrapolatePartStatus.createThriftDecimal(String.valueOf(ret));
        }
        if (minInd < maxInd) {
            if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Long) {
                Long ret = (Long)max[0] - ((Long)max[0] - (Long)min[0]) * (long)maxInd / (long)(maxInd - minInd);
                return ret;
            }
            if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Double) {
                Double ret = (Double)max[0] - ((Double)max[0] - (Double)min[0]) * (double)maxInd / (double)(maxInd - minInd);
                return ret;
            }
            Decimal dmax = (Decimal)max[0];
            BigDecimal bdmax = new BigDecimal(dmax.toString());
            double doublemax = bdmax.doubleValue();
            Decimal dmin = (Decimal)min[0];
            BigDecimal bdmin = new BigDecimal(dmin.toString());
            double doublemin = bdmin.doubleValue();
            double ret = doublemax - (doublemax - doublemin) * (double)maxInd / (double)(maxInd - minInd);
            return LinearExtrapolatePartStatus.createThriftDecimal(String.valueOf(ret));
        }
        if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Long) {
            Long ret = (Long)max[0] - ((Long)max[0] - (Long)min[0]) * (long)(rightBorderInd - maxInd) / (long)(minInd - maxInd);
            return ret;
        }
        if (colStatTypes[colStatIndex] == IExtrapolatePartStatus.ColStatType.Double) {
            Double ret = (Double)max[0] - ((Double)max[0] - (Double)min[0]) * (double)(rightBorderInd - maxInd) / (double)(minInd - maxInd);
            return ret;
        }
        Decimal dmax = (Decimal)max[0];
        BigDecimal bdmax = new BigDecimal(dmax.toString());
        double doublemax = bdmax.doubleValue();
        Decimal dmin = (Decimal)min[0];
        BigDecimal bdmin = new BigDecimal(dmin.toString());
        double doublemin = bdmin.doubleValue();
        double ret = doublemax - (doublemax - doublemin) * (double)(rightBorderInd - maxInd) / (double)(minInd - maxInd);
        return LinearExtrapolatePartStatus.createThriftDecimal(String.valueOf(ret));
    }

    private static Decimal createThriftDecimal(String s) {
        BigDecimal d = new BigDecimal(s);
        return new Decimal(ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)d.scale());
    }
}

