/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import org.apache.kafka.clients.ClusterConnectionStates;
import org.apache.kafka.clients.ConnectionState;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.utils.MockTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClusterConnectionStatesTest {
    private final MockTime time = new MockTime();
    private final long reconnectBackoffMs = 10000L;
    private final long reconnectBackoffMax = 60000L;
    private final double reconnectBackoffJitter = 0.2;
    private final String nodeId1 = "1001";
    private final String nodeId2 = "2002";
    private ClusterConnectionStates connectionStates;

    @Before
    public void setup() {
        this.connectionStates = new ClusterConnectionStates(10000L, 60000L);
    }

    @Test
    public void testClusterConnectionStateChanges() {
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.connectionStates.connecting("1001", this.time.milliseconds());
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.CONNECTING);
        Assert.assertTrue((boolean)this.connectionStates.isConnecting("1001"));
        Assert.assertFalse((boolean)this.connectionStates.isReady("1001"));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes());
        this.time.sleep(100L);
        this.connectionStates.ready("1001");
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.READY);
        Assert.assertTrue((boolean)this.connectionStates.isReady("1001"));
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes());
        Assert.assertFalse((boolean)this.connectionStates.isConnecting("1001"));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)Long.MAX_VALUE);
        this.time.sleep(15000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.DISCONNECTED);
        Assert.assertTrue((boolean)this.connectionStates.isDisconnected("1001"));
        Assert.assertTrue((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isConnecting("1001"));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes());
        Assert.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        double backoffTolerance = 2000.0;
        long currentBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
        Assert.assertEquals((double)10000.0, (double)currentBackoff, (double)backoffTolerance);
        this.time.sleep(currentBackoff + 1L);
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
    }

    @Test
    public void testMultipleNodeConnectionStates() {
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assert.assertTrue((boolean)this.connectionStates.canConnect("2002", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes());
        this.connectionStates.connecting("2002", this.time.milliseconds());
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes());
        this.time.sleep(1000L);
        this.connectionStates.ready("2002");
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes());
        this.connectionStates.connecting("1001", this.time.milliseconds());
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes());
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes());
        this.time.sleep(12000L);
        this.connectionStates.disconnected("2002", this.time.milliseconds());
        Assert.assertTrue((boolean)this.connectionStates.hasReadyNodes());
        Assert.assertTrue((boolean)this.connectionStates.isBlackedOut("2002", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        this.time.sleep(this.connectionStates.connectionDelay("2002", this.time.milliseconds()));
        this.connectionStates.disconnected("1001", this.time.milliseconds() + 1L);
        Assert.assertTrue((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("2002", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes());
    }

    @Test
    public void testAuthorizationFailed() {
        this.connectionStates.connecting("1001", this.time.milliseconds());
        this.time.sleep(100L);
        this.connectionStates.authenticationFailed("1001", this.time.milliseconds(), new AuthenticationException("No path to CA for certificate!"));
        this.time.sleep(1000L);
        Assert.assertEquals((Object)this.connectionStates.connectionState("1001"), (Object)ConnectionState.AUTHENTICATION_FAILED);
        Assert.assertTrue((boolean)(this.connectionStates.authenticationException("1001") instanceof AuthenticationException));
        Assert.assertFalse((boolean)this.connectionStates.hasReadyNodes());
        Assert.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        this.time.sleep(this.connectionStates.connectionDelay("1001", this.time.milliseconds()) + 1L);
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
    }

    @Test
    public void testRemoveNode() {
        this.connectionStates.connecting("1001", this.time.milliseconds());
        this.time.sleep(1000L);
        this.connectionStates.ready("1001");
        this.time.sleep(10000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        this.connectionStates.remove("1001");
        Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
        Assert.assertFalse((boolean)this.connectionStates.isBlackedOut("1001", this.time.milliseconds()));
        Assert.assertEquals((long)this.connectionStates.connectionDelay("1001", this.time.milliseconds()), (long)0L);
    }

    @Test
    public void testMaxReconnectBackoff() {
        long effectiveMaxReconnectBackoff = Math.round(72000.0);
        this.connectionStates.connecting("1001", this.time.milliseconds());
        this.time.sleep(1000L);
        this.connectionStates.disconnected("1001", this.time.milliseconds());
        for (int i = 0; i < 100; ++i) {
            long reconnectBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
            Assert.assertTrue((reconnectBackoff <= effectiveMaxReconnectBackoff ? 1 : 0) != 0);
            Assert.assertFalse((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
            this.time.sleep(reconnectBackoff + 1L);
            Assert.assertTrue((boolean)this.connectionStates.canConnect("1001", this.time.milliseconds()));
            this.connectionStates.connecting("1001", this.time.milliseconds());
            this.time.sleep(10L);
            this.connectionStates.disconnected("1001", this.time.milliseconds());
        }
    }

    @Test
    public void testExponentialReconnectBackoff() {
        int reconnectBackoffExpBase = 2;
        double reconnectBackoffMaxExp = Math.log(60000.0 / (double)Math.max(10000L, 1L)) / Math.log(2.0);
        for (int i = 0; i < 10; ++i) {
            this.connectionStates.connecting("1001", this.time.milliseconds());
            this.connectionStates.disconnected("1001", this.time.milliseconds());
            long expectedBackoff = Math.round(Math.pow(2.0, Math.min((double)i, reconnectBackoffMaxExp)) * 10000.0);
            long currentBackoff = this.connectionStates.connectionDelay("1001", this.time.milliseconds());
            Assert.assertEquals((double)expectedBackoff, (double)currentBackoff, (double)(0.2 * (double)expectedBackoff));
            this.time.sleep(this.connectionStates.connectionDelay("1001", this.time.milliseconds()) + 1L);
        }
    }
}

