/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelState;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.NetworkTestUtils;
import org.apache.kafka.common.network.NioEchoServer;
import org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.security.TestSecurityConfig;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestCondition;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SslTransportLayerTest {
    private static final int BUFFER_SIZE = 4096;
    private NioEchoServer server;
    private Selector selector;
    private ChannelBuilder channelBuilder;
    private CertStores serverCertStores;
    private CertStores clientCertStores;
    private Map<String, Object> sslClientConfigs;
    private Map<String, Object> sslServerConfigs;

    @Before
    public void setup() throws Exception {
        this.serverCertStores = new CertStores(true, "server", "localhost");
        this.clientCertStores = new CertStores(false, "client", "localhost");
        this.sslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.sslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.channelBuilder = new SslChannelBuilder(Mode.CLIENT);
        this.channelBuilder.configure(this.sslClientConfigs);
        this.selector = new Selector(5000L, new Metrics(), (Time)new MockTime(), "MetricGroup", this.channelBuilder, new LogContext());
    }

    @After
    public void teardown() throws Exception {
        if (this.selector != null) {
            this.selector.close();
        }
        if (this.server != null) {
            this.server.close();
        }
    }

    @Test
    public void testValidEndpointIdentificationSanDns() throws Exception {
        String node = "0";
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
        this.server.verifyAuthenticationMetrics(1, 0);
    }

    @Test
    public void testValidEndpointIdentificationSanIp() throws Exception {
        String node = "0";
        this.serverCertStores = new CertStores(true, "server", InetAddress.getByName("127.0.0.1"));
        this.clientCertStores = new CertStores(false, "client", InetAddress.getByName("127.0.0.1"));
        this.sslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.sslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("127.0.0.1", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testValidEndpointIdentificationCN() throws Exception {
        String node = "0";
        this.serverCertStores = new CertStores(true, "localhost");
        this.clientCertStores = new CertStores(false, "localhost");
        this.sslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.sslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testEndpointIdentificationNoReverseLookup() throws Exception {
        String node = "0";
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("127.0.0.1", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
    }

    @Test
    public void testClientEndpointNotValidated() throws Exception {
        String node = "0";
        this.clientCertStores = new CertStores(false, "non-existent.com");
        this.serverCertStores = new CertStores(true, "localhost");
        this.sslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.sslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        TestSslChannelBuilder serverChannelBuilder = new TestSslChannelBuilder(Mode.SERVER){

            @Override
            protected TestSslChannelBuilder.TestSslTransportLayer newTransportLayer(String id, SelectionKey key, SSLEngine sslEngine) throws IOException {
                SSLParameters sslParams = sslEngine.getSSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                sslEngine.setSSLParameters(sslParams);
                return super.newTransportLayer(id, key, sslEngine);
            }
        };
        serverChannelBuilder.configure(this.sslServerConfigs);
        this.server = new NioEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(this.sslServerConfigs), "localhost", (ChannelBuilder)serverChannelBuilder, null);
        this.server.start();
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testInvalidEndpointIdentification() throws Exception {
        String node = "0";
        this.serverCertStores = new CertStores(true, "server", "notahost");
        this.clientCertStores = new CertStores(false, "client", "localhost");
        this.sslServerConfigs = this.serverCertStores.getTrustingConfig(this.clientCertStores);
        this.sslClientConfigs = this.clientCertStores.getTrustingConfig(this.serverCertStores);
        this.sslClientConfigs.put("ssl.endpoint.identification.algorithm", "HTTPS");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testEndpointIdentificationDisabled() throws Exception {
        String node = "0";
        String serverHost = InetAddress.getLocalHost().getHostAddress();
        SecurityProtocol securityProtocol = SecurityProtocol.SSL;
        this.server = new NioEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, new TestSecurityConfig(this.sslServerConfigs), serverHost, null, null);
        this.server.start();
        this.sslClientConfigs.remove("ssl.endpoint.identification.algorithm");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress(serverHost, this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testClientAuthenticationRequiredValidProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.client.auth", "required");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testListenerConfigOverride() throws Exception {
        String node = "0";
        ListenerName clientListenerName = new ListenerName("client");
        this.sslServerConfigs.put("ssl.client.auth", "required");
        this.sslServerConfigs.put(clientListenerName.configPrefix() + "ssl.client.auth", "none");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.createSelector(this.sslClientConfigs);
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
        this.selector.close();
        this.sslClientConfigs.remove("ssl.keystore.location");
        this.sslClientConfigs.remove("ssl.keystore.password");
        this.sslClientConfigs.remove("ssl.key.password");
        this.createSelector(this.sslClientConfigs);
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.selector.close();
        this.server.close();
        this.server = this.createEchoServer(clientListenerName, SecurityProtocol.SSL);
        addr = new InetSocketAddress("localhost", this.server.port());
        this.createSelector(this.sslClientConfigs);
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testClientAuthenticationRequiredUntrustedProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs = this.serverCertStores.getUntrustingConfig();
        this.sslServerConfigs.put("ssl.client.auth", "required");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testClientAuthenticationRequiredNotProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.client.auth", "required");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.remove("ssl.keystore.location");
        this.sslClientConfigs.remove("ssl.keystore.password");
        this.sslClientConfigs.remove("ssl.key.password");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testClientAuthenticationDisabledUntrustedProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs = this.serverCertStores.getUntrustingConfig();
        this.sslServerConfigs.put("ssl.client.auth", "none");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testClientAuthenticationDisabledNotProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.client.auth", "none");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.remove("ssl.keystore.location");
        this.sslClientConfigs.remove("ssl.keystore.password");
        this.sslClientConfigs.remove("ssl.key.password");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testClientAuthenticationRequestedValidProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.client.auth", "requested");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testClientAuthenticationRequestedNotProvided() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.client.auth", "requested");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.remove("ssl.keystore.location");
        this.sslClientConfigs.remove("ssl.keystore.password");
        this.sslClientConfigs.remove("ssl.key.password");
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testInvalidSecureRandomImplementation() throws Exception {
        SslChannelBuilder channelBuilder = new SslChannelBuilder(Mode.CLIENT);
        try {
            this.sslClientConfigs.put("ssl.secure.random.implementation", "invalid");
            channelBuilder.configure(this.sslClientConfigs);
            Assert.fail((String)"SSL channel configured with invalid SecureRandom implementation");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidTruststorePassword() throws Exception {
        SslChannelBuilder channelBuilder = new SslChannelBuilder(Mode.CLIENT);
        try {
            this.sslClientConfigs.put("ssl.truststore.password", "invalid");
            channelBuilder.configure(this.sslClientConfigs);
            Assert.fail((String)"SSL channel configured with invalid truststore password");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidKeystorePassword() throws Exception {
        SslChannelBuilder channelBuilder = new SslChannelBuilder(Mode.CLIENT);
        try {
            this.sslClientConfigs.put("ssl.keystore.password", "invalid");
            channelBuilder.configure(this.sslClientConfigs);
            Assert.fail((String)"SSL channel configured with invalid keystore password");
        }
        catch (KafkaException kafkaException) {
            // empty catch block
        }
    }

    @Test
    public void testNullTruststorePassword() throws Exception {
        String node = "0";
        this.sslClientConfigs.remove("ssl.truststore.password");
        this.sslServerConfigs.remove("ssl.truststore.password");
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 100, 10);
    }

    @Test
    public void testInvalidKeyPassword() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.key.password", new Password("invalid"));
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testUnsupportedTLSVersion() throws Exception {
        String node = "0";
        this.sslServerConfigs.put("ssl.enabled.protocols", Arrays.asList("TLSv1.2"));
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.put("ssl.enabled.protocols", Arrays.asList("TLSv1.1"));
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testUnsupportedCiphers() throws Exception {
        String node = "0";
        String[] cipherSuites = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
        this.sslServerConfigs.put("ssl.cipher.suites", Arrays.asList(cipherSuites[0]));
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.sslClientConfigs.put("ssl.cipher.suites", Arrays.asList(cipherSuites[1]));
        this.createSelector(this.sslClientConfigs);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
        this.server.verifyAuthenticationMetrics(0, 1);
    }

    @Test
    public void testNetReadBufferResize() throws Exception {
        String node = "0";
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs, 10, null, null);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 64000, 10);
    }

    @Test
    public void testNetWriteBufferResize() throws Exception {
        String node = "0";
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs, null, 10, null);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 64000, 10);
    }

    @Test
    public void testApplicationBufferResize() throws Exception {
        String node = "0";
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        this.createSelector(this.sslClientConfigs, null, null, 10);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.checkClientConnection(this.selector, node, 64000, 10);
    }

    @Test
    public void testNetworkThreadTimeRecorded() throws Exception {
        this.selector.close();
        this.selector = new Selector(-1, 5000L, new Metrics(), Time.SYSTEM, "MetricGroup", new HashMap(), false, true, this.channelBuilder, MemoryPool.NONE, new LogContext());
        String node = "0";
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        String message = TestUtils.randomString(0x100000);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
        KafkaChannel channel = this.selector.channel(node);
        Assert.assertTrue((String)"SSL handshake time not recorded", (channel.getAndResetNetworkThreadTimeNanos() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Time not reset", (long)0L, (long)channel.getAndResetNetworkThreadTimeNanos());
        this.selector.mute(node);
        this.selector.send((Send)new NetworkSend(node, ByteBuffer.wrap(message.getBytes())));
        while (this.selector.completedSends().isEmpty()) {
            this.selector.poll(100L);
        }
        long sendTimeNanos = channel.getAndResetNetworkThreadTimeNanos();
        Assert.assertTrue((String)("Send time not recorded: " + sendTimeNanos), (sendTimeNanos > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Time not reset", (long)0L, (long)channel.getAndResetNetworkThreadTimeNanos());
        Assert.assertFalse((String)"Unexpected bytes buffered", (boolean)channel.hasBytesBuffered());
        Assert.assertEquals((long)0L, (long)this.selector.completedReceives().size());
        this.selector.unmute(node);
        while (this.selector.completedReceives().isEmpty()) {
            this.selector.poll(100L);
            Assert.assertEquals((long)0L, (long)this.selector.numStagedReceives(channel));
        }
        long receiveTimeNanos = channel.getAndResetNetworkThreadTimeNanos();
        Assert.assertTrue((String)("Receive time not recorded: " + receiveTimeNanos), (receiveTimeNanos > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testIOExceptionsDuringHandshakeRead() throws Exception {
        this.testIOExceptionsDuringHandshake(true, false);
    }

    @Test
    public void testIOExceptionsDuringHandshakeWrite() throws Exception {
        this.testIOExceptionsDuringHandshake(false, true);
    }

    private void testIOExceptionsDuringHandshake(boolean failRead, boolean failWrite) throws Exception {
        this.server = this.createEchoServer(SecurityProtocol.SSL);
        TestSslChannelBuilder channelBuilder = new TestSslChannelBuilder(Mode.CLIENT);
        boolean done = false;
        for (int i = 1; i <= 100; ++i) {
            KafkaChannel channel;
            int readFailureIndex = failRead ? i : Integer.MAX_VALUE;
            int flushFailureIndex = failWrite ? i : Integer.MAX_VALUE;
            String node = String.valueOf(i);
            channelBuilder.readFailureIndex = readFailureIndex;
            channelBuilder.flushFailureIndex = flushFailureIndex;
            channelBuilder.configure(this.sslClientConfigs);
            this.selector = new Selector(5000L, new Metrics(), (Time)new MockTime(), "MetricGroup", (ChannelBuilder)channelBuilder, new LogContext());
            InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
            this.selector.connect(node, addr, 4096, 4096);
            for (int j = 0; j < 30; ++j) {
                this.selector.poll(1000L);
                KafkaChannel channel2 = this.selector.channel(node);
                if (channel2 != null && channel2.ready()) {
                    done = true;
                    break;
                }
                if (!this.selector.disconnected().containsKey(node)) continue;
                Assert.assertEquals((Object)ChannelState.State.AUTHENTICATE, (Object)((ChannelState)this.selector.disconnected().get(node)).state());
                break;
            }
            if ((channel = this.selector.channel(node)) == null) continue;
            Assert.assertTrue((String)("Channel not ready or disconnected:" + channel.state().state()), (boolean)channel.ready());
        }
        Assert.assertTrue((String)"Too many invocations of read/write during SslTransportLayer.handshake()", (boolean)done);
    }

    @Test
    public void testPeerNotifiedOfHandshakeFailure() throws Exception {
        this.sslServerConfigs = this.serverCertStores.getUntrustingConfig();
        this.sslServerConfigs.put("ssl.client.auth", "required");
        int i = 0;
        while (i < 3) {
            String node = "0";
            TestSslChannelBuilder serverChannelBuilder = new TestSslChannelBuilder(Mode.SERVER);
            serverChannelBuilder.configure(this.sslServerConfigs);
            serverChannelBuilder.flushDelayCount = i++;
            this.server = new NioEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), SecurityProtocol.SSL, new TestSecurityConfig(this.sslServerConfigs), "localhost", (ChannelBuilder)serverChannelBuilder, null);
            this.server.start();
            this.createSelector(this.sslClientConfigs);
            InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
            this.selector.connect(node, addr, 4096, 4096);
            NetworkTestUtils.waitForChannelClose(this.selector, node, ChannelState.State.AUTHENTICATION_FAILED);
            this.server.close();
            this.selector.close();
        }
    }

    @Test
    public void testCloseSsl() throws Exception {
        this.testClose(SecurityProtocol.SSL, (ChannelBuilder)new SslChannelBuilder(Mode.CLIENT));
    }

    @Test
    public void testClosePlaintext() throws Exception {
        this.testClose(SecurityProtocol.PLAINTEXT, (ChannelBuilder)new PlaintextChannelBuilder());
    }

    private void testClose(SecurityProtocol securityProtocol, ChannelBuilder clientChannelBuilder) throws Exception {
        String node = "0";
        this.server = this.createEchoServer(securityProtocol);
        clientChannelBuilder.configure(this.sslClientConfigs);
        this.selector = new Selector(5000L, new Metrics(), (Time)new MockTime(), "MetricGroup", clientChannelBuilder, new LogContext());
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port());
        this.selector.connect(node, addr, 4096, 4096);
        NetworkTestUtils.waitForChannelReady(this.selector, node);
        final ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        this.server.outputChannel(Channels.newChannel(bytesOut));
        this.server.selector().muteAll();
        byte[] message = TestUtils.randomString(100).getBytes();
        int count = 20;
        final int totalSendSize = count * (message.length + 4);
        for (int i = 0; i < count; ++i) {
            this.selector.send((Send)new NetworkSend(node, ByteBuffer.wrap(message)));
            do {
                this.selector.poll(0L);
            } while (this.selector.completedSends().isEmpty());
        }
        this.server.selector().unmuteAll();
        this.selector.close(node);
        TestUtils.waitForCondition(new TestCondition(){

            @Override
            public boolean conditionMet() {
                return bytesOut.toByteArray().length == totalSendSize;
            }
        }, 5000L, "All requests sent were not processed");
    }

    private void createSelector(Map<String, Object> sslClientConfigs) {
        this.createSelector(sslClientConfigs, null, null, null);
    }

    private void createSelector(Map<String, Object> sslClientConfigs, Integer netReadBufSize, Integer netWriteBufSize, Integer appBufSize) {
        TestSslChannelBuilder channelBuilder = new TestSslChannelBuilder(Mode.CLIENT);
        channelBuilder.configureBufferSizes(netReadBufSize, netWriteBufSize, appBufSize);
        this.channelBuilder = channelBuilder;
        this.channelBuilder.configure(sslClientConfigs);
        this.selector = new Selector(5000L, new Metrics(), (Time)new MockTime(), "MetricGroup", (ChannelBuilder)channelBuilder, new LogContext());
    }

    private NioEchoServer createEchoServer(ListenerName listenerName, SecurityProtocol securityProtocol) throws Exception {
        return NetworkTestUtils.createEchoServer(listenerName, securityProtocol, new TestSecurityConfig(this.sslServerConfigs), null);
    }

    private NioEchoServer createEchoServer(SecurityProtocol securityProtocol) throws Exception {
        return this.createEchoServer(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private static class TestSslChannelBuilder
    extends SslChannelBuilder {
        private Integer netReadBufSizeOverride;
        private Integer netWriteBufSizeOverride;
        private Integer appBufSizeOverride;
        long readFailureIndex = Long.MAX_VALUE;
        long flushFailureIndex = Long.MAX_VALUE;
        int flushDelayCount = 0;

        public TestSslChannelBuilder(Mode mode) {
            super(mode);
        }

        public void configureBufferSizes(Integer netReadBufSize, Integer netWriteBufSize, Integer appBufSize) {
            this.netReadBufSizeOverride = netReadBufSize;
            this.netWriteBufSizeOverride = netWriteBufSize;
            this.appBufSizeOverride = appBufSize;
        }

        protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, String host) throws IOException {
            SocketChannel socketChannel = (SocketChannel)key.channel();
            SSLEngine sslEngine = sslFactory.createSslEngine(host, socketChannel.socket().getPort());
            TestSslTransportLayer transportLayer = this.newTransportLayer(id, key, sslEngine);
            transportLayer.startHandshake();
            return transportLayer;
        }

        protected TestSslTransportLayer newTransportLayer(String id, SelectionKey key, SSLEngine sslEngine) throws IOException {
            return new TestSslTransportLayer(id, key, sslEngine);
        }

        private static class ResizeableBufferSize {
            private Integer bufSizeOverride;

            ResizeableBufferSize(Integer bufSizeOverride) {
                this.bufSizeOverride = bufSizeOverride;
            }

            int updateAndGet(int actualSize, boolean update) {
                int size = actualSize;
                if (this.bufSizeOverride != null) {
                    if (update) {
                        this.bufSizeOverride = Math.min(this.bufSizeOverride * 2, size);
                    }
                    size = this.bufSizeOverride;
                }
                return size;
            }
        }

        class TestSslTransportLayer
        extends SslTransportLayer {
            private final ResizeableBufferSize netReadBufSize;
            private final ResizeableBufferSize netWriteBufSize;
            private final ResizeableBufferSize appBufSize;
            private final AtomicLong numReadsRemaining;
            private final AtomicLong numFlushesRemaining;
            private final AtomicInteger numDelayedFlushesRemaining;

            public TestSslTransportLayer(String channelId, SelectionKey key, SSLEngine sslEngine) throws IOException {
                super(channelId, key, sslEngine, false);
                this.netReadBufSize = new ResizeableBufferSize(TestSslChannelBuilder.this.netReadBufSizeOverride);
                this.netWriteBufSize = new ResizeableBufferSize(TestSslChannelBuilder.this.netWriteBufSizeOverride);
                this.appBufSize = new ResizeableBufferSize(TestSslChannelBuilder.this.appBufSizeOverride);
                this.numReadsRemaining = new AtomicLong(TestSslChannelBuilder.this.readFailureIndex);
                this.numFlushesRemaining = new AtomicLong(TestSslChannelBuilder.this.flushFailureIndex);
                this.numDelayedFlushesRemaining = new AtomicInteger(TestSslChannelBuilder.this.flushDelayCount);
            }

            protected int netReadBufferSize() {
                ByteBuffer netReadBuffer = this.netReadBuffer();
                boolean updateBufSize = netReadBuffer != null && !this.netReadBuffer().hasRemaining();
                return this.netReadBufSize.updateAndGet(super.netReadBufferSize(), updateBufSize);
            }

            protected int netWriteBufferSize() {
                return this.netWriteBufSize.updateAndGet(super.netWriteBufferSize(), true);
            }

            protected int applicationBufferSize() {
                return this.appBufSize.updateAndGet(super.applicationBufferSize(), true);
            }

            protected int readFromSocketChannel() throws IOException {
                if (this.numReadsRemaining.decrementAndGet() == 0L && !this.ready()) {
                    throw new IOException("Test exception during read");
                }
                return super.readFromSocketChannel();
            }

            protected boolean flush(ByteBuffer buf) throws IOException {
                if (this.numFlushesRemaining.decrementAndGet() == 0L && !this.ready()) {
                    throw new IOException("Test exception during write");
                }
                if (this.numDelayedFlushesRemaining.getAndDecrement() != 0) {
                    return false;
                }
                this.resetDelayedFlush();
                return super.flush(buf);
            }

            private void resetDelayedFlush() {
                this.numDelayedFlushesRemaining.set(TestSslChannelBuilder.this.flushDelayCount);
            }
        }
    }
}

