/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Joined;
import org.apache.kafka.streams.kstream.ValueJoiner;
import org.apache.kafka.streams.kstream.internals.BaseJoinProcessorNode;
import org.apache.kafka.streams.kstream.internals.ProcessorParameters;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.WindowStore;

class StreamStreamJoinNode<K, V1, V2, VR>
extends BaseJoinProcessorNode<K, V1, V2, VR> {
    private final ProcessorSupplier<K, V1> thisWindowedStreamProcessorSupplier;
    private final ProcessorSupplier<K, V2> otherWindowedStreamProcessorSupplier;
    private final StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder;
    private final StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder;
    private final Joined<K, V1, V2> joined;
    private final String thisWindowedStreamName;
    private final String otherWindowedStreamName;

    StreamStreamJoinNode(String parentProcessorNodeName, String processorNodeName, ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner, ProcessorParameters<K, V1> joinThisProcessorParameters, ProcessorParameters<K, V2> joinOtherProcessParameters, ProcessorParameters<K, VR> joinMergeProcessorParameters, ProcessorParameters<K, V1> thisWindowedStreamProcessorParameters, ProcessorParameters<K, V2> otherWindowedStreamProcessorParameters, StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder, StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder, Joined<K, V1, V2> joined, String leftHandSideStreamName, String otherStreamName) {
        super(parentProcessorNodeName, processorNodeName, valueJoiner, joinThisProcessorParameters, joinOtherProcessParameters, joinMergeProcessorParameters, leftHandSideStreamName, otherStreamName);
        this.thisWindowedStreamProcessorSupplier = thisWindowedStreamProcessorParameters.processorSupplier();
        this.otherWindowedStreamProcessorSupplier = otherWindowedStreamProcessorParameters.processorSupplier();
        this.thisWindowedStreamName = thisWindowedStreamProcessorParameters.processorName();
        this.otherWindowedStreamName = otherWindowedStreamProcessorParameters.processorName();
        this.thisWindowStoreBuilder = thisWindowStoreBuilder;
        this.otherWindowStoreBuilder = otherWindowStoreBuilder;
        this.joined = joined;
    }

    ProcessorSupplier<K, V1> thisWindowedStreamProcessorSupplier() {
        return this.thisWindowedStreamProcessorSupplier;
    }

    ProcessorSupplier<K, V2> otherWindowedStreamProcessorSupplier() {
        return this.otherWindowedStreamProcessorSupplier;
    }

    String thisWindowedStreamName() {
        return this.thisWindowedStreamName;
    }

    String otherWindowedStreamName() {
        return this.otherWindowedStreamName;
    }

    StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder() {
        return this.thisWindowStoreBuilder;
    }

    StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder() {
        return this.otherWindowStoreBuilder;
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }

    static <K, V, V1, V2, VR> StreamStreamJoinNodeBuilder<K, V1, V2, VR> streamStreamJoinNodeBuilder() {
        return new StreamStreamJoinNodeBuilder();
    }

    static final class StreamStreamJoinNodeBuilder<K, V1, V2, VR> {
        private String processorNodeName;
        private String parentProcessorNodeName;
        private ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner;
        private ProcessorParameters<K, V1> joinThisProcessorParameters;
        private ProcessorParameters<K, V2> joinOtherProcessorParameters;
        private ProcessorParameters<K, VR> joinMergeProcessorParameters;
        private ProcessorParameters<K, V1> thisWindowedStreamProcessorParameters;
        private ProcessorParameters<K, V2> otherWindowedStreamProcessorParameters;
        private StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder;
        private StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder;
        private Joined<K, V1, V2> joined;
        private String leftHandSideStreamName;
        private String otherStreamName;

        private StreamStreamJoinNodeBuilder() {
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withValueJoiner(ValueJoiner<? super V1, ? super V2, ? extends VR> valueJoiner) {
            this.valueJoiner = valueJoiner;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinThisProcessorParameters(ProcessorParameters<K, V1> joinThisProcessorParameters) {
            this.joinThisProcessorParameters = joinThisProcessorParameters;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowedStreamProcessorParameters(ProcessorParameters<K, V1> thisWindowedStreamProcessorParameters) {
            this.thisWindowedStreamProcessorParameters = thisWindowedStreamProcessorParameters;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withProcessorNodeName(String name) {
            this.processorNodeName = name;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withParentProcessorNodeName(String predecessorNodeName) {
            this.parentProcessorNodeName = predecessorNodeName;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinOtherProcessorParameters(ProcessorParameters<K, V2> joinOtherProcessParameters) {
            this.joinOtherProcessorParameters = joinOtherProcessParameters;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowedStreamProcessorParameters(ProcessorParameters<K, V2> otherWindowedStreamProcessorParameters) {
            this.otherWindowedStreamProcessorParameters = otherWindowedStreamProcessorParameters;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoinMergeProcessorParameters(ProcessorParameters<K, VR> joinMergeProcessorParameters) {
            this.joinMergeProcessorParameters = joinMergeProcessorParameters;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withLeftHandSideStreamName(String leftHandSideStreamName) {
            this.leftHandSideStreamName = leftHandSideStreamName;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherStreamName(String otherStreamName) {
            this.otherStreamName = otherStreamName;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withThisWindowStoreBuilder(StoreBuilder<WindowStore<K, V1>> thisWindowStoreBuilder) {
            this.thisWindowStoreBuilder = thisWindowStoreBuilder;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withOtherWindowStoreBuilder(StoreBuilder<WindowStore<K, V2>> otherWindowStoreBuilder) {
            this.otherWindowStoreBuilder = otherWindowStoreBuilder;
            return this;
        }

        StreamStreamJoinNodeBuilder<K, V1, V2, VR> withJoined(Joined<K, V1, V2> joined) {
            this.joined = joined;
            return this;
        }

        StreamStreamJoinNode<K, V1, V2, VR> build() {
            return new StreamStreamJoinNode<K, V1, V2, VR>(this.parentProcessorNodeName, this.processorNodeName, this.valueJoiner, this.joinThisProcessorParameters, this.joinOtherProcessorParameters, this.joinMergeProcessorParameters, this.thisWindowedStreamProcessorParameters, this.otherWindowedStreamProcessorParameters, this.thisWindowStoreBuilder, this.otherWindowStoreBuilder, this.joined, this.leftHandSideStreamName, this.otherStreamName);
        }
    }
}

