/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.common.KafkaException;
import kafka.utils.CoreUtils$;
import kafka.utils.UtilsTest$;
import kafka.utils.UtilsTest$$anonfun$testGetOrElseUpdateAtomically$1$;
import org.apache.kafka.common.utils.Base64;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u000f\tIQ\u000b^5mgR+7\u000f\u001e\u0006\u0003\u0007\u0011\tQ!\u001e;jYNT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n!5\t!B\u0003\u0002\f\u0019\u0005)!.\u001e8ji*\u0011QBD\u0001\ng\u000e\fG.\u0019;fgRT\u0011aD\u0001\u0004_J<\u0017BA\t\u000b\u0005)QUK\\5u'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001C\u0002\u0013%\u0011$\u0001\u0004m_\u001e<WM]\u000b\u00025A\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0006Y><GG\u001b\u0006\u0003?9\ta!\u00199bG\",\u0017BA\u0011\u001d\u0005\u0019aunZ4fe\"11\u0005\u0001Q\u0001\ni\tq\u0001\\8hO\u0016\u0014\b\u0005C\u0004&\u0001\t\u0007I\u0011\u0001\u0014\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0014\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013!\u0002:fO\u0016D(B\u0001\u0017.\u0003\u0011)H/\u001b7\u000b\u00039\nAA[1wC&\u0011\u0001'\u000b\u0002\b!\u0006$H/\u001a:o\u0011\u0019\u0011\u0004\u0001)A\u0005O\u0005\t2\r\\;ti\u0016\u0014\u0018\n\u001a)biR,'O\u001c\u0011\t\u000bQ\u0002A\u0011A\u001b\u0002\u0017Q,7\u000f^*xC2dwn\u001e\u000b\u0002mA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t!QK\\5uQ\t\u0019T\b\u0005\u0002?\u00016\tqH\u0003\u0002\f\u001d%\u0011\u0011i\u0010\u0002\u0005)\u0016\u001cH\u000fC\u0003D\u0001\u0011\u0005Q'\u0001\u000buKN$8)\u001b:dk2\f'/\u0013;fe\u0006$xN\u001d\u0015\u0003\u0005vBQA\u0012\u0001\u0005\u0002U\nQ\u0002^3tiJ+\u0017\r\u001a\"zi\u0016\u001c\bFA#>\u0011\u0015I\u0005\u0001\"\u00016\u0003\u001d!Xm\u001d;BEND#\u0001S\u001f\t\u000b1\u0003A\u0011A\u001b\u0002#Q,7\u000f\u001e*fa2\f7-Z*vM\u001aL\u0007\u0010\u000b\u0002L{!)q\n\u0001C\u0001k\u0005YA/Z:u%\u0016\fG-\u00138uQ\tqU\bC\u0003S\u0001\u0011\u0005Q'A\u0006uKN$8i\u001d<MSN$\bFA)>\u0011\u0015)\u0006\u0001\"\u00016\u0003)!Xm\u001d;DgZl\u0015\r\u001d\u0015\u0003)vBQ\u0001\u0017\u0001\u0005\u0002U\n!\u0002^3ti&sGj\\2lQ\t9V\bC\u0003\\\u0001\u0011\u0005Q'A\u000euKN$XK\u001d7TC\u001a,')Y:fmQ*enY8eKV+\u0016\n\u0012\u0015\u00035vBQA\u0018\u0001\u0005\u0002U\n\u0001\u0004^3ti\u001e+g.\u001a:bi\u0016,V/\u001b3Bg\n\u000b7/\u001a\u001c5Q\tiV\bC\u0003b\u0001\u0011\u0005Q'A\u000fuKN$x)\u001a;Pe\u0016c7/Z+qI\u0006$X-\u0011;p[&\u001c\u0017\r\u001c7zQ\t\u0001W\b")
public class UtilsTest
extends JUnitSuite {
    private final Logger kafka$utils$UtilsTest$$logger = Logger.getLogger(UtilsTest.class);
    private final Pattern clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");

    public Logger kafka$utils$UtilsTest$$logger() {
        return this.kafka$utils$UtilsTest$$logger;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UtilsTest $outer;

            public final void apply(Object x$1, Throwable x$2) {
                this.$outer.kafka$utils$UtilsTest$$logger().info(x$1, x$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new KafkaException("test");
            }
        });
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = CoreUtils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = CoreUtils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
    }

    @Test
    public void testReadBytes() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "a", "abcd"})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String testCase) {
                byte[] bytes = testCase.getBytes();
                Assert.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
            }
        });
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * Predef$.MODULE$.intArrayOps(values).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)new Serializable(this, values, buffer){
            public static final long serialVersionUID = 0L;
            private final int[] values$1;
            private final ByteBuffer buffer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.buffer$1.putInt(i * 4, this.values$1[i]);
                Assert.assertEquals((String)"Written value should match read value.", (long)this.values$1[i], (long)CoreUtils$.MODULE$.readInt(this.buffer$1.array(), i * 4));
            }
            {
                this.values$1 = values$1;
                this.buffer$1 = buffer$1;
            }
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assert.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        Map ipv6Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6);
        ipv6Map.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> m) {
                Assert.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
                Assert.assertTrue((boolean)((String)m._2()).equals("v"));
            }
        });
        String singleEntry = "key:value";
        Map singleMap = CoreUtils$.MODULE$.parseCsvMap(singleEntry);
        Object value = singleMap.getOrElse((Object)"key", (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 0;
            }
        });
        Assert.assertTrue((boolean)value.equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        Map ipv4Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4);
        ipv4Map.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> m) {
                Assert.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
                Assert.assertTrue((boolean)((String)m._2()).equals("allow"));
            }
        });
        String kvPairsSpaces = "key:value      , key:   value";
        Map spaceMap = CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces);
        spaceMap.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> m) {
                Assert.assertTrue((boolean)((String)m._1()).equals("key"));
                Assert.assertTrue((boolean)((String)m._2()).equals("value"));
            }
        });
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)CoreUtils$.MODULE$.inLock((Lock)lock, (Function0)new Serializable(this, lock){
            public static final long serialVersionUID = 0L;
            private final ReentrantLock lock$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                Assert.assertTrue((String)"Should be in lock", (boolean)this.lock$1.isHeldByCurrentThread());
                return 2;
            }
            {
                this.lock$1 = lock$1;
            }
        }));
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.urlEncoderNoPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assert.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assert.assertEquals((long)clusterId1.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.urlEncoderNoPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assert.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assert.assertEquals((long)clusterId2.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOrElseUpdateAtomically() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        try {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foreach((Function1)new Serializable(this, createdCount, map, executor){
                public static final long serialVersionUID = 0L;
                public final AtomicInteger createdCount$1;
                public final scala.collection.concurrent.Map map$1;
                private final ExecutorService executor$1;

                public final Future<?> apply(int i) {
                    return this.executor$1.submit(new Runnable(this){
                        private final /* synthetic */ $anonfun$testGetOrElseUpdateAtomically$1 $outer;

                        public void run() {
                            ((AtomicInteger)CoreUtils$.MODULE$.atomicGetOrUpdate(this.$outer.map$1, (Object)BoxesRunTime.boxToInteger((int)0), (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testGetOrElseUpdateAtomically$1$$anon$1 $outer;

                                public final AtomicInteger apply() {
                                    this.$outer.kafka$utils$UtilsTest$$anonfun$$anon$$$outer().createdCount$1.incrementAndGet();
                                    return new AtomicInteger();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            })).incrementAndGet();
                        }

                        public /* synthetic */ $anonfun$testGetOrElseUpdateAtomically$1 kafka$utils$UtilsTest$$anonfun$$anon$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.createdCount$1 = createdCount$1;
                    this.map$1 = map$1;
                    this.executor$1 = executor$1;
                }
            });
            executor.shutdown();
            executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)count, (long)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Too many creations ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)created)})), (created > 0 && created <= nThreads ? 1 : 0) != 0);
            executor.shutdownNow();
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.shutdownNow();
            throw throwable;
        }
    }
}

