/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.Request$;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ReplicaNotAvailableException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002U1si&$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003\u001d\u0019G.^:uKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAq\u0001\u0006\u0001C\u0002\u0013\u0005Q#\u0001\u0005ce>\\WM]%e+\u00051\u0002CA\u0005\u0018\u0013\tA\"BA\u0002J]RDaA\u0007\u0001!\u0002\u00131\u0012!\u00032s_.,'/\u00133!\u0011\u001da\u0002A1A\u0005\u0002u\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.F\u0001\u001f!\tyr%D\u0001!\u0015\t\t#%\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\rR!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sO&\u0011\u0001\u0006\t\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019Q\u0003\u0001)A\u0005=\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007\u0005C\u0004-\u0001\t\u0007I\u0011A\u0017\u0002\tQLW.Z\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0006kRLGn]\u0005\u0003gA\u0012\u0001\"T8dWRKW.\u001a\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\u000bQLW.\u001a\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005\u0001\"M]8lKJ$v\u000e]5d'R\fGo]\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005yZ$\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005\t\"M]8lKJ$v\u000e]5d'R\fGo\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u00069Q.\u001a;sS\u000e\u001cX#\u0001#\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\t\u0003\u0013B\u0001%G\u0005\u001diU\r\u001e:jGNDaA\u0013\u0001!\u0002\u0013!\u0015\u0001C7fiJL7m\u001d\u0011\t\u00131\u0003\u0001\u0019!a\u0001\n\u0003i\u0015A\u0002;na\u0012K'/F\u0001O!\tyE+D\u0001Q\u0015\t\t&+\u0001\u0002j_*\t1+\u0001\u0003kCZ\f\u0017BA+Q\u0005\u00111\u0015\u000e\\3\t\u0013]\u0003\u0001\u0019!a\u0001\n\u0003A\u0016A\u0003;na\u0012K'o\u0018\u0013fcR\u0011\u0011\f\u0018\t\u0003\u0013iK!a\u0017\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b;Z\u000b\t\u00111\u0001O\u0003\rAH%\r\u0005\u0007?\u0002\u0001\u000b\u0015\u0002(\u0002\u000fQl\u0007\u000fR5sA!I\u0011\r\u0001a\u0001\u0002\u0004%\t!T\u0001\bY><G)\u001b:2\u0011%\u0019\u0007\u00011AA\u0002\u0013\u0005A-A\u0006m_\u001e$\u0015N]\u0019`I\u0015\fHCA-f\u0011\u001di&-!AA\u00029Caa\u001a\u0001!B\u0013q\u0015\u0001\u00037pO\u0012K'/\r\u0011\t\u0013%\u0004\u0001\u0019!a\u0001\n\u0003i\u0015a\u00027pO\u0012K'O\r\u0005\nW\u0002\u0001\r\u00111A\u0005\u00021\f1\u0002\\8h\t&\u0014(g\u0018\u0013fcR\u0011\u0011,\u001c\u0005\b;*\f\t\u00111\u0001O\u0011\u0019y\u0007\u0001)Q\u0005\u001d\u0006AAn\\4ESJ\u0014\u0004\u0005C\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014X#A:\u0011\u0005i\"\u0018BA;<\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0001=\u0002%I,\u0007\u000f\\5dC6\u000bg.Y4fe~#S-\u001d\u000b\u00033fDq!\u0018<\u0002\u0002\u0003\u00071\u000f\u0003\u0004|\u0001\u0001\u0006Ka]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA!IQ\u0010\u0001a\u0001\u0002\u0004%\tA`\u0001\u000bY><W*\u00198bO\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002\u0005\u0003\rawnZ\u0005\u0005\u0003\u0013\t\u0019A\u0001\u0006M_\u001el\u0015M\\1hKJD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\u0005qAn\\4NC:\fw-\u001a:`I\u0015\fHcA-\u0002\u0012!AQ,a\u0003\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0016\u0001\u0001\u000b\u0015B@\u0002\u00171|w-T1oC\u001e,'\u000f\t\u0005\f\u00033\u0001\u0001\u0019!a\u0001\n\u0003\tY\"A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u0011Q\u0004\t\u0005\u0003\u0003\ty\"\u0003\u0003\u0002\"\u0005\r!!\u0003'pO\u000e{gNZ5h\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\u0002\u001b1|wmQ8oM&<w\fJ3r)\rI\u0016\u0011\u0006\u0005\n;\u0006\r\u0012\u0011!a\u0001\u0003;A\u0001\"!\f\u0001A\u0003&\u0011QD\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003bBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0006g\u0016$X\u000f\u001d\u000b\u00023\"\"\u0011qFA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001fK\u0005)!.\u001e8ji&!\u0011\u0011IA\u001e\u0005\u0019\u0011UMZ8sK\"9\u0011Q\t\u0001\u0005\u0002\u0005M\u0012\u0001\u0003;fCJ$un\u001e8)\t\u0005\r\u0013\u0011\n\t\u0005\u0003s\tY%\u0003\u0003\u0002N\u0005m\"!B!gi\u0016\u0014\bbBA)\u0001\u0011\u0005\u00111G\u0001)i\u0016\u001cH/T1zE\u0016\u0014V\r\u001d7bG\u0016\u001cUO\u001d:f]R<\u0016\u000e\u001e5GkR,(/\u001a*fa2L7-\u0019\u0015\u0005\u0003\u001f\n)\u0006\u0005\u0003\u0002:\u0005]\u0013\u0002BA-\u0003w\u0011A\u0001V3ti\"9\u0011Q\f\u0001\u0005\u0002\u0005M\u0012A\f;fgR\f\u0005\u000f]3oIJ+7m\u001c:eg\u0006\u001bhi\u001c7m_^,'OQ3m_^dunZ*uCJ$xJ\u001a4tKRDC!a\u0017\u0002V!9\u00111\r\u0001\u0005\u0002\u0005M\u0012A\u0004;fgR<U\r\u001e*fa2L7-\u0019\u0015\u0005\u0003C\n)\u0006C\u0004\u0002j\u0001!\t!a\r\u0002oQ,7\u000f^!qa\u0016tGMU3d_J$7\u000fV8G_2dwn^3s/&$\bNT8SKBd\u0017nY1UQJ|wo]#yG\u0016\u0004H/[8oQ\u0011\t9'!\u0016\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r\u0005i1M]3bi\u0016\u0014VmY8sIN$\u0002\"a\u001d\u0002\u0000\u0005\u0005\u00161\u0016\t\u0005\u0003k\nY(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u0011\u0002\rI,7m\u001c:e\u0013\u0011\ti(a\u001e\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\t\t)!\u001cA\u0002\u0005\r\u0015a\u0002:fG>\u0014Hm\u001d\t\u0007\u0003\u000b\u000b)*a'\u000f\t\u0005\u001d\u0015\u0011\u0013\b\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011bAAJ\u0015\u00059\u0001/Y2lC\u001e,\u0017\u0002BAL\u00033\u0013\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003'S\u0001\u0003BA;\u0003;KA!a(\u0002x\ta1+[7qY\u0016\u0014VmY8sI\"A\u00111UA7\u0001\u0004\t)+\u0001\u0006cCN,wJ\u001a4tKR\u00042!CAT\u0013\r\tIK\u0003\u0002\u0005\u0019>tw\rC\u0005\u0002.\u00065\u0004\u0013!a\u0001-\u0005!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"D\u0011\"!-\u0001#\u0003%\t!a-\u0002/\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u001aTCAA[U\r1\u0012qW\u0016\u0003\u0003s\u0003B!a/\u0002F6\u0011\u0011Q\u0018\u0006\u0005\u0003\u007f\u000b\t-A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0019\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002H\u0006u&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class PartitionTest {
    private final int brokerId;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Metrics metrics = new Metrics();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private ReplicaManager replicaManager;
    private LogManager logManager;
    private LogConfig logConfig;

    public int brokerId() {
        return this.brokerId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    @Before
    public void setup() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        this.logConfig_$eq(new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2()));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        boolean x$2 = false;
        int x$3 = CleanerConfig$.MODULE$.apply$default$1();
        long x$4 = CleanerConfig$.MODULE$.apply$default$2();
        double x$5 = CleanerConfig$.MODULE$.apply$default$3();
        int x$6 = CleanerConfig$.MODULE$.apply$default$4();
        int x$7 = CleanerConfig$.MODULE$.apply$default$5();
        double x$8 = CleanerConfig$.MODULE$.apply$default$6();
        long x$9 = CleanerConfig$.MODULE$.apply$default$7();
        String x$10 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))), this.logConfig(), new CleanerConfig(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$2, x$10), this.time()));
        this.logManager().startup();
        Properties brokerProps = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        brokerProps.put(KafkaConfig$.MODULE$.LogDirsProp(), ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir1(), this.logDir2()}))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getAbsolutePath();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(brokerProps);
        this.replicaManager_$eq(new ReplicaManager(brokerConfig, this.metrics(), (Time)this.time(), null, (Scheduler)new MockScheduler((Time)this.time()), this.logManager(), new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(brokerConfig, this.metrics(), (Time)this.time(), ""), this.brokerTopicStats(), new MetadataCache(this.brokerId()), new LogDirFailureChannel(brokerConfig.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
    }

    @After
    public void tearDown() {
        this.brokerTopicStats().close();
        this.metrics().close();
        this.logManager().shutdown();
        Utils.delete((File)this.tmpDir());
        this.logManager().liveLogDirs().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File x$1) {
                Utils.delete((File)x$1);
            }
        });
        this.replicaManager().shutdown(false);
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        LogManager qual$1 = this.logManager();
        TopicPartition x$11 = this.topicPartition();
        LogConfig x$12 = this.logConfig();
        boolean x$13 = qual$1.getOrCreateLog$default$3();
        boolean x$14 = qual$1.getOrCreateLog$default$4();
        Log log1 = qual$1.getOrCreateLog(x$11, x$12, x$13, x$14);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        LogManager qual$2 = this.logManager();
        TopicPartition x$15 = this.topicPartition();
        LogConfig x$16 = this.logConfig();
        boolean x$17 = true;
        boolean x$18 = qual$2.getOrCreateLog$default$3();
        Log log2 = qual$2.getOrCreateLog(x$15, x$16, x$18, x$17);
        int x$19 = this.brokerId();
        TopicPartition x$20 = this.topicPartition();
        MockTime x$21 = this.time();
        Some x$22 = new Some((Object)log1);
        long x$23 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica currentReplica = new Replica(x$19, x$20, (Time)x$21, x$23, (Option)x$22);
        int x$24 = Request$.MODULE$.FutureLocalReplicaId();
        TopicPartition x$25 = this.topicPartition();
        MockTime x$26 = this.time();
        Some x$27 = new Some((Object)log2);
        long x$28 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica futureReplica = new Replica(x$24, x$25, (Time)x$26, x$28, (Option)x$27);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        partition.addReplicaIfNotExists(futureReplica);
        partition.addReplicaIfNotExists(currentReplica);
        Assert.assertEquals((Object)new Some((Object)currentReplica), (Object)partition.getReplica(this.brokerId()));
        Assert.assertEquals((Object)new Some((Object)futureReplica), (Object)partition.getReplica(Request$.MODULE$.FutureLocalReplicaId()));
        Thread thread1 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.removeFutureLocalReplica(this.partition$1.removeFutureLocalReplica$default$1());
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        Thread thread2 = new Thread(this, latch, partition){
            private final CountDownLatch latch$1;
            private final Partition partition$1;

            public void run() {
                this.latch$1.await();
                this.partition$1.maybeReplaceCurrentWithFutureReplica();
            }
            {
                this.latch$1 = latch$1;
                this.partition$1 = partition$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.getReplica(Request$.MODULE$.FutureLocalReplicaId()));
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        LogManager qual$3 = this.logManager();
        TopicPartition x$29 = this.topicPartition();
        LogConfig x$30 = this.logConfig();
        boolean x$31 = qual$3.getOrCreateLog$default$3();
        boolean x$32 = qual$3.getOrCreateLog$default$4();
        Log log2 = qual$3.getOrCreateLog(x$29, x$30, x$31, x$32);
        int x$33 = this.brokerId();
        TopicPartition x$34 = this.topicPartition();
        MockTime x$35 = this.time();
        Some x$36 = new Some((Object)log2);
        long x$37 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$33, x$34, (Time)x$35, x$37, (Option)x$36);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)new Some((Object)replica), (Object)partition.getReplica(replica.brokerId()));
        long initialLogStartOffset = 5L;
        partition.truncateFullyAndStartAt(initialLogStartOffset, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after truncate fully and start at ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)initialLogStartOffset)})), (long)initialLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.partition$2.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 3L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)initialLogStartOffset, (long)replica.logEndOffset().messageOffset());
        long newLogStartOffset = 4L;
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes()), new SimpleRecord("k3".getBytes(), "v3".getBytes())})), newLogStartOffset, this.createRecords$default$3());
        partition.appendRecordsToFollowerOrFutureReplica(records2, false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)7L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset after append of 3 records with base offset ", ":"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newLogStartOffset)})), (long)newLogStartOffset, (long)replica.logStartOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 7L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 7:"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MemoryRecords records2 = this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())})), 3L, this.$outer.createRecords$default$3());
                this.partition$2.appendRecordsToFollowerOrFutureReplica(records2, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$2 = partition$2;
            }
        }, ClassTag$.MODULE$.apply(UnexpectedAppendOffsetException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset should not change after failure to append"})).s((Seq)Nil$.MODULE$), (long)8L, (long)replica.logEndOffset().messageOffset());
        partition.appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 8L, this.createRecords$default$3()), false);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log end offset after append of 1 record at offset 8:"})).s((Seq)Nil$.MODULE$), (long)9L, (long)replica.logEndOffset().messageOffset());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log start offset not expected to change:"})).s((Seq)Nil$.MODULE$), (long)newLogStartOffset, (long)replica.logStartOffset());
    }

    @Test
    public void testGetReplica() {
        LogManager qual$4 = this.logManager();
        TopicPartition x$38 = this.topicPartition();
        LogConfig x$39 = this.logConfig();
        boolean x$40 = qual$4.getOrCreateLog$default$3();
        boolean x$41 = qual$4.getOrCreateLog$default$4();
        Log log2 = qual$4.getOrCreateLog(x$38, x$39, x$40, x$41);
        int x$42 = this.brokerId();
        TopicPartition x$43 = this.topicPartition();
        MockTime x$44 = this.time();
        Some x$45 = new Some((Object)log2);
        long x$46 = Replica$.MODULE$.$lessinit$greater$default$4();
        Replica replica = new Replica(x$42, x$43, (Time)x$44, x$46, (Option)x$45);
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assert.assertEquals((Object)None$.MODULE$, (Object)partition.getReplica(this.brokerId()));
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$3;

            public final Replica apply() {
                return this.partition$3.getReplicaOrException(this.$outer.brokerId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$3 = partition$3;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        partition.addReplicaIfNotExists(replica);
        Assert.assertEquals((Object)replica, (Object)partition.getReplicaOrException(this.brokerId()));
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Partition partition = new Partition(this.topicPartition().topic(), this.topicPartition().partition(), (Time)this.time(), this.replicaManager(), Partition$.MODULE$.$lessinit$greater$default$5());
        Assertions$.MODULE$.assertThrows((Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PartitionTest $outer;
            private final Partition partition$4;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.partition$4.appendRecordsToFollowerOrFutureReplica(this.$outer.createRecords((Iterable<SimpleRecord>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes())})), 0L, this.$outer.createRecords$default$3()), false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$4 = partition$4;
            }
        }, ClassTag$.MODULE$.apply(ReplicaNotAvailableException.class), new Position("PartitionTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records2, long baseOffset, int partitionLeaderEpoch) {
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter(records2).asJava())));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records2.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;

            public final Long apply(SimpleRecord x$1) {
                return this.builder$1.append(x$1);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public PartitionTest() {
        this.brokerId = 101;
    }
}

