/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.network.SocketServer;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.Assert;
import org.junit.Test;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001\u001d\u00111#\u00123hK\u000e\u000b7/\u001a*fcV,7\u000f\u001e+fgRT!a\u0001\u0003\u0002\rM,'O^3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0007\u000e\u0003)Q!a\u0003\u0003\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u001b)\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\u0005\u0006\u001f\u0001!\t\u0001E\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0001\"A\u0005\u0001\u000e\u0003\tAQ\u0001\u0006\u0001\u0005\u0002U\tqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002-A\u0019qC\b\u0011\u000e\u0003aQ!!\u0007\u000e\u0002\u0013%lW.\u001e;bE2,'BA\u000e\u001d\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\u0007\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002\u0013C%\u0011!E\u0001\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0003%\u0001\u0011%Q%\u0001\u0007t_\u000e\\W\r^*feZ,'/F\u0001'!\t9#&D\u0001)\u0015\tIC!A\u0004oKR<xN]6\n\u0005-B#\u0001D*pG.,GoU3sm\u0016\u0014\b\"B\u0017\u0001\t\u0013q\u0013aB2p]:,7\r\u001e\u000b\u0004_]J\u0004C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\rqW\r\u001e\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014G\u0001\u0004T_\u000e\\W\r\u001e\u0005\bq1\u0002\n\u00111\u0001'\u0003\u0005\u0019\bb\u0002\u001e-!\u0003\u0005\raO\u0001\taJ|Go\\2pYB\u0011A\bS\u0007\u0002{)\u0011ahP\u0001\u0005CV$\bN\u0003\u0002A\u0003\u0006A1/Z2ve&$\u0018P\u0003\u0002C\u0007\u000611m\\7n_:T!!\u0002#\u000b\u0005\u00153\u0015AB1qC\u000eDWMC\u0001H\u0003\ry'oZ\u0005\u0003\u0013v\u0012\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\t\u000b-\u0003A\u0011\u0002'\u0002\u0017M,g\u000e\u001a*fcV,7\u000f\u001e\u000b\u0005\u001bF\u001b6\f\u0005\u0002O\u001f6\tA$\u0003\u0002Q9\t!QK\\5u\u0011\u0015\u0011&\n1\u00010\u0003\u0019\u0019xnY6fi\")AK\u0013a\u0001+\u00069!/Z9vKN$\bc\u0001(W1&\u0011q\u000b\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001dfK!A\u0017\u000f\u0003\t\tKH/\u001a\u0005\b9*\u0003\n\u00111\u0001^\u0003\tIG\rE\u0002O=\u0002L!a\u0018\u000f\u0003\r=\u0003H/[8o!\tq\u0015-\u0003\u0002c9\t)1\u000b[8si\")A\r\u0001C\u0005K\u0006y!/Z2fSZ,'+Z:q_:\u001cX\r\u0006\u0002VM\")!k\u0019a\u0001_!)\u0001\u000e\u0001C\u0005S\u0006\t\"/Z9vKN$\u0018I\u001c3SK\u000e,\u0017N^3\u0015\u0007US7\u000eC\u0003UO\u0002\u0007Q\u000bC\u0004]OB\u0005\t\u0019A/\t\u000b5\u0004A\u0011\u00028\u0002%I,\u0017/^3ti\"+\u0017\rZ3s\u0005f$Xm\u001d\u000b\u0006+>\f8\u000f \u0005\u0006a2\u0004\r\u0001Y\u0001\u0007CBL7*Z=\t\u000bId\u0007\u0019\u00011\u0002\u0015\u0005\u0004\u0018NV3sg&|g\u000eC\u0004uYB\u0005\t\u0019A;\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012\u0004\"A^=\u000f\u00059;\u0018B\u0001=\u001d\u0003\u0019\u0001&/\u001a3fM&\u0011!p\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005ad\u0002bB?m!\u0003\u0005\rA`\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\u0011\u00059{\u0018bAA\u00019\t\u0019\u0011J\u001c;\t\u000f\u0005\u0015\u0001\u0001\"\u0003\u0002\b\u0005\u0001b/\u001a:jMf$\u0015n]2p]:,7\r\u001e\u000b\u0004\u001b\u0006%\u0001B\u0002+\u0002\u0004\u0001\u0007Q\u000bC\u0004\u0002\u000e\u0001!\t!a\u0004\u0002EQ,7\u000f\u001e)s_\u0012,8-\u001a*fcV,7\u000f^,ji\"tU\u000f\u001c7DY&,g\u000e^%e)\u0005i\u0005\u0006BA\u0006\u0003'\u0001B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u000331\u0015!\u00026v]&$\u0018\u0002BA\u000f\u0003/\u0011A\u0001V3ti\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005=\u0011!\u0006;fgRDU-\u00193fe>sG.\u001f*fcV,7\u000f\u001e\u0015\u0005\u0003?\t\u0019\u0002C\u0004\u0002(\u0001!\t!a\u0004\u00021Q,7\u000f^%om\u0006d\u0017\u000eZ!qS.+\u0017PU3rk\u0016\u001cH\u000f\u000b\u0003\u0002&\u0005M\u0001bBA\u0017\u0001\u0011\u0005\u0011qB\u0001\u001di\u0016\u001cH/\u00138wC2LG-\u00119j-\u0016\u00148/[8o%\u0016\fX/Z:uQ\u0011\tY#a\u0005\t\u000f\u0005M\u0002\u0001\"\u0001\u0002\u0010\u0005QB/Z:u\u001b\u0006dgm\u001c:nK\u0012DU-\u00193feJ+\u0017/^3ti\"\"\u0011\u0011GA\n\u0011%\tI\u0004AI\u0001\n\u0013\tY$A\td_:tWm\u0019;%I\u00164\u0017-\u001e7uIE*\"!!\u0010+\u0007\u0019\nyd\u000b\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013!C;oG\",7m[3e\u0015\r\tY\u0005H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u000b\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\u0019\u0006AI\u0001\n\u0013\t)&A\td_:tWm\u0019;%I\u00164\u0017-\u001e7uII*\"!a\u0016+\u0007m\ny\u0004C\u0005\u0002\\\u0001\t\n\u0011\"\u0003\u0002^\u0005)2/\u001a8e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u001aTCAA0U\ri\u0016q\b\u0005\n\u0003G\u0002\u0011\u0013!C\u0005\u0003;\n1D]3rk\u0016\u001cH/\u00118e%\u0016\u001cW-\u001b<fI\u0011,g-Y;mi\u0012\u0012\u0004\"CA4\u0001E\u0005I\u0011BA5\u0003q\u0011X-];fgRDU-\u00193fe\nKH/Z:%I\u00164\u0017-\u001e7uIM*\"!a\u001b+\u0007U\fy\u0004C\u0005\u0002p\u0001\t\n\u0011\"\u0003\u0002r\u0005a\"/Z9vKN$\b*Z1eKJ\u0014\u0015\u0010^3tI\u0011,g-Y;mi\u0012\"TCAA:U\rq\u0018q\b")
public class EdgeCaseRequestTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.setProperty(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{KafkaConfig$.MODULE$.fromProps(props)}));
    }

    private SocketServer socketServer() {
        return ((KafkaServer)this.servers().head()).socketServer();
    }

    private Socket connect(SocketServer s, SecurityProtocol protocol) {
        return new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
    }

    private SocketServer connect$default$1() {
        return this.socketServer();
    }

    private SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    private void sendRequest(Socket socket, byte[] request, Option<Object> id) {
        Option<Object> option;
        block4: {
            DataOutputStream outgoing;
            block3: {
                block2: {
                    outgoing = new DataOutputStream(socket.getOutputStream());
                    option = id;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    short id2 = BoxesRunTime.unboxToShort((Object)some.x());
                    outgoing.writeInt(request.length + 2);
                    outgoing.writeShort(id2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                outgoing.writeInt(request.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            outgoing.write(request);
            outgoing.flush();
            return;
        }
        throw new MatchError(option);
    }

    private Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    private byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] requestAndReceive(byte[] request, Option<Object> id) {
        byte[] byArray;
        Socket plainSocket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendRequest(plainSocket, request, id);
            byArray = this.receiveResponse(plainSocket);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        plainSocket.close();
        return byArray;
    }

    private Option<Object> requestAndReceive$default$2() {
        return None$.MODULE$;
    }

    private byte[] requestHeaderBytes(short apiKey, short apiVersion, String clientId, int correlationId) {
        int size2 = 8 + Type.NULLABLE_STRING.sizeOf((Object)clientId);
        ByteBuffer buffer = ByteBuffer.allocate(size2);
        buffer.putShort(apiKey);
        buffer.putShort(apiVersion);
        buffer.putInt(correlationId);
        Type.NULLABLE_STRING.write(buffer, (Object)clientId);
        return buffer.array();
    }

    private String requestHeaderBytes$default$3() {
        return "";
    }

    private int requestHeaderBytes$default$4() {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private void verifyDisconnect(byte[] request) {
        Socket plainSocket = this.connect(this.connect$default$1(), this.connect$default$2());
        try {
            this.sendRequest(plainSocket, this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()), this.sendRequest$default$3());
            Assert.assertEquals((String)"The server should disconnect", (long)-1L, (long)plainSocket.getInputStream().read());
        }
        catch (Throwable throwable) {
            void var2_2;
            var2_2.close();
            throw throwable;
        }
        plainSocket.close();
    }

    @Test
    public void testProduceRequestWithNullClientId() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int correlationId = -1;
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        short version = ApiKeys.PRODUCE.latestVersion();
        byte[] headerBytes = this.requestHeaderBytes(ApiKeys.PRODUCE.id, version, null, correlationId);
        MemoryRecords records2 = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("message".getBytes())});
        ProduceRequest request = (ProduceRequest)ProduceRequest.Builder.forCurrentMagic((short)1, (int)10000, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records2)}))).asJava())).build();
        ByteBuffer byteBuffer = ByteBuffer.allocate(headerBytes.length + request.toStruct().sizeOf());
        byteBuffer.put(headerBytes);
        request.toStruct().writeTo(byteBuffer);
        byte[] serializedBytes = byteBuffer.array();
        byte[] response = this.requestAndReceive(serializedBytes, this.requestAndReceive$default$2());
        ByteBuffer responseBuffer = ByteBuffer.wrap(response);
        ResponseHeader responseHeader = ResponseHeader.parse((ByteBuffer)responseBuffer);
        ProduceResponse produceResponse = ProduceResponse.parse((ByteBuffer)responseBuffer, (short)version);
        Assert.assertEquals((String)"The response should parse completely", (long)0L, (long)responseBuffer.remaining());
        Assert.assertEquals((String)"The correlationId should match request", (long)correlationId, (long)responseHeader.correlationId());
        Assert.assertEquals((String)"One partition response should be returned", (long)1L, (long)produceResponse.responses().size());
        ProduceResponse.PartitionResponse partitionResponse = (ProduceResponse.PartitionResponse)produceResponse.responses().get(topicPartition);
        Assert.assertNotNull((Object)partitionResponse);
        Assert.assertEquals((String)"There should be no error", (Object)Errors.NONE, (Object)partitionResponse.error);
    }

    @Test
    public void testHeaderOnlyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiKeyRequest() {
        this.verifyDisconnect(this.requestHeaderBytes((short)-1, (short)0, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testInvalidApiVersionRequest() {
        this.verifyDisconnect(this.requestHeaderBytes(ApiKeys.PRODUCE.id, (short)-1, this.requestHeaderBytes$default$3(), this.requestHeaderBytes$default$4()));
    }

    @Test
    public void testMalformedHeaderRequest() {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putShort(ApiKeys.PRODUCE.id);
        buffer.putShort((short)1);
        byte[] serializedBytes = buffer.array();
        this.verifyDisconnect(serializedBytes);
    }
}

