/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tmh\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"I1\u0005\u0001B\u0001B\u0003%AEK\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\tqa\u00197vgR,'/\u0003\u0002*M\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018BA\u0012\u000b\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0005/\u0013\ty#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002\ng%\u0011AG\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!1\u0004A!A!\u0002\u00139\u0014aB7fiJL7m\u001d\t\u0003q\u0005k\u0011!\u000f\u0006\u0003miR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t)QH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\":\u0005\u001diU\r\u001e:jGND\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0005i&lW\r\u0005\u0002G\u00116\tqI\u0003\u0002\u001du%\u0011\u0011j\u0012\u0002\u0005)&lW\r\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0003\u0015\tXo\u001c;b!\tIQ*\u0003\u0002O\u0005\ta!+\u001a9mS\u000e\f\u0017+^8uC\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\u000emK\u0006$WM]#oIB|\u0017N\u001c;CY>\u001c7.\u001b8h'\u0016tG\rE\u0002\u0011%RK!aU\t\u0003\r=\u0003H/[8o!\tIQ+\u0003\u0002W\u0005\ta!\t\\8dW&twmU3oI\")\u0001\f\u0001C\u00013\u00061A(\u001b8jiz\"\"BW.];z{\u0006-\u00192d!\tI\u0001\u0001C\u0003\u000e/\u0002\u0007a\u0002C\u0003\u001f/\u0002\u0007q\u0004C\u0003$/\u0002\u0007A\u0005C\u0003-/\u0002\u0007Q\u0006C\u00032/\u0002\u0007!\u0007C\u00037/\u0002\u0007q\u0007C\u0003E/\u0002\u0007Q\tC\u0003L/\u0002\u0007A\nC\u0004Q/B\u0005\t\u0019A)\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006I!/\u001a9mS\u000e\f\u0017\nZ\u000b\u0002?!1\u0001\u000e\u0001Q\u0001\n}\t!B]3qY&\u001c\u0017-\u00133!\u0011\u001dQ\u0007A1A\u0005\n-\f!\u0002\\8h\u0007>tG/\u001a=u+\u0005a\u0007C\u0001$n\u0013\tqwI\u0001\u0006M_\u001e\u001cuN\u001c;fqRDa\u0001\u001d\u0001!\u0002\u0013a\u0017a\u00037pO\u000e{g\u000e^3yi\u0002BqA\u001d\u0001C\u0002\u0013%1/\u0001\bmK\u0006$WM]#oIB|\u0017N\u001c;\u0016\u0003QCa!\u001e\u0001!\u0002\u0013!\u0016a\u00047fC\u0012,'/\u00128ea>Lg\u000e\u001e\u0011\t\u0011]\u0004!\u0019!C\u0001\u0005a\f1CZ3uG\"\u0014V-];fgR4VM]:j_:,\u0012!\u001f\t\u0003!iL!a_\t\u0003\u000bMCwN\u001d;\t\ru\u0004\u0001\u0015!\u0003z\u0003Q1W\r^2i%\u0016\fX/Z:u-\u0016\u00148/[8oA!Aq\u0010\u0001b\u0001\n\u0003\u0011\u00010\u0001\u0012pM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f\u001e,feNLwN\u001c\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003z\u0003\rzgMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3tiZ+'o]5p]\u0002B\u0011\"a\u0002\u0001\u0005\u0004%\tA\u0001=\u000211L7\u000f^(gMN,GOU3rk\u0016\u001cHOV3sg&|g\u000eC\u0004\u0002\f\u0001\u0001\u000b\u0011B=\u000231L7\u000f^(gMN,GOU3rk\u0016\u001cHOV3sg&|g\u000e\t\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#\tq!\\1y/\u0006LG/\u0006\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u00027b]\u001eT!!!\b\u0002\t)\fg/Y\u0005\u0005\u0003C\t9BA\u0004J]R,w-\u001a:\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003'\t\u0001\"\\1y/\u0006LG\u000f\t\u0005\n\u0003S\u0001!\u0019!C\u0005\u0003#\t\u0001\"\\5o\u0005f$Xm\u001d\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u0014\u0005IQ.\u001b8CsR,7\u000f\t\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003#\t\u0001\"\\1y\u0005f$Xm\u001d\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u0014\u0005IQ.\u0019=CsR,7\u000f\t\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003#\t\u0011BZ3uG\"\u001c\u0016N_3\t\u0011\u0005u\u0002\u0001)A\u0005\u0003'\t!BZ3uG\"\u001c\u0016N_3!\u0011%\t\t\u0005\u0001b\u0001\n\u0013\t\u0019%\u0001\u0011ce>\\WM]*vaB|'\u000f^:MK\u0006$WM]#q_\u000eD'+Z9vKN$XCAA#!\r\u0001\u0012qI\u0005\u0004\u0003\u0013\n\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0003\u0002F\u0005\t#M]8lKJ\u001cV\u000f\u001d9peR\u001cH*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:uA!I\u0011\u0011\u000b\u0001C\u0002\u0013%\u00111K\u0001\u0014M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003+\u0002B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037b\u0014aB2mS\u0016tGo]\u0005\u0005\u0003?\nIFA\nGKR\u001c\u0007nU3tg&|g\u000eS1oI2,'\u000f\u0003\u0005\u0002d\u0001\u0001\u000b\u0011BA+\u0003Q1W\r^2i'\u0016\u001c8/[8o\u0011\u0006tG\r\\3sA!9\u0011q\r\u0001\u0005R\u0005%\u0014a\u00037bi\u0016\u001cH/\u00129pG\"$B!a\u001b\u0002nA\u0019\u0001CU\u0010\t\u0011\u0005=\u0014Q\ra\u0001\u0003c\na\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002t\u0005UT\"\u0001\u001e\n\u0007\u0005]$H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005m\u0004\u0001\"\u0015\u0002~\u0005aAn\\4F]\u0012|eMZ:fiR!\u0011qPAC!\r\u0001\u0012\u0011Q\u0005\u0004\u0003\u0007\u000b\"\u0001\u0002'p]\u001eD\u0001\"a\u001c\u0002z\u0001\u0007\u0011\u0011\u000f\u0005\b\u0003\u0013\u0003A\u0011KAF\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0007\u0003\u001b\u000b)*a&\u0011\tA\u0011\u0016q\u0012\t\u0004\u0013\u0005E\u0015bAAJ\u0005\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007\u0002CA8\u0003\u000f\u0003\r!!\u001d\t\u000f\u0005e\u0015q\u0011a\u0001?\u0005)Q\r]8dQ\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0015\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\t)\u0005C\u0004\u0002$\u0002!\t%!*\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o)\t\t9\u000bE\u0002\u0011\u0003SK1!a+\u0012\u0005\u0011)f.\u001b;\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\u0006!\u0002O]8dKN\u001c\b+\u0019:uSRLwN\u001c#bi\u0006$\u0002\"a-\u0002B\u0006\r\u0017q\u0019\t\u0005!I\u000b)\f\u0005\u0003\u00028\u0006uVBAA]\u0015\r\tY\fB\u0001\u0004Y><\u0017\u0002BA`\u0003s\u0013Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007\u0002CA8\u0003[\u0003\r!!\u001d\t\u0011\u0005\u0015\u0017Q\u0016a\u0001\u0003\u007f\n1BZ3uG\"|eMZ:fi\"A\u0011\u0011ZAW\u0001\u0004\tY-A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003\u001b\fy-D\u0001\u0001\u0013\r\t\tN\u0003\u0002\n\r\u0016$8\r\u001b#bi\u0006Dq!!6\u0001\t\u0003\t9.A\u000enCf\u0014WmV1s]&3wJ^3sg&TX\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003O\u000bI.!;\t\u0011\u0005m\u00171\u001ba\u0001\u0003;\fqA]3d_J$7\u000f\u0005\u0003\u0002`\u0006\u0015XBAAq\u0015\r\t\u0019OO\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\u0005=\u00141\u001ba\u0001\u0003cBq!!<\u0001\t#\ny/A\bgKR\u001c\u0007N\u0012:p[2+\u0017\rZ3s)\u0011\t\tPa\u0004\u0011\r\u0005M(1\u0001B\u0005\u001d\u0011\t)0a@\u000f\t\u0005]\u0018Q`\u0007\u0003\u0003sT1!a?\u0007\u0003\u0019a$o\\8u}%\t!#C\u0002\u0003\u0002E\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\u0006\t\u001d!aA*fc*\u0019!\u0011A\t\u0011\u000fA\u0011Y!!\u001d\u0002L&\u0019!QB\t\u0003\rQ+\b\u000f\\33\u0011!\u0011\t\"a;A\u0002\tM\u0011\u0001\u00044fi\u000eD'+Z9vKN$\b\u0003\u0002B\u000b\u0005CqAAa\u0006\u0003\u001e5\u0011!\u0011\u0004\u0006\u0004\u00057Q\u0014\u0001\u0003:fcV,7\u000f^:\n\t\t}!\u0011D\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0005G\u0011)CA\u0004Ck&dG-\u001a:\u000b\t\t}!\u0011\u0004\u0005\b\u0005S\u0001A\u0011\u000bB\u0016\u0003u1W\r^2i\u000b\u0006\u0014H.[3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBA@\u0005[\u0011y\u0003\u0003\u0005\u0002p\t\u001d\u0002\u0019AA9\u0011\u001d\u0011\tDa\nA\u0002}\t!cY;se\u0016tG\u000fT3bI\u0016\u0014X\t]8dQ\"9!Q\u0007\u0001\u0005R\t]\u0012a\u00074fi\u000eDG*\u0019;fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u0002\u0000\te\"1\b\u0005\t\u0003_\u0012\u0019\u00041\u0001\u0002r!9!\u0011\u0007B\u001a\u0001\u0004y\u0002b\u0002B \u0001\u0011%!\u0011I\u0001\u0016M\u0016$8\r[(gMN,GO\u0012:p[2+\u0017\rZ3s)!\tyHa\u0011\u0003F\t\u001d\u0003\u0002CA8\u0005{\u0001\r!!\u001d\t\u000f\tE\"Q\ba\u0001?!A!\u0011\nB\u001f\u0001\u0004\ty(\u0001\tfCJd\u0017.Z:u\u001fJd\u0015\r^3ti\"9!Q\n\u0001\u0005B\t=\u0013A\u00032vS2$g)\u001a;dQR!!\u0011\u000bB5!\u0019\u0011\u0019F!\u0019\u0003h9!!Q\u000bB/\u001d\u0011\u00119Fa\u0017\u000f\t\u0005](\u0011L\u0005\u0002\u000b%\u00111\u0001B\u0005\u0004\u0005?\u0012\u0011!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0005\u0005G\u0012)G\u0001\u000bSKN,H\u000e^,ji\"\u0004\u0016M\u001d;ji&|gn\u001d\u0006\u0004\u0005?\u0012\u0001\u0003\u0002\tS\u0005'A\u0001Ba\u001b\u0003L\u0001\u0007!QN\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\t\u0005_\u0012)(!\u001d\u0003z5\u0011!\u0011\u000f\u0006\u0004\u0005g\n\u0012AC2pY2,7\r^5p]&!!q\u000fB9\u0005\ri\u0015\r\u001d\t\u0004\u0013\tm\u0014b\u0001B?\u0005\t\u0019\u0002+\u0019:uSRLwN\u001c$fi\u000eD7\u000b^1uK\"9!\u0011\u0011\u0001\u0005B\t\r\u0015\u0001\u0003;sk:\u001c\u0017\r^3\u0015\r\u0005\u001d&Q\u0011BE\u0011!\u00119Ia A\u0002\u0005E\u0014A\u0001;q\u0011!\u0011YIa A\u0002\t5\u0015!F8gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/\u001a\t\u0004\u0013\t=\u0015b\u0001BI\u0005\t)rJ\u001a4tKR$&/\u001e8dCRLwN\\*uCR,\u0007b\u0002BK\u0001\u0011E#qS\u0001\u0018iJ,hnY1uK\u001a+H\u000e\\=B]\u0012\u001cF/\u0019:u\u0003R$b!a*\u0003\u001a\nm\u0005\u0002CA8\u0005'\u0003\r!!\u001d\t\u0011\tu%1\u0013a\u0001\u0003\u007f\naa\u001c4gg\u0016$\bb\u0002BQ\u0001\u0011\u0005#1U\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\t\u0015&Q\u0016\t\t\u0005_\u0012)(!\u001d\u0003(B!!q\u0003BU\u0013\u0011\u0011YK!\u0007\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"A!q\u0016BP\u0001\u0004\u0011\t,\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004\u0002Ba\u001c\u0003v\u0005E$1\u0017\t\u0005\u0003\u001b\u0014),C\u0002\u00038*\u0011\u0011\"\u00129pG\"$\u0015\r^1\t\u000f\tm\u0006\u0001\"\u0011\u0002D\u0005y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\t\u000f\t}\u0006\u0001\"\u0003\u0003B\u000612\u000f[8vY\u00124u\u000e\u001c7po\u0016\u0014H\u000b\u001b:piRdW\r\u0006\u0004\u0002F\t\r'Q\u0019\u0005\u0007\u0017\nu\u0006\u0019\u0001'\t\u0011\u0005=$Q\u0018a\u0001\u0003cBQB!3\u0001!\u0003\r\t\u0011!C\u0005\u0005\u0017T\u0013AE:va\u0016\u0014He]8ve\u000e,'I]8lKJ,\u0012\u0001J\u0004\n\u0005\u001f\u0014\u0011\u0011!E\u0001\u0005#\fACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$\u0007cA\u0005\u0003T\u001aA\u0011AAA\u0001\u0012\u0003\u0011)n\u0005\u0003\u0003T\n]\u0007c\u0001\t\u0003Z&\u0019!1\\\t\u0003\r\u0005s\u0017PU3g\u0011\u001dA&1\u001bC\u0001\u0005?$\"A!5\t\u0015\t\r(1[I\u0001\n\u0003\u0011)/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%O\u000b\u0003\u0005OT3!\u0015BuW\t\u0011Y\u000f\u0005\u0003\u0003n\n]XB\u0001Bx\u0015\u0011\u0011\tPa=\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B{#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\te(q\u001e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final int kafka$server$ReplicaFetcherThread$$fetcherId;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    public final ReplicaManager kafka$server$ReplicaFetcherThread$$replicaMgr;
    public final Metrics kafka$server$ReplicaFetcherThread$$metrics;
    public final Time kafka$server$ReplicaFetcherThread$$time;
    public final ReplicaQuota kafka$server$ReplicaFetcherThread$$quota;
    private final int kafka$server$ReplicaFetcherThread$$replicaId;
    private final LogContext kafka$server$ReplicaFetcherThread$$logContext;
    private final BlockingSend kafka$server$ReplicaFetcherThread$$leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    public /* synthetic */ BrokerEndPoint kafka$server$ReplicaFetcherThread$$super$sourceBroker() {
        return super.sourceBroker();
    }

    public int kafka$server$ReplicaFetcherThread$$replicaId() {
        return this.kafka$server$ReplicaFetcherThread$$replicaId;
    }

    public LogContext kafka$server$ReplicaFetcherThread$$logContext() {
        return this.kafka$server$ReplicaFetcherThread$$logContext;
    }

    public BlockingSend kafka$server$ReplicaFetcherThread$$leaderEndpoint() {
        return this.kafka$server$ReplicaFetcherThread$$leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().initiateClose();
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcherThread $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to initiate shutdown of leader endpoint ", " after initiating replica fetcher thread shutdown"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicaFetcherThread$$leaderEndpoint()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                });
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().close();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close leader endpoint ", " after shutting down replica fetcher thread"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicaFetcherThread$$leaderEndpoint()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$2;

                public final Throwable apply() {
                    return this.t$2;
                }
                {
                    this.t$2 = t$2;
                }
            });
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition);
        Partition partition = (Partition)this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)replica.logEndOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, partitionData, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final FetchResponse.PartitionData partitionData$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.partitionData$1.highWatermark)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.partitionData$1 = partitionData$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            });
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$1.logEndOffset()), BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            });
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset()), partitionData.highWatermark);
        long leaderLogStartOffset = partitionData.logStartOffset;
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, followerHighWatermark){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final long followerHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower set replica high watermark for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.followerHighWatermark$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.followerHighWatermark$1 = followerHighWatermark$1;
                }
            });
        }
        if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicPartition)) {
            this.kafka$server$ReplicaFetcherThread$$quota.record(records.sizeInBytes());
        }
        this.kafka$server$ReplicaFetcherThread$$replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            });
        }
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        try {
            ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            return this.fetchSessionHandler().handleResponse(fetchResponse) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq() : Nil$.MODULE$;
        }
        catch (Throwable throwable) {
            this.fetchSessionHandler().handleError(throwable);
            throw throwable;
        }
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)requestPartitionData)}));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (Errors.NONE.equals(errors)) {
            long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
            return l;
        }
        throw errors.exception();
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1)new Serializable(this, partitionsWithError, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final scala.collection.mutable.Set partitionsWithError$1;
            private final FetchSessionHandler.Builder builder$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$1) {
                BoxedUnit boxedUnit;
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState2 = (PartitionFetchState)tuple2._2();
                if (fetchState2.isReadyForFetch() && !this.$outer.kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(this.$outer.kafka$server$ReplicaFetcherThread$$quota, topicPartition)) {
                    try {
                        long logStartOffset2 = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(topicPartition).logStartOffset();
                        this.builder$1.add(topicPartition, new FetchRequest.PartitionData(fetchState2.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState2.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                    }
                    return boxedUnit;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsWithError$1 = partitionsWithError$1;
                this.builder$1 = builder$1;
            }
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)requestBuilder);
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.localReplicaOrException(tp);
        Partition partition = (Partition)this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(tp).get();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < replica.highWatermark().messageOffset()) {
            this.warn((Function0<String>)new Serializable(this, tp, offsetTruncationState, replica){
                public static final long serialVersionUID = 0L;
                private final TopicPartition tp$1;
                private final OffsetTruncationState offsetTruncationState$1;
                private final Replica replica$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncating ", " to offset ", " below high watermark "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.offsetTruncationState$1.offset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replica$2.highWatermark().messageOffset())}))).toString();
                }
                {
                    this.tp$1 = tp$1;
                    this.offsetTruncationState$1 = offsetTruncationState$1;
                    this.replica$2 = replica$2;
                }
            });
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.kafka$server$ReplicaFetcherThread$$replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset2) {
        Partition partition = (Partition)this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(topicPartition).get();
        partition.truncateFullyAndStartAt(offset2, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        Map map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Skipping leaderEpoch request since all partitions do not have an epoch";
                }
            });
            return Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(this.offsetForLeaderEpochRequestVersion(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        this.debug((Function0<String>)new Serializable(this, epochRequest){
            public static final long serialVersionUID = 0L;
            private final OffsetsForLeaderEpochRequest.Builder epochRequest$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending offset for leader epoch request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochRequest$1}));
            }
            {
                this.epochRequest$1 = epochRequest$1;
            }
        });
        try {
            ClientResponse response = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)new Serializable(this, response){
                public static final long serialVersionUID = 0L;
                private final ClientResponse response$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received leaderEpoch response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1}));
                }
                {
                    this.response$1 = response$1;
                }
            });
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Map partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1}));
                }
                {
                    this.partitions$1 = partitions$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$3;

                public final Throwable apply() {
                    return this.t$3;
                }
                {
                    this.t$3 = t$3;
                }
            });
            Errors error = Errors.forException((Throwable)throwable);
            map = (Map)partitions.map((Function1)new Serializable(this, error){
                public static final long serialVersionUID = 0L;
                private final Errors error$1;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> x0$2) {
                    Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(this.error$1, -1, -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.error$1 = error$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    public boolean kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition);
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig2, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.kafka$server$ReplicaFetcherThread$$fetcherId = fetcherId;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig2;
        this.kafka$server$ReplicaFetcherThread$$replicaMgr = replicaMgr;
        this.kafka$server$ReplicaFetcherThread$$metrics = metrics;
        this.kafka$server$ReplicaFetcherThread$$time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig2.replicaFetchBackoffMs()), false);
        this.kafka$server$ReplicaFetcherThread$$replicaId = brokerConfig2.brokerId();
        this.kafka$server$ReplicaFetcherThread$$logContext = new LogContext(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaFetcher replicaId=", ", leaderId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)super.sourceBroker().id())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId)}))).toString());
        this.logIdent_$eq(this.kafka$server$ReplicaFetcherThread$$logContext().logPrefix());
        this.kafka$server$ReplicaFetcherThread$$leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final ReplicaFetcherBlockingSend apply() {
                return new ReplicaFetcherBlockingSend(this.$outer.kafka$server$ReplicaFetcherThread$$super$sourceBroker(), this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig, this.$outer.kafka$server$ReplicaFetcherThread$$metrics, this.$outer.kafka$server$ReplicaFetcherThread$$time, this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId)})), this.$outer.kafka$server$ReplicaFetcherThread$$logContext());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.fetchRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0));
        this.listOffsetRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig2.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig2.replicaFetchMinBytes();
        this.maxBytes = brokerConfig2.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig2.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.kafka$server$ReplicaFetcherThread$$logContext(), super.sourceBroker().id());
    }
}

