/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.controller.KafkaController;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.server.TopicConfigHandler$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003V8qS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119\u0011\u0002CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ti1i\u001c8gS\u001eD\u0015M\u001c3mKJ\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\t3\u0001\u0011)\u0019!C\u00055\u0005QAn\\4NC:\fw-\u001a:\u0016\u0003m\u0001\"\u0001H\u0010\u000e\u0003uQ!A\b\u0003\u0002\u00071|w-\u0003\u0002!;\tQAj\\4NC:\fw-\u001a:\t\u0011\t\u0002!\u0011!Q\u0001\nm\t1\u0002\\8h\u001b\u0006t\u0017mZ3sA!AA\u0005\u0001B\u0001B\u0003%Q%A\u0006lC\u001a\\\u0017mQ8oM&<\u0007CA\b'\u0013\t9#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\rE,x\u000e^1t+\u0005Y\u0003C\u0001\u00177\u001d\tiCG\u0004\u0002/g9\u0011qFM\u0007\u0002a)\u0011\u0011GB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0005U\u0012\u0011\u0001D)v_R\fg)Y2u_JL\u0018BA\u001c9\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011QG\u0001\u0005\tu\u0001\u0011\t\u0011)A\u0005W\u00059\u0011/^8uCN\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001f-\fgm[1D_:$(o\u001c7mKJ\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002C\u007f\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'\u000fC\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\u0006\r\u001eC\u0015J\u0013\t\u0003\u001f\u0001AQ!G\"A\u0002mAQ\u0001J\"A\u0002\u0015BQ!K\"A\u0002-BQ\u0001P\"A\u0002uBQ\u0001\u0014\u0001\u0005\u00025\u000bA\u0003\u001d:pG\u0016\u001c8oQ8oM&<7\t[1oO\u0016\u001cHc\u0001(R5B\u0011\u0011bT\u0005\u0003!*\u0011A!\u00168ji\")!k\u0013a\u0001'\u0006)Ao\u001c9jGB\u0011Ak\u0016\b\u0003\u0013UK!A\u0016\u0006\u0002\rA\u0013X\rZ3g\u0013\tA\u0016L\u0001\u0004TiJLgn\u001a\u0006\u0003-*AQaW&A\u0002q\u000b1\u0002^8qS\u000e\u001cuN\u001c4jOB\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0005kRLGNC\u0001b\u0003\u0011Q\u0017M^1\n\u0005\rt&A\u0003)s_B,'\u000f^5fg\")Q\r\u0001C\u0001M\u0006A\u0002/\u0019:tKRC'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:\u0015\t\u001d\u001cHO\u001e\t\u0004Q6\u0004hBA5l\u001d\ty#.C\u0001\f\u0013\ta'\"A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011AN\u0003\t\u0003\u0013EL!A\u001d\u0006\u0003\u0007%sG\u000fC\u0003\\I\u0002\u0007A\fC\u0003vI\u0002\u0007\u0001/\u0001\u0005ce>\\WM]%e\u0011\u00159H\r1\u0001T\u0003\u0011\u0001(o\u001c9\t\u000be\u0004A\u0011\u0001>\u0002\u001f\u0015D8\r\\;eK\u0012\u001cuN\u001c4jON$2a\u001f@\u0000!\r!FpU\u0005\u0003{f\u00131aU3u\u0011\u0015\u0011\u0006\u00101\u0001T\u0011\u0015Y\u0006\u00101\u0001]\u0001")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    public final KafkaConfig kafka$server$TopicConfigHandler$$kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final KafkaController kafkaController;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        scala.collection.immutable.Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        Buffer logs = this.logManager().logsByTopic(topic).toBuffer();
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach((Function1)new Serializable(this, configNamesToExclude, props){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Set configNamesToExclude$1;
                private final Properties props$1;

                public final Object apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        BoxedUnit boxedUnit = this.configNamesToExclude$1.contains((Object)key) ? BoxedUnit.UNIT : this.props$1.put(key, value2);
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.configNamesToExclude$1 = configNamesToExclude$1;
                    this.props$1 = props$1;
                }
            });
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            logs.foreach((Function1)new Serializable(this, topicConfig, logConfig){
                public static final long serialVersionUID = 0L;
                private final Properties topicConfig$1;
                private final LogConfig logConfig$1;

                public final void apply(Log x$1) {
                    x$1.updateConfig((Set<String>)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.topicConfig$1).asScala()).keySet(), this.logConfig$1);
                }
                {
                    this.topicConfig$1 = topicConfig$1;
                    this.logConfig$1 = logConfig$1;
                }
            });
        }
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topic, topicConfig);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topic, topicConfig);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, topicConfig){
            public static final long serialVersionUID = 0L;
            private final Properties topicConfig$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.topicConfig$1.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()))).toBoolean();
            }
            {
                this.topicConfig$1 = topicConfig$1;
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }))) {
            this.kafkaController.enableTopicUncleanLeaderElection(topic);
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        String string = configValue;
        Seq seq = "".equals(string) ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : ("*".equals(string) ? Constants$.MODULE$.AllReplicas() : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$2) {
                return x$2.split(":");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).filter((Function1)new Serializable(this, brokerId){
            public static final long serialVersionUID = 0L;
            private final int brokerId$1;

            public final boolean apply(String[] x$3) {
                return new StringOps(Predef$.MODULE$.augmentString(x$3[1])).toInt() == this.brokerId$1;
            }
            {
                this.brokerId$1 = brokerId$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(String[] x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4[0])).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq());
        return seq;
    }

    public scala.collection.immutable.Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicConfigHandler $outer;
            public final String topic$2;

            public final Option<String> apply(String versionString) {
                None$ none$;
                if (this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply(versionString))) {
                    this.$outer.warn((Function0<String>)new Serializable(this, versionString){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$excludedConfigs$1 $outer;
                        private final String versionString$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log configuration ", " is ignored for `", "` because `", "` "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), this.$outer.topic$2, this.versionString$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not compatible with Kafka inter-broker protocol version `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$TopicConfigHandler$$anonfun$$$outer().kafka$server$TopicConfigHandler$$kafkaConfig.interBrokerProtocolVersionString()}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.versionString$1 = versionString$1;
                        }
                    });
                    none$ = new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }

            public /* synthetic */ TopicConfigHandler kafka$server$TopicConfigHandler$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
            }
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, String topic$1, Properties topicConfig$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)new Serializable(this, topic$1, prop, partitions){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicConfigHandler $outer;
                private final String topic$1;
                private final String prop$1;
                private final Seq partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", " on broker ", " for topic: ", " and partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prop$1, BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId()), this.topic$1, this.partitions$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                    this.prop$1 = prop$1;
                    this.partitions$1 = partitions$1;
                }
            });
        } else {
            quotaManager.removeThrottle(topic$1);
            this.debug((Function0<String>)new Serializable(this, topic$1, prop){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicConfigHandler $outer;
                private final String topic$1;
                private final String prop$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " from broker ", " for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.prop$1, BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$TopicConfigHandler$$kafkaConfig.brokerId()), this.topic$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topic$1 = topic$1;
                    this.prop$1 = prop$1;
                }
            });
        }
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, KafkaController kafkaController) {
        this.logManager = logManager;
        this.kafka$server$TopicConfigHandler$$kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging$class.$init$(this);
    }
}

