/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.nio.ByteBuffer;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.coordinator.group.GroupMetadataManager$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.serializer.Decoder;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.CommandDefaultOptions$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.VerifiableProperties;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5r!B\u0001\u0003\u0011\u00039\u0011a\u0004#v[BdunZ*fO6,g\u000e^:\u000b\u0005\r!\u0011!\u0002;p_2\u001c(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\tyA)^7q\u0019><7+Z4nK:$8o\u0005\u0002\n\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aDQaE\u0005\u0005\u0002Q\ta\u0001P5oSRtD#A\u0004\t\u0011YI!\u0019!C\u0001\u0005]\tABU3d_J$\u0017J\u001c3f]R,\u0012\u0001\u0007\t\u00033yi\u0011A\u0007\u0006\u00037q\tA\u0001\\1oO*\tQ$\u0001\u0003kCZ\f\u0017BA\u0010\u001b\u0005\u0019\u0019FO]5oO\"1\u0011%\u0003Q\u0001\na\tQBU3d_J$\u0017J\u001c3f]R\u0004\u0003\"B\u0012\n\t\u0003!\u0013\u0001B7bS:$\"!\n\u0015\u0011\u000551\u0013BA\u0014\u000f\u0005\u0011)f.\u001b;\t\u000b%\u0012\u0003\u0019\u0001\u0016\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b-j\u0013B\u0001\u0017\u000f\u0005\u0015\t%O]1z!\tq\u0013G\u0004\u0002\u000e_%\u0011\u0001GD\u0001\u0007!J,G-\u001a4\n\u0005}\u0011$B\u0001\u0019\u000f\u0011\u0015!\u0014\u0002\"\u00036\u00031!W/\u001c9Uq:Le\u000eZ3y)\t)c\u0007C\u00038g\u0001\u0007\u0001(\u0001\u0003gS2,\u0007CA\u001d=\u001b\u0005Q$BA\u001e\u001d\u0003\tIw.\u0003\u0002>u\t!a)\u001b7f\u0011\u0015y\u0014\u0002\"\u0003A\u0003Y!W/\u001c9Qe>$WoY3s\u0013\u0012\u001cf.\u00199tQ>$HCA\u0013B\u0011\u00159d\b1\u00019\u0011\u0019\u0019\u0015\u0002\"\u0001\u0003\t\u0006IA-^7q\u0013:$W\r\u001f\u000b\u0007K\u001535*T5\t\u000b]\u0012\u0005\u0019\u0001\u001d\t\u000b\u001d\u0013\u0005\u0019\u0001%\u0002\u001f%tG-\u001a=TC:LG/_(oYf\u0004\"!D%\n\u0005)s!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0019\n\u0003\r\u0001S\u0001\u000bm\u0016\u0014\u0018NZ=P]2L\b\"\u0002(C\u0001\u0004y\u0015AG7jg6\u000bGo\u00195fg\u001a{'/\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b\u0003\u0002)V[]k\u0011!\u0015\u0006\u0003%N\u000bq!\\;uC\ndWM\u0003\u0002U\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u000b&aA'baB\u0019\u0001\fY2\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002`\u001d\u00059\u0001/Y2lC\u001e,\u0017BA1c\u0005\u0011a\u0015n\u001d;\u000b\u0005}s\u0001\u0003B\u0007eM\u001aL!!\u001a\b\u0003\rQ+\b\u000f\\33!\tiq-\u0003\u0002i\u001d\t!Aj\u001c8h\u0011\u0015Q'\t1\u0001l\u00039i\u0017\r_'fgN\fw-Z*ju\u0016\u0004\"!\u00047\n\u00055t!aA%oi\"1q.\u0003C\u0001\u0005A\fQ\u0002Z;naRKW.Z%oI\u0016DHcB\u0013reN$\u0018\u0011\u000b\u0005\u0006o9\u0004\r\u0001\u000f\u0005\u0006\u000f:\u0004\r\u0001\u0013\u0005\u0006\u0019:\u0004\r\u0001\u0013\u0005\u0006k:\u0004\rA^\u0001\u0014i&lW-\u00138eKb$U/\u001c9FeJ|'o\u001d\t\u0003obl\u0011!\u0003\u0004\u0005s&\u0001!PA\nUS6,\u0017J\u001c3fq\u0012+X\u000e]#se>\u00148o\u0005\u0002y\u0019!)1\u0003\u001fC\u0001yR\ta\u000fC\u0004\u007fq\n\u0007I\u0011A@\u0002=5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004XCAA\u0001!\u0015\u0001V+LA\u0002!\u0011\u0001\u0016QA2\n\u0007\u0005\u001d\u0011KA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0002CA\u0006q\u0002\u0006I!!\u0001\u0002?5L7/T1uG\",7OR8s)&lW-\u00138eKb4\u0015\u000e\\3t\u001b\u0006\u0004\b\u0005\u0003\u0005\u0002\u0010a\u0014\r\u0011\"\u0001\u0000\u0003MyW\u000f^(g\u001fJ$WM\u001d+j[\u0016\u001cH/Y7q\u0011!\t\u0019\u0002\u001fQ\u0001\n\u0005\u0005\u0011\u0001F8vi>3wJ\u001d3feRKW.Z:uC6\u0004\b\u0005\u0003\u0005\u0002\u0018a\u0014\r\u0011\"\u0001\u0000\u0003U\u0019\b.\u00197m_^|eMZ:fi:{GOR8v]\u0012D\u0001\"a\u0007yA\u0003%\u0011\u0011A\u0001\u0017g\"\fG\u000e\\8x\u001f\u001a47/\u001a;O_R4u.\u001e8eA!9\u0011q\u0004=\u0005\u0002\u0005\u0005\u0012a\u0006:fG>\u0014H-T5t[\u0006$8\r\u001b+j[\u0016Le\u000eZ3y)\u001d)\u00131EA\u0013\u0003SAaaNA\u000f\u0001\u0004A\u0004bBA\u0014\u0003;\u0001\rAZ\u0001\u000fS:$W\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\tY#!\bA\u0002\u0019\fA\u0002\\8h)&lWm\u001d;b[BDq!a\fy\t\u0003\t\t$\u0001\u0010sK\u000e|'\u000fZ(vi>3wJ\u001d3fe&sG-\u001a=US6,7\u000f^1naR9Q%a\r\u00026\u0005]\u0002BB\u001c\u0002.\u0001\u0007\u0001\bC\u0004\u0002(\u00055\u0002\u0019\u00014\t\u000f\u0005e\u0012Q\u0006a\u0001M\u0006\u0011\u0002O]3w\u0013:$W\r\u001f+j[\u0016\u001cH/Y7q\u0011\u001d\ti\u0004\u001fC\u0001\u0003\u007f\t1D]3d_J$7\u000b[1mY><xJ\u001a4tKRtu\u000e\u001e$pk:$GcB\u0013\u0002B\u0005\r\u0013q\t\u0005\u0007o\u0005m\u0002\u0019\u0001\u001d\t\u000f\u0005\u0015\u00131\ba\u0001M\u0006Y\u0011N\u001c3fq>3gm]3u\u0011\u001d\tI%a\u000fA\u0002\u0019\f\u0011\u0002\\8h\u001f\u001a47/\u001a;\t\u000f\u00055\u0003\u0010\"\u0001\u0002P\u0005Y\u0001O]5oi\u0016\u0013(o\u001c:t)\u0005)\u0003\"\u00026o\u0001\u0004YgACA+\u0013A\u0005\u0019\u0013\u0001\u0003\u0002X\tiQ*Z:tC\u001e,\u0007+\u0019:tKJ,b!!\u0017\u0002n\u0005\r5cAA*\u0019!A\u0011QLA*\r\u0003\ty&A\u0003qCJ\u001cX\r\u0006\u0003\u0002b\u0005\u001d\u0005CB\u0007e\u0003G\ny\bE\u0003\u000e\u0003K\nI'C\u0002\u0002h9\u0011aa\u00149uS>t\u0007\u0003BA6\u0003[b\u0001\u0001\u0002\u0005\u0002p\u0005M#\u0019AA9\u0005\u0005Y\u0015\u0003BA:\u0003s\u00022!DA;\u0013\r\t9H\u0004\u0002\b\u001d>$\b.\u001b8h!\ri\u00111P\u0005\u0004\u0003{r!aA!osB)Q\"!\u001a\u0002\u0002B!\u00111NAB\t!\t))a\u0015C\u0002\u0005E$!\u0001,\t\u0011\u0005%\u00151\fa\u0001\u0003\u0017\u000baA]3d_J$\u0007\u0003BAG\u0003?k!!a$\u000b\t\u0005%\u0015\u0011\u0013\u0006\u0005\u0003'\u000b)*\u0001\u0004d_6lwN\u001c\u0006\u0004\u000b\u0005]%\u0002BAM\u00037\u000ba!\u00199bG\",'BAAO\u0003\ry'oZ\u0005\u0005\u0003C\u000byI\u0001\u0004SK\u000e|'\u000f\u001a\u0004\u0007\u0003KKA!a*\u0003)\u0011+7m\u001c3fe6+7o]1hKB\u000b'o]3s+\u0019\tI+a,\u00024N)\u00111\u0015\u0007\u0002,B9q/a\u0015\u0002.\u0006E\u0006\u0003BA6\u0003_#\u0001\"a\u001c\u0002$\n\u0007\u0011\u0011\u000f\t\u0005\u0003W\n\u0019\f\u0002\u0005\u0002\u0006\u0006\r&\u0019AA9\u0011-\t9,a)\u0003\u0002\u0003\u0006I!!/\u0002\u0015-,\u0017\u0010R3d_\u0012,'\u000f\u0005\u0004\u0002<\u0006\u0005\u0017QV\u0007\u0003\u0003{S1!a0\u0005\u0003)\u0019XM]5bY&TXM]\u0005\u0005\u0003\u0007\fiLA\u0004EK\u000e|G-\u001a:\t\u0017\u0005\u001d\u00171\u0015B\u0001B\u0003%\u0011\u0011Z\u0001\rm\u0006dW/\u001a#fG>$WM\u001d\t\u0007\u0003w\u000b\t-!-\t\u000fM\t\u0019\u000b\"\u0001\u0002NR1\u0011qZAi\u0003'\u0004ra^AR\u0003[\u000b\t\f\u0003\u0005\u00028\u0006-\u0007\u0019AA]\u0011!\t9-a3A\u0002\u0005%\u0007\u0002CA/\u0003G#\t%a6\u0015\t\u0005e\u0017q\u001c\t\u0007\u001b\u0011\fY.!8\u0011\u000b5\t)'!,\u0011\u000b5\t)'!-\t\u0011\u0005%\u0015Q\u001ba\u0001\u0003\u0017Cq!a9\n\t\u0013\t)/A\u0004ek6\u0004Hj\\4\u0015\u001b\u0015\n9/!;\u0002n\u0006E\u0018Q_A|\u0011\u00199\u0014\u0011\u001da\u0001q!9\u00111^Aq\u0001\u0004A\u0015!\u00049sS:$8i\u001c8uK:$8\u000fC\u0004\u0002p\u0006\u0005\b\u0019A(\u0002C9|gnQ8og\u0016\u001cW\u000f^5wKB\u000b\u0017N]:G_Jdun\u001a$jY\u0016\u001cX*\u00199\t\u000f\u0005M\u0018\u0011\u001da\u0001\u0011\u0006y\u0011n\u001d#fKBLE/\u001a:bi&|g\u000e\u0003\u0004k\u0003C\u0004\ra\u001b\u0005\t\u0003s\f\t\u000f1\u0001\u0002|\u00061\u0001/\u0019:tKJ\u0004d!!@\u0003\u0002\t\u001d\u0001cB<\u0002T\u0005}(Q\u0001\t\u0005\u0003W\u0012\t\u0001\u0002\u0007\u0003\u0004\u0005]\u0018\u0011!A\u0001\u0006\u0003\t\tHA\u0002`IE\u0002B!a\u001b\u0003\b\u0011a!\u0011BA|\u0003\u0003\u0005\tQ!\u0001\u0002r\t\u0019q\f\n\u001a\t\u000f\t5\u0011\u0002\"\u0003\u0003\u0010\u0005y\u0001O]5oi\n\u000bGo\u00195MKZ,G\u000eF\u0003&\u0005#\u0011\u0019\u0003\u0003\u0005\u0003\u0014\t-\u0001\u0019\u0001B\u000b\u0003\u0015\u0011\u0017\r^2i!\u0011\u00119B!\b\u000f\t\u00055%\u0011D\u0005\u0005\u00057\ty)\u0001\nGS2,Gj\\4J]B,Ho\u0015;sK\u0006l\u0017\u0002\u0002B\u0010\u0005C\u0011aCR5mK\u000eC\u0017M\u001c8fYJ+7m\u001c:e\u0005\u0006$8\r\u001b\u0006\u0005\u00057\ty\tC\u0004\u0003&\t-\u0001\u0019\u00014\u0002#\u0005\u001c7-^7vY\u0006$\u0018N^3CsR,7O\u0002\u0004\u0003*%!!1\u0006\u0002\u0015\u001f\u001a47/\u001a;t\u001b\u0016\u001c8/Y4f!\u0006\u00148/\u001a:\u0014\u000b\t\u001dBB!\f\u0011\u000b]\f\u0019&L\u0017\t\u000fM\u00119\u0003\"\u0001\u00032Q\u0011!1\u0007\t\u0004o\n\u001d\u0002\u0002CA/\u0005O!\tEa\u000e\u0015\t\te\"Q\b\t\u0007\u001b\u0011\u0014YDa\u000f\u0011\t5\t)'\f\u0005\t\u0003\u0013\u0013)\u00041\u0001\u0002\f\u001a1!\u0011I\u0005\u0005\u0005\u0007\u00121\u0004\u0016:b]N\f7\r^5p]2{w-T3tg\u0006<W\rU1sg\u0016\u00148#\u0002B \u0019\t5\u0002bB\n\u0003@\u0011\u0005!q\t\u000b\u0003\u0005\u0013\u00022a\u001eB \u0011!\tiFa\u0010\u0005B\t5C\u0003\u0002B\u001d\u0005\u001fB\u0001\"!#\u0003L\u0001\u0007\u00111\u0012\u0004\u0007\u0005'JAA!\u0016\u0003-\u0011+X\u000e\u001d'pON+w-\\3oiN|\u0005\u000f^5p]N\u001cBA!\u0015\u0003XA!!\u0011\fB0\u001b\t\u0011YFC\u0002\u0003^\u0011\tQ!\u001e;jYNLAA!\u0019\u0003\\\t)2i\\7nC:$G)\u001a4bk2$x\n\u001d;j_:\u001c\bbC\u0015\u0003R\t\u0005\t\u0015!\u0003+\u0005KJ1!\u000bB0\u0011\u001d\u0019\"\u0011\u000bC\u0001\u0005S\"BAa\u001b\u0003nA\u0019qO!\u0015\t\r%\u00129\u00071\u0001+\u0011)\u0011\tH!\u0015C\u0002\u0013\u0005!1O\u0001\taJLg\u000e^(qiV\u0011!Q\u000f\t\u0005\u0005o\u0012i(\u0004\u0002\u0003z)\u0011!1P\u0001\u000bU>\u0004Ho]5na2,\u0017\u0002\u0002B@\u0005s\u0012\u0011c\u00149uS>t7\u000b]3d\u0005VLG\u000eZ3s\u0011%\u0011\u0019I!\u0015!\u0002\u0013\u0011)(A\u0005qe&tGo\u00149uA!Q!q\u0011B)\u0005\u0004%\tAa\u001d\u0002\u0013Y,'/\u001b4z\u001fB$\b\"\u0003BF\u0005#\u0002\u000b\u0011\u0002B;\u0003)1XM]5gs>\u0003H\u000f\t\u0005\u000b\u0005\u001f\u0013\tF1A\u0005\u0002\tM\u0014AD5oI\u0016D8+\u00198jif|\u0005\u000f\u001e\u0005\n\u0005'\u0013\t\u0006)A\u0005\u0005k\nq\"\u001b8eKb\u001c\u0016M\\5us>\u0003H\u000f\t\u0005\u000b\u0005/\u0013\tF1A\u0005\u0002\te\u0015\u0001\u00034jY\u0016\u001cx\n\u001d;\u0016\u0005\tm\u0005#\u0002B<\u0005;k\u0013\u0002\u0002BP\u0005s\u00121$\u0011:hk6,g\u000e^!dG\u0016\u0004H/\u001b8h\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007\"\u0003BR\u0005#\u0002\u000b\u0011\u0002BN\u0003%1\u0017\u000e\\3t\u001fB$\b\u0005\u0003\u0006\u0003(\nE#\u0019!C\u0001\u0005S\u000b\u0011#\\1y\u001b\u0016\u001c8/Y4f'&TXm\u00149u+\t\u0011Y\u000b\u0005\u0004\u0003x\tu%Q\u0016\t\u00043\t=\u0016b\u0001BY5\t9\u0011J\u001c;fO\u0016\u0014\b\"\u0003B[\u0005#\u0002\u000b\u0011\u0002BV\u0003Ii\u0017\r_'fgN\fw-Z*ju\u0016|\u0005\u000f\u001e\u0011\t\u0015\te&\u0011\u000bb\u0001\n\u0003\u0011\u0019(\u0001\teK\u0016\u0004\u0018\n^3sCRLwN\\(qi\"I!Q\u0018B)A\u0003%!QO\u0001\u0012I\u0016,\u0007/\u0013;fe\u0006$\u0018n\u001c8PaR\u0004\u0003B\u0003Ba\u0005#\u0012\r\u0011\"\u0001\u0003D\u0006ya/\u00197vK\u0012+7m\u001c3fe>\u0003H/\u0006\u0002\u0003FB)!q\u000fBO1!I!\u0011\u001aB)A\u0003%!QY\u0001\u0011m\u0006dW/\u001a#fG>$WM](qi\u0002B!B!4\u0003R\t\u0007I\u0011\u0001Bb\u00035YW-\u001f#fG>$WM](qi\"I!\u0011\u001bB)A\u0003%!QY\u0001\u000fW\u0016LH)Z2pI\u0016\u0014x\n\u001d;!\u0011)\u0011)N!\u0015C\u0002\u0013\u0005!1O\u0001\u000b_\u001a47/\u001a;t\u001fB$\b\"\u0003Bm\u0005#\u0002\u000b\u0011\u0002B;\u0003-ygMZ:fiN|\u0005\u000f\u001e\u0011\t\u0015\tu'\u0011\u000bb\u0001\n\u0003\u0011\u0019(A\tue\u0006t7/Y2uS>tGj\\4PaRD\u0011B!9\u0003R\u0001\u0006IA!\u001e\u0002%Q\u0014\u0018M\\:bGRLwN\u001c'pO>\u0003H\u000f\t\u0005\t\u0005K\u0014\t\u0006\"\u0001\u0003h\u0006iQ.Z:tC\u001e,\u0007+\u0019:tKJ,\"A!;1\r\t-(q\u001eB{!\u001d9\u00181\u000bBw\u0005g\u0004B!a\u001b\u0003p\u0012a!\u0011\u001fBr\u0003\u0003\u0005\tQ!\u0001\u0002r\t\u0019q\fJ\u001a\u0011\t\u0005-$Q\u001f\u0003\r\u0005o\u0014\u0019/!A\u0001\u0002\u000b\u0005\u0011\u0011\u000f\u0002\u0004?\u0012\"\u0004b\u0003B~\u0005#B)\u0019!C\u0001\u0005{\f!c\u001d5pk2$\u0007K]5oi\u0012\u000bG/\u0019'pOV\t\u0001\n\u0003\u0006\u0004\u0002\tE\u0003\u0012!Q!\n!\u000b1c\u001d5pk2$\u0007K]5oi\u0012\u000bG/\u0019'pO\u0002B1\"a=\u0003R!\u0015\r\u0011\"\u0001\u0003~\"Q1q\u0001B)\u0011\u0003\u0005\u000b\u0015\u0002%\u0002!%\u001cH)Z3q\u0013R,'/\u0019;j_:\u0004\u0003B\u0003'\u0003R!\u0015\r\u0011\"\u0001\u0003~\"Q1Q\u0002B)\u0011\u0003\u0005\u000b\u0015\u0002%\u0002\u0017Y,'/\u001b4z\u001f:d\u0017\u0010\t\u0005\u000b\u000f\nE\u0003R1A\u0005\u0002\tu\bBCB\n\u0005#B\t\u0011)Q\u0005\u0011\u0006\u0001\u0012N\u001c3fqN\u000bg.\u001b;z\u001f:d\u0017\u0010\t\u0005\f\u0007/\u0011\t\u0006#b\u0001\n\u0003\u0019I\"A\u0003gS2,7/\u0006\u0002\u0004\u001cA\u0019Qb\u000b\r\t\u0017\r}!\u0011\u000bE\u0001B\u0003&11D\u0001\u0007M&dWm\u001d\u0011\t\u0015)\u0014\t\u0006#b\u0001\n\u0003\u0019\u0019#F\u0001l\u0011)\u00199C!\u0015\t\u0002\u0003\u0006Ka[\u0001\u0010[\u0006DX*Z:tC\u001e,7+\u001b>fA!A11\u0006B)\t\u0003\ty%A\u0005dQ\u0016\u001c7.\u0011:hg\u0002")
public final class DumpLogSegments {
    public static void main(String[] stringArray) {
        DumpLogSegments$.MODULE$.main(stringArray);
    }

    public static interface MessageParser<K, V> {
        public Tuple2<Option<K>, Option<V>> parse(Record var1);
    }

    public static class TimeIndexDumpErrors {
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        private final Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> misMatchesForTimeIndexFilesMap() {
            return this.misMatchesForTimeIndexFilesMap;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> outOfOrderTimestamp() {
            return this.outOfOrderTimestamp;
        }

        public Map<String, ArrayBuffer<Tuple2<Object, Object>>> shallowOffsetNotFound() {
            return this.shallowOffsetNotFound;
        }

        public void recordMismatchTimeIndex(File file, long indexTimestamp, long logTimestamp) {
            ArrayBuffer misMatchesSeq = (ArrayBuffer)this.misMatchesForTimeIndexFilesMap().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = misMatchesSeq.isEmpty() ? this.misMatchesForTimeIndexFilesMap().put((Object)file.getAbsolutePath(), (Object)misMatchesSeq) : BoxedUnit.UNIT;
            misMatchesSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, logTimestamp));
        }

        public void recordOutOfOrderIndexTimestamp(File file, long indexTimestamp, long prevIndexTimestamp) {
            ArrayBuffer outOfOrderSeq = (ArrayBuffer)this.outOfOrderTimestamp().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = outOfOrderSeq.isEmpty() ? this.outOfOrderTimestamp().put((Object)file.getAbsolutePath(), (Object)outOfOrderSeq) : BoxedUnit.UNIT;
            outOfOrderSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexTimestamp, prevIndexTimestamp));
        }

        public void recordShallowOffsetNotFound(File file, long indexOffset, long logOffset) {
            ArrayBuffer shallowOffsetNotFoundSeq = (ArrayBuffer)this.shallowOffsetNotFound().getOrElse((Object)file.getAbsolutePath(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayBuffer<Tuple2<Object, Object>> apply() {
                    return new ArrayBuffer();
                }
            });
            Object object = shallowOffsetNotFoundSeq.isEmpty() ? this.shallowOffsetNotFound().put((Object)file.getAbsolutePath(), (Object)shallowOffsetNotFoundSeq) : BoxedUnit.UNIT;
            shallowOffsetNotFoundSeq.$plus$eq((Object)new Tuple2.mcJJ.sp(indexOffset, logOffset));
        }

        public void printErrors() {
            this.misMatchesForTimeIndexFilesMap().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$5) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$5;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer listOfMismatches = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found timestamp mismatch in :").append((Object)fileName).toString());
                        listOfMismatches.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, log timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.outOfOrderTimestamp().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> x0$6) {
                    Tuple2<String, ArrayBuffer<Tuple2<Object, Object>>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        String fileName = (String)tuple2._1();
                        ArrayBuffer outOfOrderTimestamps = (ArrayBuffer)tuple2._2();
                        System.err.println(new StringBuilder().append((Object)"Found out of order timestamp in :").append((Object)fileName).toString());
                        outOfOrderTimestamps.foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> m) {
                                System.err.println(new StringOps(Predef$.MODULE$.augmentString("  Index timestamp: %d, Previously indexed timestamp: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m._1$mcJ$sp()), BoxesRunTime.boxToLong((long)m._2$mcJ$sp())})));
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            this.shallowOffsetNotFound().values().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ArrayBuffer<Tuple2<Object, Object>> listOfShallowOffsetNotFound) {
                    System.err.println("The following indexed offsets are not found in the log.");
                    listOfShallowOffsetNotFound.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Tuple2<Object, Object> x0$7) {
                            Tuple2<Object, Object> tuple2 = x0$7;
                            if (tuple2 != null) {
                                long indexedOffset = tuple2._1$mcJ$sp();
                                long logOffset = tuple2._2$mcJ$sp();
                                System.err.println(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexed offset: ", ", found log offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)indexedOffset), BoxesRunTime.boxToLong((long)logOffset)})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                }
            });
        }
    }

    public static class DecoderMessageParser<K, V>
    implements MessageParser<K, V> {
        private final Decoder<K> keyDecoder;
        private final Decoder<V> valueDecoder;

        @Override
        public Tuple2<Option<K>, Option<V>> parse(Record record2) {
            Tuple2 tuple2;
            None$ key;
            Object object = key = record2.hasKey() ? new Some(this.keyDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.key()))) : None$.MODULE$;
            if (record2.hasValue()) {
                Some payload = new Some(this.valueDecoder.fromBytes(Utils.readBytes((ByteBuffer)record2.value())));
                tuple2 = new Tuple2((Object)key, (Object)payload);
            } else {
                tuple2 = new Tuple2((Object)key, (Object)None$.MODULE$);
            }
            return tuple2;
        }

        public DecoderMessageParser(Decoder<K> keyDecoder, Decoder<V> valueDecoder) {
            this.keyDecoder = keyDecoder;
            this.valueDecoder = valueDecoder;
        }
    }

    public static class OffsetsMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            return GroupMetadataManager$.MODULE$.formatRecordKeyAndValue(record2);
        }
    }

    public static class DumpLogSegmentsOptions
    extends CommandDefaultOptions {
        private final OptionSpecBuilder printOpt = this.parser().accepts("print-data-log", "if set, printing the messages content when dumping data logs. Automatically set if any decoder option is specified.");
        private final OptionSpecBuilder verifyOpt = this.parser().accepts("verify-index-only", "if set, just verify the index log without printing its content.");
        private final OptionSpecBuilder indexSanityOpt = this.parser().accepts("index-sanity-check", "if set, just checks the index sanity without printing its content. This is the same check that is executed on broker startup to determine if an index needs rebuilding or not.");
        private final ArgumentAcceptingOptionSpec<String> filesOpt = this.parser().accepts("files", "REQUIRED: The comma separated list of data and index log files to be dumped.").withRequiredArg().describedAs("file1, file2, ...").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt = this.parser().accepts("max-message-size", "Size of largest message.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x500000), (Object[])new Integer[0]);
        private final OptionSpecBuilder deepIterationOpt = this.parser().accepts("deep-iteration", "if set, uses deep instead of shallow iteration. Automatically set if print-data-log is enabled.");
        private final ArgumentAcceptingOptionSpec<String> valueDecoderOpt = this.parser().accepts("value-decoder-class", "if set, used to deserialize the messages. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final ArgumentAcceptingOptionSpec<String> keyDecoderOpt = this.parser().accepts("key-decoder-class", "if set, used to deserialize the keys. This class should implement kafka.serializer.Decoder trait. Custom jar should be available in kafka/libs directory.").withOptionalArg().ofType(String.class).defaultsTo((Object)"kafka.serializer.StringDecoder", (Object[])new String[0]);
        private final OptionSpecBuilder offsetsOpt = this.parser().accepts("offsets-decoder", "if set, log data will be parsed as offset data from the __consumer_offsets topic.");
        private final OptionSpecBuilder transactionLogOpt = this.parser().accepts("transaction-log-decoder", "if set, log data will be parsed as transaction metadata from the __transaction_state topic.");
        private boolean shouldPrintDataLog;
        private boolean isDeepIteration;
        private boolean verifyOnly;
        private boolean indexSanityOnly;
        private String[] files;
        private int maxMessageSize;
        private volatile byte bitmap$0;

        private boolean shouldPrintDataLog$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.shouldPrintDataLog = this.options().has((OptionSpec)this.printOpt()) || this.options().has((OptionSpec)this.offsetsOpt()) || this.options().has((OptionSpec)this.transactionLogOpt()) || this.options().has(this.valueDecoderOpt()) || this.options().has(this.keyDecoderOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.shouldPrintDataLog;
            }
        }

        private boolean isDeepIteration$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.isDeepIteration = this.options().has((OptionSpec)this.deepIterationOpt()) || this.shouldPrintDataLog();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.isDeepIteration;
            }
        }

        private boolean verifyOnly$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 4) == 0) {
                    this.verifyOnly = this.options().has((OptionSpec)this.verifyOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 4);
                }
                return this.verifyOnly;
            }
        }

        private boolean indexSanityOnly$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 8) == 0) {
                    this.indexSanityOnly = this.options().has((OptionSpec)this.indexSanityOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 8);
                }
                return this.indexSanityOnly;
            }
        }

        private String[] files$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 0x10) == 0) {
                    this.files = ((String)this.options().valueOf(this.filesOpt())).split(",");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
                }
                return this.files;
            }
        }

        private int maxMessageSize$lzycompute() {
            DumpLogSegmentsOptions dumpLogSegmentsOptions = this;
            synchronized (dumpLogSegmentsOptions) {
                if ((byte)(this.bitmap$0 & 0x20) == 0) {
                    this.maxMessageSize = (Integer)this.options().valueOf(this.maxMessageSizeOpt());
                    this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
                }
                return this.maxMessageSize;
            }
        }

        public OptionSpecBuilder printOpt() {
            return this.printOpt;
        }

        public OptionSpecBuilder verifyOpt() {
            return this.verifyOpt;
        }

        public OptionSpecBuilder indexSanityOpt() {
            return this.indexSanityOpt;
        }

        public ArgumentAcceptingOptionSpec<String> filesOpt() {
            return this.filesOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> maxMessageSizeOpt() {
            return this.maxMessageSizeOpt;
        }

        public OptionSpecBuilder deepIterationOpt() {
            return this.deepIterationOpt;
        }

        public ArgumentAcceptingOptionSpec<String> valueDecoderOpt() {
            return this.valueDecoderOpt;
        }

        public ArgumentAcceptingOptionSpec<String> keyDecoderOpt() {
            return this.keyDecoderOpt;
        }

        public OptionSpecBuilder offsetsOpt() {
            return this.offsetsOpt;
        }

        public OptionSpecBuilder transactionLogOpt() {
            return this.transactionLogOpt;
        }

        public MessageParser<?, ?> messageParser() {
            MessageParser<String, String> messageParser;
            if (this.options().has((OptionSpec)this.offsetsOpt())) {
                messageParser = new OffsetsMessageParser();
            } else if (this.options().has((OptionSpec)this.transactionLogOpt())) {
                messageParser = new TransactionLogMessageParser();
            } else {
                Decoder valueDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.valueDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                Decoder keyDecoder = (Decoder)CoreUtils$.MODULE$.createObject((String)this.options().valueOf(this.keyDecoderOpt()), (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{new VerifiableProperties()}));
                messageParser = new DecoderMessageParser(keyDecoder, valueDecoder);
            }
            return messageParser;
        }

        public boolean shouldPrintDataLog() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.shouldPrintDataLog$lzycompute() : this.shouldPrintDataLog;
        }

        public boolean isDeepIteration() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.isDeepIteration$lzycompute() : this.isDeepIteration;
        }

        public boolean verifyOnly() {
            return (byte)(this.bitmap$0 & 4) == 0 ? this.verifyOnly$lzycompute() : this.verifyOnly;
        }

        public boolean indexSanityOnly() {
            return (byte)(this.bitmap$0 & 8) == 0 ? this.indexSanityOnly$lzycompute() : this.indexSanityOnly;
        }

        public String[] files() {
            return (byte)(this.bitmap$0 & 0x10) == 0 ? this.files$lzycompute() : this.files;
        }

        public int maxMessageSize() {
            return (byte)(this.bitmap$0 & 0x20) == 0 ? this.maxMessageSize$lzycompute() : this.maxMessageSize;
        }

        public void checkArgs() {
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.filesOpt()}));
        }

        public DumpLogSegmentsOptions(String[] args) {
            super(args, CommandDefaultOptions$.MODULE$.$lessinit$greater$default$2());
            this.options_$eq(this.parser().parse(super.args()));
        }
    }

    public static class TransactionLogMessageParser
    implements MessageParser<String, String> {
        @Override
        public Tuple2<Option<String>, Option<String>> parse(Record record2) {
            return TransactionLog$.MODULE$.formatRecordKeyAndValue(record2);
        }
    }
}

