/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.shaded.com.google.common.base.Throwables;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.client.shaded.com.google.common.collect.Lists;
import org.apache.kudu.client.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.client.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kudu.security.Token;

class SecurityContext {
    @GuardedBy(value="this")
    private Token.SignedTokenPB authnToken;
    private final DelegatedTrustManager trustManager = new DelegatedTrustManager();
    private final SSLContext sslContextWithCert;
    private final SSLContext sslContextTrustAny;
    @Nullable
    private final Subject subject;
    private List<ByteString> trustedCertDers = Collections.emptyList();

    public SecurityContext(Subject subject) {
        try {
            this.subject = subject;
            this.sslContextWithCert = SSLContext.getInstance("TLS");
            this.sslContextWithCert.init(null, new TrustManager[]{this.trustManager}, null);
            this.sslContextTrustAny = SSLContext.getInstance("TLS");
            this.sslContextTrustAny.init(null, new TrustManager[]{new TrustAnyCert()}, null);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public synchronized byte[] exportAuthenticationCredentials() {
        if (this.authnToken == null || !this.hasTrustedCerts()) {
            return null;
        }
        return Client.AuthenticationCredentialsPB.newBuilder().setAuthnToken(this.authnToken).addAllCaCertDers(this.trustedCertDers).build().toByteArray();
    }

    private static String getUserFromToken(Token.SignedTokenPB token) throws InvalidProtocolBufferException {
        Token.TokenPB pb = Token.TokenPB.parseFrom(token.getTokenData());
        return pb.getAuthn().getUsername();
    }

    private static void checkUserMatches(Token.SignedTokenPB oldToken, Token.SignedTokenPB newToken) throws InvalidProtocolBufferException {
        String newUser;
        String oldUser = SecurityContext.getUserFromToken(oldToken);
        if (!oldUser.equals(newUser = SecurityContext.getUserFromToken(newToken))) {
            throw new IllegalArgumentException(String.format("cannot import authentication data from a different user: old='%s', new='%s'", oldUser, newUser));
        }
    }

    public synchronized void importAuthenticationCredentials(byte[] authnData) {
        try {
            Client.AuthenticationCredentialsPB pb = Client.AuthenticationCredentialsPB.parseFrom(authnData);
            if (this.authnToken != null) {
                SecurityContext.checkUserMatches(this.authnToken, pb.getAuthnToken());
            }
            this.trustCertificates(pb.getCaCertDersList());
            this.authnToken = pb.getAuthnToken();
        }
        catch (CertificateException | InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public synchronized Token.SignedTokenPB getAuthenticationToken() {
        return this.authnToken;
    }

    public synchronized void setAuthenticationToken(Token.SignedTokenPB token) {
        this.authnToken = token;
    }

    public SSLEngine createSSLEngineTrustAll() {
        return this.sslContextTrustAny.createSSLEngine();
    }

    public SSLEngine createSSLEngine() {
        return this.sslContextWithCert.createSSLEngine();
    }

    public synchronized boolean hasTrustedCerts() {
        return !this.trustedCertDers.isEmpty();
    }

    private static X509TrustManager createTrustManagerForCerts(Iterable<ByteString> certDers) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certs = Lists.newArrayList();
        for (ByteString certDer : certDers) {
            certs.add((X509Certificate)certFactory.generateCertificate(certDer.newInput()));
        }
        try {
            KeyStore certKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            certKeyStore.load(null);
            int i = 0;
            for (X509Certificate cert : certs) {
                certKeyStore.setCertificateEntry(String.format("cert-%d", i++), cert);
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(certKeyStore);
            TrustManager[] managers = tmf.getTrustManagers();
            if (managers.length != 1) {
                throw new RuntimeException("TrustManagerFactory generated multiple TrustManagers");
            }
            return (X509TrustManager)managers[0];
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf(e, CertificateException.class);
            throw Throwables.propagate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trustCertificates(List<ByteString> certDers) throws CertificateException {
        X509TrustManager tm = SecurityContext.createTrustManagerForCerts(certDers);
        SecurityContext securityContext = this;
        synchronized (securityContext) {
            this.trustManager.delegate.set(tm);
            this.trustedCertDers = ImmutableList.copyOf(certDers);
        }
    }

    private static class DelegatedTrustManager
    implements X509TrustManager {
        AtomicReference<X509TrustManager> delegate = new AtomicReference();

        private DelegatedTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.get().checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.delegate.get().checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.delegate.get().getAcceptedIssuers();
        }
    }

    private static class TrustAnyCert
    implements X509TrustManager {
        private TrustAnyCert() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

