/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.exec.CommandLineFactory;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.exec.RawStreamPumper;
import org.apache.maven.shared.release.exec.TeeOutputStream;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;

public class ForkedMavenExecutor
extends AbstractLogEnabled
implements MavenExecutor {
    private CommandLineFactory commandLineFactory;

    public void executeGoals(File workingDirectory, String goals, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult relResult) throws MavenExecutorException {
        Commandline cl = this.commandLineFactory.createCommandLine("mvn");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        if (pomFileName != null) {
            cl.createArgument().setLine("-f " + pomFileName);
        }
        if (goals != null) {
            String[] tokens = StringUtils.split((String)goals, (String)", ");
            for (int i = 0; i < tokens.length; ++i) {
                cl.createArgument().setValue(tokens[i]);
            }
        }
        cl.createArgument().setValue("--no-plugin-updates");
        if (!interactive) {
            cl.createArgument().setValue("--batch-mode");
        }
        if (!StringUtils.isEmpty((String)additionalArguments)) {
            cl.createArgument().setLine(additionalArguments);
        }
        TeeOutputStream stdOut = new TeeOutputStream(System.out);
        TeeOutputStream stdErr = new TeeOutputStream(System.err);
        try {
            relResult.appendInfo("Executing: " + cl.toString());
            this.getLogger().info("Executing: " + cl.toString());
            int result = ForkedMavenExecutor.executeCommandLine(cl, System.in, stdOut, stdErr);
            if (result != 0) {
                throw new MavenExecutorException("Maven execution failed, exit code: '" + result + "'", result, stdOut.toString(), stdErr.toString());
            }
        }
        catch (CommandLineException e) {
            throw new MavenExecutorException("Can't run goal " + goals, stdOut.toString(), stdErr.toString(), (Exception)((Object)e));
        }
        finally {
            relResult.appendOutput(stdOut.toString());
        }
    }

    public void executeGoals(File workingDirectory, String goals, boolean interactive, String arguments, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, interactive, arguments, null, result);
    }

    public void setCommandLineFactory(CommandLineFactory commandLineFactory) {
        this.commandLineFactory = commandLineFactory;
    }

    public static int executeCommandLine(Commandline cl, InputStream systemIn, OutputStream systemOut, OutputStream systemErr) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        Process p = cl.execute();
        RawStreamPumper inputFeeder = null;
        if (systemIn != null) {
            inputFeeder = new RawStreamPumper(systemIn, p.getOutputStream(), true);
        }
        RawStreamPumper outputPumper = new RawStreamPumper(p.getInputStream(), systemOut);
        RawStreamPumper errorPumper = new RawStreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        try {
            int returnValue = p.waitFor();
            if (inputFeeder != null) {
                inputFeeder.setDone();
            }
            outputPumper.setDone();
            errorPumper.setDone();
            int n = returnValue;
            return n;
        }
        catch (InterruptedException ex) {
            throw new CommandLineException("Error while executing external command, process killed.", (Throwable)ex);
        }
        finally {
            try {
                errorPumper.closeInput();
            }
            catch (IOException e) {}
            try {
                outputPumper.closeInput();
            }
            catch (IOException e) {}
            if (inputFeeder != null) {
                try {
                    inputFeeder.closeOutput();
                }
                catch (IOException e) {}
            }
        }
    }
}

