/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractBackupPomsPhase;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.FileUtils;

public class CreateBackupPomsPhase
extends AbstractBackupPomsPhase {
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.clean(reactorProjects);
        Iterator projects = reactorProjects.iterator();
        while (projects.hasNext()) {
            MavenProject project = (MavenProject)projects.next();
            this.createPomBackup(project);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult clean(List reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        Iterator projects = reactorProjects.iterator();
        while (projects.hasNext()) {
            MavenProject project = (MavenProject)projects.next();
            this.deletePomBackup(project);
        }
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        return this.execute(releaseDescriptor, settings, reactorProjects);
    }

    private void createPomBackup(MavenProject project) throws ReleaseExecutionException {
        this.deletePomBackup(project);
        try {
            FileUtils.copyFile((File)ReleaseUtil.getStandardPom(project), (File)this.getPomBackup(project));
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error creating backup POM: " + e.getMessage(), e);
        }
    }
}

