/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.project.MavenProject;

public class ReleaseUtil {
    public static final String RELEASE_POMv4 = "release-pom.xml";
    private static final String POMv4 = "pom.xml";

    private ReleaseUtil() {
    }

    public static MavenProject getRootProject(List reactorProjects) {
        MavenProject project = (MavenProject)reactorProjects.get(0);
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject currentProject = (MavenProject)i.next();
            if (!currentProject.isExecutionRoot()) continue;
            project = currentProject;
            break;
        }
        return project;
    }

    public static File getStandardPom(MavenProject project) {
        File releasePom;
        File pom = project.getFile();
        if (pom.equals(releasePom = ReleaseUtil.getReleasePom(project))) {
            pom = new File(pom.getParent(), POMv4);
        }
        return pom;
    }

    public static File getReleasePom(MavenProject project) {
        return new File(project.getFile().getParent(), RELEASE_POMv4);
    }
}

