/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.route;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.binder.SQLStatementContextFactory;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.route.context.RouteContext;
import org.apache.shardingsphere.underlying.route.context.RouteResult;
import org.apache.shardingsphere.underlying.route.decorator.RouteDecorator;
import org.apache.shardingsphere.underlying.route.hook.SPIRoutingHook;

public final class DataNodeRouter {
    private final ShardingSphereMetaData metaData;
    private final ConfigurationProperties properties;
    private final SQLParserEngine parserEngine;
    private final Map<BaseRule, RouteDecorator> decorators = new LinkedHashMap<BaseRule, RouteDecorator>();
    private SPIRoutingHook routingHook = new SPIRoutingHook();

    public void registerDecorator(BaseRule rule, RouteDecorator decorator) {
        this.decorators.put(rule, decorator);
    }

    public RouteContext route(String sql, List<Object> parameters, boolean useCache) {
        this.routingHook.start(sql);
        try {
            RouteContext result = this.executeRoute(sql, parameters, useCache);
            this.routingHook.finishSuccess(result, this.metaData.getSchema());
            return result;
        }
        catch (Exception ex) {
            this.routingHook.finishFailure(ex);
            throw ex;
        }
    }

    private RouteContext executeRoute(String sql, List<Object> parameters, boolean useCache) {
        RouteContext result = this.createRouteContext(sql, parameters, useCache);
        for (Map.Entry<BaseRule, RouteDecorator> entry : this.decorators.entrySet()) {
            result = entry.getValue().decorate(result, this.metaData, entry.getKey(), this.properties);
        }
        return result;
    }

    private RouteContext createRouteContext(String sql, List<Object> parameters, boolean useCache) {
        SQLStatement sqlStatement = this.parserEngine.parse(sql, useCache);
        try {
            SQLStatementContext sqlStatementContext = SQLStatementContextFactory.newInstance((SchemaMetaData)this.metaData.getSchema(), (String)sql, parameters, (SQLStatement)sqlStatement);
            return new RouteContext(sqlStatementContext, parameters, new RouteResult());
        }
        catch (IndexOutOfBoundsException ex) {
            return new RouteContext((SQLStatementContext)new CommonSQLStatementContext(sqlStatement), parameters, new RouteResult());
        }
    }

    @Generated
    public DataNodeRouter(ShardingSphereMetaData metaData, ConfigurationProperties properties, SQLParserEngine parserEngine) {
        this.metaData = metaData;
        this.properties = properties;
        this.parserEngine = parserEngine;
    }
}

