/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.AnnotationProcessor;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.modeler.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationFilterConfig
implements FilterConfig,
Serializable {
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private static Log log = LogFactory.getLog(ApplicationFilterConfig.class);
    private Context context = null;
    private transient Filter filter = null;
    private FilterDef filterDef = null;
    protected static Properties restrictedFilters = null;
    private ObjectName oname;

    ApplicationFilterConfig(Context context, FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        if (restrictedFilters == null) {
            restrictedFilters = new Properties();
            try {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedFilters.properties");
                if (is != null) {
                    restrictedFilters.load(is);
                } else {
                    context.getLogger().error((Object)sm.getString("applicationFilterConfig.restrictedFiltersResources"));
                }
            }
            catch (IOException e) {
                context.getLogger().error((Object)sm.getString("applicationFilterConfig.restrictedServletsResources"), (Throwable)e);
            }
        }
        this.context = context;
        this.setFilterDef(filterDef);
    }

    public String getFilterName() {
        return this.filterDef.getFilterName();
    }

    public String getFilterClass() {
        return this.filterDef.getFilterClass();
    }

    public String getInitParameter(String name) {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return null;
        }
        return (String)map.get(name);
    }

    public Enumeration getInitParameterNames() {
        Map map = this.filterDef.getParameterMap();
        if (map == null) {
            return new Enumerator(new ArrayList());
        }
        return new Enumerator(map.keySet());
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ApplicationFilterConfig[");
        sb.append("name=");
        sb.append(this.filterDef.getFilterName());
        sb.append(", filterClass=");
        sb.append(this.filterDef.getFilterClass());
        sb.append("]");
        return sb.toString();
    }

    public Map<String, String> getFilterInitParameterMap() {
        return Collections.unmodifiableMap(this.filterDef.getParameterMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Filter getFilter() throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        if (this.filter != null) {
            return this.filter;
        }
        String filterClass = this.filterDef.getFilterClass();
        ClassLoader classLoader = null;
        classLoader = filterClass.startsWith("org.apache.catalina.") ? this.getClass().getClassLoader() : this.context.getLoader().getClassLoader();
        ClassLoader oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = classLoader.loadClass(filterClass);
        if (!this.isFilterAllowed(clazz)) {
            throw new SecurityException(sm.getString("applicationFilterConfig.privilegedFilter", filterClass));
        }
        this.filter = (Filter)clazz.newInstance();
        if (!this.context.getIgnoreAnnotations() && this.context instanceof StandardContext) {
            AnnotationProcessor processor = ((StandardContext)this.context).getAnnotationProcessor();
            processor.processAnnotations(this.filter);
            processor.postConstruct(this.filter);
        }
        if (this.context instanceof StandardContext && ((StandardContext)this.context).getSwallowOutput()) {
            try {
                SystemLogHandler.startCapture();
                this.filter.init((FilterConfig)this);
            }
            finally {
                String log = SystemLogHandler.stopCapture();
                if (log != null && log.length() > 0) {
                    this.getServletContext().log(log);
                }
            }
        } else {
            this.filter.init((FilterConfig)this);
        }
        this.registerJMX();
        return this.filter;
    }

    FilterDef getFilterDef() {
        return this.filterDef;
    }

    protected boolean isFilterAllowed(Class filterClass) {
        if (this.context.getPrivileged()) {
            return true;
        }
        for (Class clazz = filterClass; clazz != null && !clazz.getName().equals("javax.servlet.Filter"); clazz = clazz.getSuperclass()) {
            if (!"restricted".equals(restrictedFilters.getProperty(clazz.getName()))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        this.unregisterJMX();
        if (this.filter != null) {
            if (Globals.IS_SECURITY_ENABLED) {
                try {
                    SecurityUtil.doAsPrivilege("destroy", this.filter);
                }
                catch (Exception ex) {
                    this.context.getLogger().error((Object)"ApplicationFilterConfig.doAsPrivilege", (Throwable)ex);
                }
                finally {
                    SecurityUtil.remove(this.filter);
                }
            } else {
                this.filter.destroy();
            }
            if (!this.context.getIgnoreAnnotations()) {
                try {
                    ((StandardContext)this.context).getAnnotationProcessor().preDestroy(this.filter);
                }
                catch (Exception e) {
                    this.context.getLogger().error((Object)"ApplicationFilterConfig.preDestroy", (Throwable)e);
                }
            }
        }
        this.filter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFilterDef(FilterDef filterDef) throws ClassCastException, ClassNotFoundException, IllegalAccessException, InstantiationException, ServletException, InvocationTargetException, NamingException {
        this.filterDef = filterDef;
        if (filterDef == null) {
            if (this.filter != null) {
                if (Globals.IS_SECURITY_ENABLED) {
                    try {
                        SecurityUtil.doAsPrivilege("destroy", this.filter);
                    }
                    catch (Exception ex) {
                        this.context.getLogger().error((Object)"ApplicationFilterConfig.doAsPrivilege", (Throwable)ex);
                    }
                    finally {
                        SecurityUtil.remove(this.filter);
                    }
                } else {
                    this.filter.destroy();
                }
                if (!this.context.getIgnoreAnnotations()) {
                    try {
                        ((StandardContext)this.context).getAnnotationProcessor().preDestroy(this.filter);
                    }
                    catch (Exception e) {
                        this.context.getLogger().error((Object)"ApplicationFilterConfig.preDestroy", (Throwable)e);
                    }
                }
            }
            this.filter = null;
        } else {
            Filter filter = this.getFilter();
        }
    }

    private void registerJMX() {
        String parentName = this.context.getName();
        parentName = "".equals(parentName) ? "/" : parentName;
        String hostName = this.context.getParent().getName();
        hostName = hostName == null ? "DEFAULT" : hostName;
        String domain = this.context.getParent().getParent().getName();
        String webMod = "//" + hostName + parentName;
        String onameStr = null;
        if (this.context instanceof StandardContext) {
            StandardContext standardContext = (StandardContext)this.context;
            onameStr = domain + ":j2eeType=Filter,name=" + this.filterDef.getFilterName() + ",WebModule=" + webMod + ",J2EEApplication=" + standardContext.getJ2EEApplication() + ",J2EEServer=" + standardContext.getJ2EEServer();
        } else {
            onameStr = domain + ":j2eeType=Filter,name=" + this.filterDef.getFilterName() + ",WebModule=" + webMod;
        }
        try {
            this.oname = new ObjectName(onameStr);
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
        }
        catch (Exception ex) {
            log.info((Object)sm.getString("applicationFilterConfig.jmxRegisterFail", this.getFilterClass(), this.getFilterName()), (Throwable)ex);
        }
    }

    private void unregisterJMX() {
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("applicationFilterConfig.jmxUnregister", this.getFilterClass(), this.getFilterName()));
                }
            }
            catch (Exception ex) {
                log.error((Object)sm.getString("applicationFilterConfig.jmxUnregisterFail", this.getFilterClass(), this.getFilterName()), (Throwable)ex);
            }
        }
    }
}

