/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.elasticsearch;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apdplat.word.lucene.ChineseWordAnalyzer;
import org.apdplat.word.lucene.ChineseWordTokenizer;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseWordIndicesAnalysis
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChineseWordIndicesAnalysis.class);
    private Segmentation analyzerSegmentation = null;
    private Segmentation tokenizerSegmentation = null;

    @Inject
    public ChineseWordIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        super(settings);
        Map map;
        Object v;
        Object v2 = settings.getAsStructuredMap().get("index");
        if (v2 != null && v2 instanceof Map && (v = (map = (Map)v2).get("analysis")) != null && v instanceof Map) {
            Object v3;
            Object v4;
            Map map2;
            Map map3;
            Object v5;
            Map map4 = (Map)v;
            Object v6 = map4.get("analyzer");
            Object v7 = map4.get("tokenizer");
            if (v6 != null && v6 instanceof Map && (v5 = (map3 = (Map)v6).get("default")) != null && v5 instanceof Map) {
                map2 = (Map)v5;
                v4 = map2.get("type");
                v3 = map2.get("segAlgorithm");
                if (v3 != null && v4 != null && "word".equals(v4.toString())) {
                    LOGGER.info("analyzer\u4f7f\u7528\u6307\u5b9a\u5206\u8bcd\u7b97\u6cd5\uff1a" + v3.toString());
                    this.analyzerSegmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.valueOf(v3.toString()));
                }
            }
            if (v7 != null && v7 instanceof Map && (v5 = (map3 = (Map)v7).get("default")) != null && v5 instanceof Map) {
                map2 = (Map)v5;
                v4 = map2.get("type");
                v3 = map2.get("segAlgorithm");
                if (v3 != null && v4 != null && "word".equals(v4.toString())) {
                    LOGGER.info("tokenizer\u4f7f\u7528\u6307\u5b9a\u5206\u8bcd\u7b97\u6cd5\uff1a" + v3.toString());
                    this.tokenizerSegmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.valueOf(v3.toString()));
                }
            }
        }
        if (this.analyzerSegmentation == null) {
            LOGGER.info("\u6ca1\u6709\u4e3aword analyzer\u6307\u5b9asegAlgorithm\u53c2\u6570");
            LOGGER.info("analyzer\u4f7f\u7528\u9ed8\u8ba4\u5206\u8bcd\u7b97\u6cd5\uff1a" + (Object)((Object)SegmentationAlgorithm.BidirectionalMaximumMatching));
            this.analyzerSegmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching);
        }
        if (this.tokenizerSegmentation == null) {
            LOGGER.info("\u6ca1\u6709\u4e3aword tokenizer\u6307\u5b9asegAlgorithm\u53c2\u6570");
            LOGGER.info("tokenizer\u4f7f\u7528\u9ed8\u8ba4\u5206\u8bcd\u7b97\u6cd5\uff1a" + (Object)((Object)SegmentationAlgorithm.BidirectionalMaximumMatching));
            this.tokenizerSegmentation = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching);
        }
        indicesAnalysisService.analyzerProviderFactories().put("word", new PreBuiltAnalyzerProviderFactory("word", AnalyzerScope.GLOBAL, (Analyzer)new ChineseWordAnalyzer(this.analyzerSegmentation)));
        indicesAnalysisService.tokenizerFactories().put("word", new PreBuiltTokenizerFactoryFactory(new TokenizerFactory(){

            public String name() {
                return "word";
            }

            public Tokenizer create(Reader reader) {
                return new ChineseWordTokenizer(reader, ChineseWordIndicesAnalysis.this.tokenizerSegmentation);
            }
        }));
    }
}

