/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.combination;

import java.util.ArrayList;
import java.util.List;
import org.datayoo.moql.RecordSet;
import org.datayoo.moql.RecordSetDefinition;
import org.datayoo.moql.core.RecordSetImpl;
import org.datayoo.moql.core.combination.AbstractRecordSetCombination;
import org.datayoo.moql.core.combination.RecordComparator;
import org.datayoo.moql.core.combination.RecordTranslator;
import org.datayoo.moql.metadata.ColumnMetadata;
import org.datayoo.moql.metadata.ColumnsMetadata;

public class Union
extends AbstractRecordSetCombination {
    public Union(ColumnsMetadata columnsMetadata) {
        super(columnsMetadata);
    }

    @Override
    protected RecordSet combine(boolean all, RecordSet lRecordSet, RecordSet rRecordSet) {
        int[] mappingIndexes = this.getColumnsMapping(lRecordSet.getRecordSetDefinition().getColumns(), rRecordSet.getRecordSetDefinition().getColumns());
        int[] indexes = this.createSequenceIndexes(lRecordSet.getRecordSetDefinition().getColumns().size());
        RecordComparator comparator = new RecordComparator(indexes, mappingIndexes);
        RecordTranslator translator = new RecordTranslator(mappingIndexes);
        ArrayList<Object[]> result = new ArrayList<Object[]>(lRecordSet.getRecordsCount() + rRecordSet.getRecordsCount());
        result.addAll(lRecordSet.getRecords());
        if (!all) {
            for (Object[] record : rRecordSet.getRecords()) {
                if (this.existRecord(record, result, comparator)) continue;
                result.add(translator.translate(record));
            }
        } else {
            for (Object[] record : rRecordSet.getRecords()) {
                result.add(translator.translate(record));
            }
        }
        return new RecordSetImpl(lRecordSet.getRecordSetDefinition(), this.getStart(lRecordSet.getStart(), rRecordSet.getStart()), this.getEnd(lRecordSet.getEnd(), rRecordSet.getEnd()), result);
    }

    @Override
    protected RecordSet combine(boolean all, List<ColumnMetadata> columns, RecordSet lRecordSet, RecordSet rRecordSet) {
        int[] lMappingIndexes = this.getColumnsMapping(columns, lRecordSet.getRecordSetDefinition().getColumns());
        RecordTranslator lTranslator = new RecordTranslator(lMappingIndexes);
        int[] rMappingIndexes = this.getColumnsMapping(columns, rRecordSet.getRecordSetDefinition().getColumns());
        RecordTranslator rTranslator = new RecordTranslator(rMappingIndexes);
        RecordComparator comparator = new RecordComparator(lMappingIndexes, rMappingIndexes);
        ArrayList<Object[]> result = new ArrayList<Object[]>(lRecordSet.getRecordsCount() + rRecordSet.getRecordsCount());
        for (Object[] record : lRecordSet.getRecords()) {
            result.add(lTranslator.translate(record));
        }
        if (!all) {
            for (Object[] record : rRecordSet.getRecords()) {
                if (this.existRecord(record, result, comparator)) continue;
                result.add(rTranslator.translate(record));
            }
        } else {
            for (Object[] record : rRecordSet.getRecords()) {
                result.add(rTranslator.translate(record));
            }
        }
        RecordSetDefinition recordSetDefinition = this.createRecordSetDefinition();
        return new RecordSetImpl(recordSetDefinition, this.getStart(lRecordSet.getStart(), rRecordSet.getStart()), this.getEnd(lRecordSet.getEnd(), rRecordSet.getEnd()), result);
    }
}

