/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.core.table;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.MoqlRuntimeException;

public class ResultSetIterator
implements Iterator<Object> {
    protected ResultSet resultSet;

    public ResultSetIterator(ResultSet resultSet) {
        Validate.notNull((Object)resultSet, (String)"Parameter 'resultSet' is null!");
        this.resultSet = resultSet;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            throw new MoqlRuntimeException((Throwable)e);
        }
    }

    @Override
    public Object next() {
        HashMap<String, Object> record = new HashMap<String, Object>();
        try {
            ResultSetMetaData metadata = this.resultSet.getMetaData();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                record.put(metadata.getCatalogName(i), this.resultSet.getObject(i));
            }
            return record;
        }
        catch (SQLException e) {
            throw new MoqlRuntimeException((Throwable)e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("");
    }
}

