/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.bit;

import org.datayoo.moql.EntityMap;
import org.datayoo.moql.NumberConvertable;
import org.datayoo.moql.Operand;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.operand.expression.AbstractOperationExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.bit.BitwiseOperator;
import org.datayoo.moql.util.StringFormater;

public abstract class AbstractBitwiseExpression
extends AbstractOperationExpression {
    protected Object constantReturnValue;

    public AbstractBitwiseExpression(BitwiseOperator operator, Operand lOperand, Operand rOperand) {
        super(OperatorType.BINARY, operator, lOperand, rOperand);
        this.expressionType = ExpressionType.BITWISE;
        this.initializeBitwise();
    }

    protected void initializeBitwise() {
        Long lNumber = null;
        Long rNumber = null;
        if (this.lOperand.isConstantReturn()) {
            lNumber = this.getNumber(this.lOperand, null);
        }
        if (this.rOperand.isConstantReturn()) {
            rNumber = this.getNumber(this.rOperand, null);
        }
        if (lNumber != null && rNumber != null) {
            this.constantReturn = true;
            this.constantReturnValue = this.calc(lNumber, rNumber);
        }
    }

    protected Long getNumber(Operand operand, EntityMap entityMap) {
        Number num;
        Object obj = operand.operate(entityMap);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Long || obj instanceof Integer || obj instanceof Short || obj instanceof Byte) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof NumberConvertable && (num = ((NumberConvertable)obj).toNumber()) != null && (num instanceof Long || num instanceof Integer || num instanceof Short || num instanceof Byte)) {
            return num.longValue();
        }
        throw new IllegalArgumentException(StringFormater.format((String)"Operand '{}' is not a number!", (Object[])new Object[]{operand.toString()}));
    }

    @Override
    public Object operate(EntityMap entityMap) {
        if (this.constantReturn) {
            return this.constantReturnValue;
        }
        Long lNumber = this.getNumber(this.lOperand, entityMap);
        Long rNumber = this.getNumber(this.rOperand, entityMap);
        if (lNumber == null || rNumber == null) {
            return null;
        }
        return this.calc(lNumber, rNumber);
    }

    protected abstract Long calc(Long var1, Long var2);
}

