/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.expression.member;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.OperateException;
import org.datayoo.moql.operand.OperandContextArrayList;
import org.datayoo.moql.operand.OperandContextList;
import org.datayoo.moql.operand.expression.AbstractExpression;
import org.datayoo.moql.operand.expression.ExpressionType;
import org.datayoo.moql.operand.expression.member.MemberExpression;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.util.StringFormater;

public class MemberFunctionExpression
extends AbstractExpression
implements MemberExpression {
    protected Function function;
    protected Operand target;
    protected Class<?> clazz;
    protected Method method;
    protected Map<Class<?>, Method> methodCache = new HashMap();

    public MemberFunctionExpression(Operand target, Function function) {
        this.expressionType = ExpressionType.MEMBER;
        Validate.notNull((Object)target, (String)"Parameter 'target' is null!");
        Validate.notNull((Object)function, (String)"Parameter 'function' is null!");
        this.target = target;
        this.function = function;
        this.name = this.buildNameString();
    }

    protected String buildNameString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.target.toString());
        sbuf.append('.');
        sbuf.append(this.function.toString());
        return sbuf.toString();
    }

    @Override
    public Object operate(EntityMap entityMap) {
        Object o = this.target.operate(entityMap);
        if (o == null) {
            return null;
        }
        Object[] parameterObjects = this.getParameterObjects(entityMap);
        if (!(o instanceof OperandContextList)) {
            return this.operate(o, parameterObjects);
        }
        OperandContextList ctxList = (OperandContextList)o;
        OperandContextArrayList resultList = new OperandContextArrayList(ctxList.size());
        for (Object obj : ctxList) {
            Object ret = this.operate(obj, parameterObjects);
            resultList.add(ret);
        }
        return resultList;
    }

    protected Object operate(Object o, Object[] parameterObjects) {
        Method m = this.getMethod(o, parameterObjects);
        try {
            return m.invoke(o, parameterObjects);
        }
        catch (Exception e) {
            throw new OperateException(StringFormater.format((String)"Invoke method '{}' in class '{}' failed!", (Object[])new Object[]{this.function.getName(), o.getClass().getName()}), e);
        }
    }

    protected Method getMethod(Object targetObject, Object[] parameterObjects) {
        Class<?> objClazz = targetObject.getClass();
        if (this.clazz != null && objClazz.equals(this.clazz)) {
            return this.method;
        }
        Method m = this.methodCache.get(objClazz);
        if (m == null) {
            Class<?>[] parameterTypes = this.getParameterTypes(parameterObjects);
            try {
                m = objClazz.getMethod(this.function.getName(), parameterTypes);
            }
            catch (Exception e) {
                throw new OperateException(StringFormater.format((String)"Get method '{}' from class '{}' failed!", (Object[])new Object[]{this.function.getName(), objClazz.getName()}), e);
            }
            this.methodCache.put(objClazz, m);
            this.clazz = objClazz;
            this.method = m;
        }
        return m;
    }

    protected Object[] getParameterObjects(EntityMap entityMap) {
        List<Operand> parameters = this.function.getParameters();
        Object[] parameterObjects = new Object[parameters.size()];
        int i = 0;
        for (Operand param : parameters) {
            Object o = param.operate(entityMap);
            parameterObjects[i++] = o;
        }
        return parameterObjects;
    }

    protected Class<?>[] getParameterTypes(Object[] parameterObjects) {
        Class[] parameterTypes = new Class[parameterObjects.length];
        for (int i = 0; i < parameterObjects.length; ++i) {
            parameterTypes[i] = parameterObjects[i].getClass();
        }
        return parameterTypes;
    }

    @Override
    public Operand getTarget() {
        return this.target;
    }

    @Override
    public Operand getMember() {
        return this.function;
    }
}

