/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.operand.function;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.SemiVariance;
import org.datayoo.moql.EntityMap;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.AggregationFunction;

public class SemiVariance
extends AggregationFunction {
    public static final String FUNCTION_NAME = "semiVariance";
    protected org.apache.commons.math3.stat.descriptive.moment.SemiVariance semiVariance = new org.apache.commons.math3.stat.descriptive.moment.SemiVariance();
    protected double cutoff;
    protected List<Double> numbers = new LinkedList<Double>();

    public SemiVariance(List<Operand> parameters) {
        super(FUNCTION_NAME, 1, parameters);
        if (parameters.size() == 0 || parameters.size() > 3) {
            throw new IllegalArgumentException("Invalid format! The format is 'semiVariance(field, cutoff, [, direction])'");
        }
        if (parameters.size() == 2) {
            this.semiVariance = new org.apache.commons.math3.stat.descriptive.moment.SemiVariance();
        }
    }

    @Override
    public void increment(EntityMap entityMap) {
        Number num;
        Object obj;
        if (this.semiVariance == null) {
            obj = ((Operand)this.parameters.get(1)).operate(entityMap);
            num = this.toNumber(obj);
            this.cutoff = num.doubleValue();
            obj = ((Operand)this.parameters.get(2)).operate(entityMap);
            this.semiVariance = new org.apache.commons.math3.stat.descriptive.moment.SemiVariance(SemiVariance.Direction.valueOf((String)obj.toString()));
        }
        if ((obj = ((Operand)this.parameters.get(0)).operate(entityMap)) == null) {
            return;
        }
        num = this.toNumber(obj);
        this.numbers.add(num.doubleValue());
    }

    @Override
    public Object getValue() {
        double[] values = new double[this.numbers.size()];
        int i = 0;
        for (Double num : this.numbers) {
            values[i++] = num;
        }
        return this.semiVariance.evaluate(values, this.cutoff);
    }

    @Override
    public void clear() {
        this.numbers.clear();
    }
}

