/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.datayoo.moql.io.AbstractResource;

public class FileSystemResource
extends AbstractResource {
    private final File file;

    public FileSystemResource(File file) {
        this.file = file;
    }

    public FileSystemResource(String path) {
        this.file = new File(path);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead() && !this.file.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public URI getURI() throws IOException {
        return this.file.toURI();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getResourceName() {
        return this.file.getName();
    }

    @Override
    public String getResourceLocation() {
        return this.file.getAbsolutePath();
    }

    @Override
    protected File getFile2Check() throws IOException {
        return this.file;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileSystemResource) {
            FileSystemResource fsr = (FileSystemResource)obj;
            return fsr.file.equals(this.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }
}

