/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.metadata;

import java.io.Serializable;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.ColumnDefinition;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.metadata.SelectorValidator;

public class ColumnMetadata
implements ColumnDefinition,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String value;
    protected SelectorDefinition nestedSelector;

    public ColumnMetadata(String name, String value) {
        Validate.notEmpty((String)name, (String)"Parameter 'name' is empty!");
        Validate.notEmpty((String)value, (String)"Parameter 'value' is empty!");
        if (name.indexOf(40) != -1) {
            int index = name.indexOf(44);
            if (index != -1) {
                name = name.substring(0, index);
                name = name + ')';
            }
            name = name.replace(" ", "");
            name = name.replace('(', '$');
            name = name.replace(')', '$');
            name = name.replace('.', '_');
        }
        this.name = name;
        this.value = value;
    }

    public ColumnMetadata(String name, SelectorDefinition nestedSelector) {
        Validate.notEmpty((String)name, (String)"Parameter 'name' is empty!");
        Validate.notNull((Object)nestedSelector, (String)"Parameter 'nestedSelector' is empty!");
        SelectorValidator.isValidateNestedColumnSelector(nestedSelector);
        this.name = name;
        this.nestedSelector = nestedSelector;
        this.value = "";
    }

    public boolean isHasAlias() {
        return !this.name.equals(this.value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public SelectorDefinition getNestedSelector() {
        return this.nestedSelector;
    }
}

