/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.metadata;

import java.io.Serializable;
import org.apache.commons.lang.Validate;
import org.datayoo.moql.SelectorDefinition;
import org.datayoo.moql.metadata.OperationMetadata;
import org.datayoo.moql.metadata.OperatorType;
import org.datayoo.moql.metadata.SelectorValidator;

public class RelationOperationMetadata
extends OperationMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String lOperand;
    protected String rOperand;
    protected SelectorDefinition nestedSelector;

    public RelationOperationMetadata(String operator, String lOperand, String rOperand) {
        super(OperatorType.BINARY, operator);
        Validate.notEmpty((String)lOperand, (String)"Parameter 'lOperand' is null!");
        Validate.notEmpty((String)rOperand, (String)"Parameter 'rOperand' is null!");
        this.operator = operator;
        this.lOperand = lOperand;
        this.rOperand = rOperand;
    }

    public RelationOperationMetadata(String operator, String lOperand, SelectorDefinition nestedSelector) {
        super(OperatorType.BINARY, operator);
        Validate.notEmpty((String)lOperand, (String)"Parameter 'lOperand' is null!");
        Validate.notNull((Object)nestedSelector, (String)"Parameter 'nestedSelector' is null!");
        SelectorValidator.isValidateNestedColumnSelector(nestedSelector);
        this.operator = operator;
        this.lOperand = lOperand;
        this.nestedSelector = nestedSelector;
    }

    public RelationOperationMetadata(String operator, String operand) {
        super(OperatorType.UNARY, operator);
        Validate.notEmpty((String)operand, (String)"Parameter 'operand' is null!");
        this.operator = operator;
        this.rOperand = operand;
    }

    public RelationOperationMetadata(String operator, SelectorDefinition nestedSelector) {
        super(OperatorType.UNARY, operator);
        Validate.notNull((Object)nestedSelector, (String)"Parameter 'nestedSelector' is null!");
        SelectorValidator.isValidateNestedColumnSelector(nestedSelector);
        this.operator = operator;
        this.nestedSelector = nestedSelector;
    }

    public String getLeftOperand() {
        return this.lOperand;
    }

    public String getRightOperand() {
        return this.rOperand;
    }

    public SelectorDefinition getNestedSelector() {
        return this.nestedSelector;
    }
}

