/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.sql.es;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.datayoo.moql.Operand;
import org.datayoo.moql.operand.function.Function;
import org.datayoo.moql.sql.es.AbstractESFunctionTranslator;

public class MoreLikeTranslator
extends AbstractESFunctionTranslator {
    public static final String FUNCTION_NAME = "moreLike";

    public MoreLikeTranslator() {
        super(FUNCTION_NAME);
    }

    @Override
    protected void innerTranslate(Function function, JsonElement jsonObject) {
        if (function.getParameterCount() != 4) {
            throw new IllegalArgumentException("Error function! The moreLike function's format should be moreLike(fields,likeText,minTermFreq,maxQueryTerms)!");
        }
        JsonObject moreLike = new JsonObject();
        List parameters = function.getParameters();
        String fieldString = this.getOperandName((Operand)parameters.get(0));
        String[] fields = fieldString.split(",");
        JsonArray array = new JsonArray();
        for (int i = 0; i < fields.length; ++i) {
            array.add(this.getOperandName(fields[i]));
        }
        moreLike.add("fields", (JsonElement)array);
        moreLike.addProperty("like_text", this.getOperandName((Operand)parameters.get(1)));
        moreLike.addProperty("min_term_freq", (Number)((Long)((Operand)parameters.get(2)).getValue()));
        moreLike.addProperty("max_query_terms", (Number)((Long)((Operand)parameters.get(3)).getValue()));
        this.putObject(jsonObject, "more_like_this", moreLike);
    }
}

