/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.translator;

import java.util.HashMap;
import java.util.Map;
import org.datayoo.moql.Filter;
import org.datayoo.moql.Selector;
import org.datayoo.moql.sql.DB2Translator;
import org.datayoo.moql.sql.MoqlGrammarTranslator;
import org.datayoo.moql.sql.MySQLTranslator;
import org.datayoo.moql.sql.OracleTranslator;
import org.datayoo.moql.sql.PostgreSQLTranslator;
import org.datayoo.moql.sql.SQLServerTranslator;
import org.datayoo.moql.sql.SqlDialectType;
import org.datayoo.moql.sql.SqlTranslator;
import org.datayoo.moql.sql.es.ElasticSearchTranslator;

public abstract class SqlTranslatorHelper {
    public static MoqlGrammarTranslator moqlTranslator;
    public static OracleTranslator oracleTranslator;
    public static SQLServerTranslator sqlserverTranslator;
    public static DB2Translator db2Translator;
    public static MySQLTranslator mysqlTranslator;
    public static PostgreSQLTranslator postgresqlTranslator;
    public static ElasticSearchTranslator elasticSearchTranslator;

    public static String translate2Sql(Selector selector, SqlDialectType dialectType) {
        return SqlTranslatorHelper.translate2Sql(selector, dialectType, new HashMap<String, Object>());
    }

    public static String translate2Sql(Selector selector, SqlDialectType dialectType, Map<String, Object> translationContext) {
        SqlTranslator sqlTranslator;
        if (dialectType.equals((Object)SqlDialectType.MOQL)) {
            sqlTranslator = SqlTranslatorHelper.getMoqlTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.ORACLE)) {
            sqlTranslator = SqlTranslatorHelper.getOracleTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.SQLSERVER)) {
            sqlTranslator = SqlTranslatorHelper.getSQLServerTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.DB2)) {
            sqlTranslator = SqlTranslatorHelper.getDB2Translator();
        } else if (dialectType.equals((Object)SqlDialectType.MYSQL)) {
            sqlTranslator = SqlTranslatorHelper.getMySQLTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.POSTGRESQL)) {
            sqlTranslator = SqlTranslatorHelper.getPostgreSQLTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.ELASTICSEARCH)) {
            sqlTranslator = SqlTranslatorHelper.getElasticSearchTranslator();
        } else {
            throw new UnsupportedOperationException();
        }
        return sqlTranslator.translate2Sql(selector, translationContext);
    }

    public static String translate2Condition(Filter filter, SqlDialectType dialectType) {
        return SqlTranslatorHelper.translate2Condition(filter, dialectType, new HashMap<String, Object>());
    }

    public static String translate2Condition(Filter filter, SqlDialectType dialectType, Map<String, Object> translationContext) {
        MoqlGrammarTranslator sqlTranslator;
        if (dialectType.equals((Object)SqlDialectType.MOQL)) {
            sqlTranslator = SqlTranslatorHelper.getMoqlTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.ORACLE)) {
            sqlTranslator = SqlTranslatorHelper.getOracleTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.SQLSERVER)) {
            sqlTranslator = SqlTranslatorHelper.getSQLServerTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.DB2)) {
            sqlTranslator = SqlTranslatorHelper.getDB2Translator();
        } else if (dialectType.equals((Object)SqlDialectType.MYSQL)) {
            sqlTranslator = SqlTranslatorHelper.getMySQLTranslator();
        } else if (dialectType.equals((Object)SqlDialectType.POSTGRESQL)) {
            sqlTranslator = SqlTranslatorHelper.getPostgreSQLTranslator();
        } else {
            throw new UnsupportedOperationException();
        }
        return sqlTranslator.translate2Condition(filter, translationContext);
    }

    protected static synchronized MoqlGrammarTranslator getMoqlTranslator() {
        if (moqlTranslator == null) {
            moqlTranslator = new MoqlGrammarTranslator();
        }
        return moqlTranslator;
    }

    protected static synchronized OracleTranslator getOracleTranslator() {
        if (oracleTranslator == null) {
            oracleTranslator = new OracleTranslator();
        }
        return oracleTranslator;
    }

    protected static synchronized SQLServerTranslator getSQLServerTranslator() {
        if (sqlserverTranslator == null) {
            sqlserverTranslator = new SQLServerTranslator();
        }
        return sqlserverTranslator;
    }

    protected static synchronized DB2Translator getDB2Translator() {
        if (db2Translator == null) {
            db2Translator = new DB2Translator();
        }
        return db2Translator;
    }

    protected static synchronized MySQLTranslator getMySQLTranslator() {
        if (mysqlTranslator == null) {
            mysqlTranslator = new MySQLTranslator();
        }
        return mysqlTranslator;
    }

    protected static synchronized PostgreSQLTranslator getPostgreSQLTranslator() {
        if (postgresqlTranslator == null) {
            postgresqlTranslator = new PostgreSQLTranslator();
        }
        return postgresqlTranslator;
    }

    protected static synchronized ElasticSearchTranslator getElasticSearchTranslator() {
        if (elasticSearchTranslator == null) {
            elasticSearchTranslator = new ElasticSearchTranslator();
        }
        return elasticSearchTranslator;
    }
}

