/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.optimizer;

import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.function.operator.And;
import com.greenpineyu.fel.function.operator.Or;
import com.greenpineyu.fel.optimizer.ConstOptToken;
import com.greenpineyu.fel.optimizer.Optimizer;
import com.greenpineyu.fel.parser.ConstNode;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.parser.FunNode;
import java.util.List;
import org.antlr.runtime.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstOpti
implements Optimizer {
    @Override
    public FelNode call(FelContext ctx, FelNode node) {
        if (node.stable()) {
            Object value = node.getInterpreter().interpret(ctx, node);
            return this.newConstNode(node, value);
        }
        List<FelNode> children = node.getChildren();
        if (children != null) {
            FunNode n;
            Function fun;
            boolean isLogicOptimized = false;
            if (node instanceof FunNode && (fun = (n = (FunNode)node).getFun()) instanceof And) {
                List<FelNode> args = node.getChildren();
                FelNode left = args.get(0);
                FelNode right = args.get(1);
                boolean isOr = fun instanceof Or;
                Boolean result = isOr;
                FelNode constNode = this.toShortCutConst(node, ctx, left, result);
                if (constNode != null) {
                    return constNode;
                }
                constNode = this.toShortCutConst(node, ctx, right, result);
                if (constNode != null) {
                    return constNode;
                }
            }
            if (!isLogicOptimized) {
                int i = 0;
                while (i < children.size()) {
                    FelNode c = children.get(i);
                    children.set(i, this.call(ctx, c));
                    ++i;
                }
            }
        }
        return node;
    }

    private FelNode toShortCutConst(FelNode node, FelContext ctx, FelNode left, Boolean result) {
        Object leftValue;
        FelNode constNode = null;
        if (left.stable() && result.equals(leftValue = node.getInterpreter().interpret(ctx, left))) {
            constNode = this.newConstNode(node, leftValue);
        }
        return constNode;
    }

    private void setConstValue(List<FelNode> children, FelNode left, Object leftValue) {
        children.remove(1);
        children.set(0, this.newConstNode(left, leftValue));
    }

    private FelNode newConstNode(FelNode node, Object value) {
        ConstOptToken token = new ConstOptToken(node);
        token.setText(node.getText());
        return new ConstNode((Token)token, value);
    }
}

