/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans.projections;

import java.util.List;
import java.util.Map;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.WithEpsgGOperationMethod;

public class PseudoMercator
implements CoordinateOperation,
WithEpsgGOperationMethod {
    private final GeographicCoordinateReferenceSystem baseCrs;
    private final double lonOfNO;
    private final double latOfNO;
    private final double falseE;
    private final double falseN;
    private final double a;

    static CoordinateOperation fromCrsParameters(GeographicCoordinateReferenceSystem base, List<CrsParameter> params) {
        Map<String, CrsParameter> map = CrsParameter.toMap(params);
        double lonOfNO = map.get("central_meridian").getValue();
        double latOfNO = 0.0;
        double falseE = map.get("false_easting").getValue();
        double falseN = map.get("false_northing").getValue();
        return new PseudoMercator(base, latOfNO, lonOfNO, falseE, falseN);
    }

    public PseudoMercator() {
        this(CoordinateReferenceSystems.WGS84, 0.0, 0.0, 0.0, 0.0);
    }

    public PseudoMercator(GeographicCoordinateReferenceSystem baseCrs, double latOfNatOrigin, double lonOfNatOrigin, double falseE, double falseN) {
        this.baseCrs = baseCrs;
        this.latOfNO = latOfNatOrigin;
        this.lonOfNO = lonOfNatOrigin;
        this.falseE = falseE;
        this.falseN = falseN;
        this.a = baseCrs.getDatum().getEllipsoid().getSemiMajorAxis();
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public int inCoordinateDimension() {
        return 2;
    }

    @Override
    public int outCoordinateDimension() {
        return 2;
    }

    @Override
    public void forward(double[] inCoordinate, double[] outCoordinate) {
        double l = Math.toRadians(inCoordinate[0]);
        double p = Math.toRadians(inCoordinate[1]);
        outCoordinate[0] = this.falseE + this.a * (l - this.lonOfNO);
        outCoordinate[1] = this.falseN + this.a * Math.log(Math.tan(0.7853981633974483 + p / 2.0));
    }

    @Override
    public void reverse(double[] inCoordinate, double[] outCoordinate) {
        double d = -(inCoordinate[1] - this.falseN) / this.a;
        double p = 1.5707963267948966 - 2.0 * Math.atan(Math.pow(Math.E, d));
        double l = (inCoordinate[0] - this.falseE) / this.a + this.lonOfNO;
        outCoordinate[0] = Math.toDegrees(l);
        outCoordinate[1] = Math.toDegrees(p);
    }

    @Override
    public int getMethodId() {
        return 1024;
    }
}

