/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import org.glassfish.grizzly.Grizzly;

public class DataStructures {
    private static final Class<?> LTQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        return DataStructures.class.getClassLoader().loadClass(cname).newInstance().getClass();
    }

    public static <T> BlockingQueue<T> getLTQInstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQInstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    static {
        Class<?> c = null;
        try {
            int jver = Integer.valueOf(System.getProperty("java.version").substring(0, 3).replace(".", ""));
            c = DataStructures.getAndVerify(jver > 16 ? "java.util.concurrent.LinkedTransferQueue" : "org.glassfish.grizzly.utils.LinkedTransferQueue");
            Grizzly.logger(DataStructures.class).log(Level.FINE, "USING LTQ class:{0}", c);
        }
        catch (Throwable t) {
            Grizzly.logger(DataStructures.class).log(Level.FINE, "failed loading datastructure class:" + c, t);
        }
        LTQclass = c;
    }
}

