/*
 * Decompiled with CFR 0.152.
 */
package jodd.introspector;

import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.Introspector;

public class CachingIntrospector
implements Introspector {
    protected final Map<Class, ClassDescriptor> cache = new HashMap<Class, ClassDescriptor>();
    protected final boolean scanAccessible;
    protected final boolean enhancedProperties;
    protected final boolean includeFieldsAsProperties;
    protected final String[] propertyFieldPrefix;

    public CachingIntrospector() {
        this(true, true, true, null);
    }

    public CachingIntrospector(boolean scanAccessible, boolean enhancedProperties, boolean includeFieldsAsProperties, String[] propertyFieldPrefix) {
        this.scanAccessible = scanAccessible;
        this.enhancedProperties = enhancedProperties;
        this.includeFieldsAsProperties = includeFieldsAsProperties;
        this.propertyFieldPrefix = propertyFieldPrefix;
    }

    @Override
    public ClassDescriptor lookup(Class type) {
        ClassDescriptor cd = this.cache.get(type);
        if (cd != null) {
            cd.increaseUsageCount();
            return cd;
        }
        cd = this.describeClass(type);
        this.cache.put(type, cd);
        return cd;
    }

    @Override
    public ClassDescriptor register(Class type) {
        ClassDescriptor cd = this.describeClass(type);
        this.cache.put(type, cd);
        return cd;
    }

    protected ClassDescriptor describeClass(Class type) {
        return new ClassDescriptor(type, this.scanAccessible, this.enhancedProperties, this.includeFieldsAsProperties, this.propertyFieldPrefix);
    }

    @Override
    public void reset() {
        this.cache.clear();
    }
}

