/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.conversions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.DataValidationException;
import org.junit.jupiter.params.shadow.com.univocity.parsers.conversions.Conversion;

public class ValidatedConversion
implements Conversion<Object, Object> {
    private final boolean nullable;
    private final boolean allowBlanks;
    private final Set<String> oneOf;
    private final Set<String> noneOf;

    public ValidatedConversion(boolean nullable, boolean allowBlanks) {
        this(nullable, allowBlanks, null, null);
    }

    public ValidatedConversion(boolean nullable, boolean allowBlanks, String[] oneOf, String[] noneOf) {
        this.nullable = nullable;
        this.allowBlanks = allowBlanks;
        this.oneOf = oneOf == null || oneOf.length == 0 ? null : new HashSet<String>(Arrays.asList(oneOf));
        this.noneOf = noneOf == null || noneOf.length == 0 ? null : new HashSet<String>(Arrays.asList(noneOf));
    }

    @Override
    public Object execute(Object input) {
        this.validate(input);
        return input;
    }

    @Override
    public Object revert(Object input) {
        this.validate(input);
        return input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validate(Object value) {
        DataValidationException e = null;
        String str = null;
        if (value == null) {
            if (this.nullable) {
                if (this.noneOf == null || !this.noneOf.contains(null)) return;
                e = new DataValidationException("Value '{value}' is not allowed.");
            } else {
                if (this.oneOf != null && this.oneOf.contains(null)) {
                    return;
                }
                e = new DataValidationException("Null values not allowed.");
            }
        } else {
            str = String.valueOf(value);
            if (str.trim().isEmpty()) {
                if (this.allowBlanks) {
                    if (this.noneOf == null || !this.noneOf.contains(str)) return;
                    e = new DataValidationException("Value '{value}' is not allowed.");
                } else {
                    if (this.oneOf != null && this.oneOf.contains(str)) {
                        return;
                    }
                    e = new DataValidationException("Blanks are not allowed. '{value}' is blank.");
                }
            }
        }
        if (this.oneOf != null && !this.oneOf.contains(str)) {
            e = new DataValidationException("Value '{value}' is not allowed. Expecting one of: " + this.oneOf);
        }
        if (e == null && this.noneOf != null && this.noneOf.contains(str)) {
            e = new DataValidationException("Value '{value}' is not allowed.");
        }
        if (e == null) return;
        e.setValue(value);
        throw e;
    }
}

