/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jxls.common.SheetData;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiTransformer;

public class PoiSheetData
extends SheetData {
    List<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
    Sheet sheet;

    public static PoiSheetData createSheetData(Sheet sheet, PoiTransformer transformer) {
        int i;
        PoiSheetData sheetData = new PoiSheetData();
        sheetData.setTransformer((Transformer)transformer);
        sheetData.sheet = sheet;
        sheetData.sheetName = sheet.getSheetName();
        sheetData.columnWidth = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            sheetData.columnWidth[i2] = sheet.getColumnWidth(i2);
        }
        int numberOfRows = sheet.getLastRowNum() + 1;
        for (i = 0; i < numberOfRows; ++i) {
            sheetData.rowDataList.add(PoiRowData.createRowData(sheet.getRow(i), transformer));
        }
        for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            sheetData.mergedRegions.add(region);
        }
        return sheetData;
    }

    public List<CellRangeAddress> getMergedRegions() {
        return this.mergedRegions;
    }

    public Sheet getSheet() {
        return this.sheet;
    }
}

